/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.util.report.sdu;

import com.complexible.stardog.StardogAgent;
import com.complexible.stardog.util.report.sdu.SDUUsageEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SDUUsageSummary {
    private long mTotalQueries = 0L;
    private long mTotalElapsedTimeMillis = 0L;
    private final Map<String, Map<String, Map<String, Long>>> mElapsedTimeByUser = new HashMap<String, Map<String, Map<String, Long>>>();

    public void addEvent(SDUUsageEvent theEvent, String theFallbackNodeId) {
        String agentKey;
        ++this.mTotalQueries;
        long elapsedTimeMillis = 0L;
        SDUUsageEvent.QueryDetails query = theEvent.getQuery();
        if (query != null) {
            elapsedTimeMillis = query.getElapsedTimeMillis();
            this.mTotalElapsedTimeMillis += elapsedTimeMillis;
        }
        String userStr = theEvent.getUser() != null ? theEvent.getUser() : "unknown";
        String string = agentKey = theEvent.getAgent() != null ? theEvent.getAgent() : StardogAgent.STARDOG_INTERNAL.getHeaderValue();
        String nodeKey = theEvent.getNode() != null ? theEvent.getNode() : (theFallbackNodeId != null ? theFallbackNodeId : "unknown");
        this.mElapsedTimeByUser.computeIfAbsent(userStr, k -> new HashMap()).computeIfAbsent(nodeKey, k -> new HashMap()).merge(agentKey, elapsedTimeMillis, Long::sum);
    }

    public long getTotalQueries() {
        return this.mTotalQueries;
    }

    public double getTotalElapsedTimeSecs() {
        return (double)this.mTotalElapsedTimeMillis / 1000.0;
    }

    public Map<String, Map<String, Map<String, Double>>> getElapsedTimeByUser() {
        HashMap result = new HashMap();
        for (Map.Entry<String, Map<String, Map<String, Long>>> userEntry : this.mElapsedTimeByUser.entrySet()) {
            HashMap nodeMap = new HashMap();
            for (Map.Entry<String, Map<String, Long>> nodeEntry : userEntry.getValue().entrySet()) {
                HashMap<String, Double> agentMap = new HashMap<String, Double>();
                for (Map.Entry<String, Long> agentEntry : nodeEntry.getValue().entrySet()) {
                    agentMap.put(agentEntry.getKey(), (double)agentEntry.getValue().longValue() / 1000.0);
                }
                nodeMap.put(nodeEntry.getKey(), Collections.unmodifiableMap(agentMap));
            }
            result.put(userEntry.getKey(), Collections.unmodifiableMap(nodeMap));
        }
        return Collections.unmodifiableMap(result);
    }

    public void merge(SDUUsageSummary theOther) {
        this.merge(theOther, null);
    }

    public void merge(SDUUsageSummary theOther, String theNodeId) {
        this.mTotalQueries += theOther.mTotalQueries;
        this.mTotalElapsedTimeMillis += theOther.mTotalElapsedTimeMillis;
        boolean useOverrideNode = theNodeId != null;
        for (Map.Entry<String, Map<String, Map<String, Long>>> userEntry : theOther.mElapsedTimeByUser.entrySet()) {
            String user = userEntry.getKey();
            Map<String, Map<String, Long>> otherNodeMap = userEntry.getValue();
            for (Map.Entry<String, Map<String, Long>> nodeEntry : otherNodeMap.entrySet()) {
                String node = useOverrideNode ? theNodeId : nodeEntry.getKey();
                Map<String, Long> otherAgentMap = nodeEntry.getValue();
                for (Map.Entry<String, Long> agentEntry : otherAgentMap.entrySet()) {
                    String agent = agentEntry.getKey();
                    Long timeMillis = agentEntry.getValue();
                    this.mElapsedTimeByUser.computeIfAbsent(user, k -> new HashMap()).computeIfAbsent(node, k -> new HashMap()).merge(agent, timeMillis, Long::sum);
                }
            }
        }
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("totalQueries", this.mTotalQueries);
        result.put("totalElapsedTimeSecs", this.getTotalElapsedTimeSecs());
        result.put("elapsedTimeByUser", this.getElapsedTimeByUser());
        return result;
    }

    public static SDUUsageSummary fromMap(Map<String, Object> theMap) {
        Object elapsedTimeByUser;
        Object totalElapsedTimeSecs;
        SDUUsageSummary aSummary = new SDUUsageSummary();
        Object totalQueries = theMap.get("totalQueries");
        if (totalQueries instanceof Number) {
            aSummary.mTotalQueries = ((Number)totalQueries).longValue();
        }
        if ((totalElapsedTimeSecs = theMap.get("totalElapsedTimeSecs")) instanceof Number) {
            aSummary.mTotalElapsedTimeMillis = Math.round(((Number)totalElapsedTimeSecs).doubleValue() * 1000.0);
        }
        if ((elapsedTimeByUser = theMap.get("elapsedTimeByUser")) instanceof Map) {
            Map userMap = (Map)elapsedTimeByUser;
            for (Map.Entry userEntry : userMap.entrySet()) {
                String user = (String)userEntry.getKey();
                if (!(userEntry.getValue() instanceof Map)) continue;
                Map nodeMap = (Map)userEntry.getValue();
                for (Map.Entry nodeEntry : nodeMap.entrySet()) {
                    String node = (String)nodeEntry.getKey();
                    if (!(nodeEntry.getValue() instanceof Map)) continue;
                    Map agentMap = (Map)nodeEntry.getValue();
                    for (Map.Entry agentEntry : agentMap.entrySet()) {
                        String agent = (String)agentEntry.getKey();
                        if (!(agentEntry.getValue() instanceof Number)) continue;
                        long timeMillis = Math.round(((Number)agentEntry.getValue()).doubleValue() * 1000.0);
                        aSummary.mElapsedTimeByUser.computeIfAbsent(user, k -> new HashMap()).computeIfAbsent(node, k -> new HashMap()).put(agent, timeMillis);
                    }
                }
            }
        }
        return aSummary;
    }
}

