/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.util.report;

import com.complexible.common.base.Numbers;
import com.complexible.stardog.StardogException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class MetricsPrinter {
    public static void printMetrics(PrintStream theOut, Map<String, Object> theMetrics, List<String> theSelectedMetricPatterns) throws StardogException {
        if (theSelectedMetricPatterns == null) {
            theSelectedMetricPatterns = new ArrayList<String>();
        }
        if (theSelectedMetricPatterns.isEmpty()) {
            theSelectedMetricPatterns.add(".*");
        }
        TreeMap<String, Object> metricsToPrint = new TreeMap<String, Object>();
        for (String metricPattern : theSelectedMetricPatterns) {
            Pattern p = Pattern.compile(metricPattern);
            MutableBoolean patternMatchesAnyMetric = new MutableBoolean(false);
            theMetrics.forEach((metric, v) -> MetricsPrinter.addMetricsToPrint(metric, v, p, patternMatchesAnyMetric, metricsToPrint));
            if (patternMatchesAnyMetric.getValue().booleanValue()) continue;
            throw new StardogException("Pattern " + metricPattern + " doesn't match any metric. Typo?");
        }
        metricsToPrint.forEach((metric, v) -> theOut.printf("%-25s: %s%n", metric, Numbers.formatIfIntegral((Object)v)));
        theOut.flush();
    }

    private static void addMetricsToPrint(String metric, Object value, Pattern metricPattern, MutableBoolean patternMatchesAnyMetric, TreeMap<String, Object> metricsToPrint) {
        if (value instanceof Map) {
            ((Map)value).forEach((k, v) -> MetricsPrinter.addMetricsToPrint(metric + "." + String.valueOf(k), v, metricPattern, patternMatchesAnyMetric, metricsToPrint));
        } else if (value != null && metricPattern.matcher(metric).matches()) {
            metricsToPrint.put(metric, value);
            patternMatchesAnyMetric.setTrue();
        }
    }
}

