/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.util.report;

import com.complexible.common.base.Memory;
import com.complexible.common.base.Numbers;
import com.complexible.common.base.Option;
import com.complexible.common.io.Files2;
import com.complexible.stardog.logging.LogOptions;
import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.Lists;
import com.google.common.io.MoreFiles;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogRetriever.class);
    private final Path home;
    private final com.complexible.common.base.Options options;
    private static final Pattern SPECIAL_REGEX_CHARS = Pattern.compile("[{}()\\[\\].+*?^$\\\\|]");

    public LogRetriever(Path theHome, com.complexible.common.base.Options theOptions) {
        this.home = theHome;
        this.options = theOptions;
    }

    private void verifyOptions() {
        Integer lineCount = (Integer)this.options.get(Options.LINE_COUNT);
        if (lineCount != null) {
            Preconditions.checkArgument((lineCount > 0 ? 1 : 0) != 0, (String)"Line count must be positive: %s", (Object)lineCount);
            Preconditions.checkArgument((lineCount <= 1000000 ? 1 : 0) != 0, (String)"Line count must be less then %s", (Object)Numbers.readable((long)1000000L));
            Preconditions.checkArgument((!this.options.is(Options.INCLUDE_ROTATED_LOGS) ? 1 : 0) != 0, (Object)"Rotated logs cannot be returned when line count is specified");
            if (((Set)this.options.get(Options.LOG_TYPES)).contains((Object)LogType.AUDIT)) {
                Preconditions.checkArgument((boolean)"json".equalsIgnoreCase((String)this.options.get(LogOptions.LOG_AUDIT_TYPE)), (String)"Line count can only be used when %s is set to json", LogOptions.LOG_AUDIT_TYPE);
            }
        }
    }

    public Path createZip() throws Exception {
        this.verifyOptions();
        Path outputPath = Files.createTempFile("stardog-logs", ".zip", new FileAttribute[0]);
        try (ZipOutputStream zip = new ZipOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));){
            DirectoryStream.Filter<Path> filter = this.getFileFilter();
            Files2.listFilesRecursively((Path)this.home, filter).forEach(f -> this.addLogFile(zip, (Path)f));
        }
        LOGGER.debug("Written {} bytes to {}", (Object)Memory.readable((long)Files.size(outputPath)), (Object)outputPath);
        return outputPath;
    }

    private DirectoryStream.Filter<Path> getFileFilter() {
        ArrayList filters = Lists.newArrayList();
        this.addStardogLogs(filters);
        this.addStarrocksLogs(filters);
        this.addAuditLogs(filters);
        this.addSDUUsageLogs(filters);
        this.addGcLogs(filters);
        Pattern pattern = Pattern.compile(String.join((CharSequence)"|", filters));
        LOGGER.debug("Log retrieval pattern {}", (Object)pattern);
        return file -> {
            boolean matches = pattern.matcher(file.getFileName().toString()).matches();
            LOGGER.debug("File {} matches pattern: {}", (Object)file.getFileName(), (Object)matches);
            return matches;
        };
    }

    private void addStardogLogs(List<String> filters) {
        if (((Set)this.options.get(Options.LOG_TYPES)).contains((Object)LogType.STARDOG)) {
            Map appenders = LoggerContext.getContext().getConfiguration().getAppenders();
            for (Appender appender : appenders.values()) {
                Path file;
                if (appender instanceof FileAppender) {
                    file = Paths.get(((FileAppender)appender).getFileName(), new String[0]);
                    if (!Files.exists(file, new LinkOption[0])) continue;
                    filters.add(Pattern.quote(file.getFileName().toString()));
                    if (!this.options.is(Options.INCLUDE_ROTATED_LOGS)) continue;
                    filters.add(String.valueOf(file.getFileName()) + ".+");
                    continue;
                }
                if (!(appender instanceof RollingFileAppender) || !Files.exists(file = Paths.get(((RollingFileAppender)appender).getFileName(), new String[0]), new LinkOption[0])) continue;
                filters.add(Pattern.quote(file.getFileName().toString()));
                if (!this.options.is(Options.INCLUDE_ROTATED_LOGS)) continue;
                String filePattern = StringUtils.substringAfterLast((String)((RollingFileAppender)appender).getFilePattern(), (String)StandardSystemProperty.FILE_SEPARATOR.value());
                filters.add(LogRetriever.convertLog4jPatternToRegex(filePattern));
            }
            if (filters.isEmpty()) {
                filters.add(Pattern.quote("stardog.log"));
                if (this.options.is(Options.INCLUDE_ROTATED_LOGS)) {
                    filters.add("stardog.*\\.log.*");
                }
            }
        }
    }

    private void addStarrocksLogs(List<String> filters) {
        if (((Set)this.options.get(Options.LOG_TYPES)).contains((Object)LogType.STARROCKS)) {
            filters.add(Pattern.quote("starrocks.log"));
            filters.add(Pattern.quote("LOG"));
            if (this.options.is(Options.INCLUDE_ROTATED_LOGS)) {
                filters.add("starrocks\\.log.+");
                filters.add("LOG\\.old\\..+");
            }
        }
    }

    private void addAuditLogs(List<String> filters) {
        if (((Set)this.options.get(Options.LOG_TYPES)).contains((Object)LogType.AUDIT)) {
            String auditLog = (String)this.options.get(LogOptions.LOG_AUDIT_FILE);
            filters.add(Pattern.quote(auditLog));
            if (this.options.is(Options.INCLUDE_ROTATED_LOGS)) {
                filters.add(auditLog + ".+");
            }
        }
    }

    private void addSDUUsageLogs(List<String> filters) {
        if (((Set)this.options.get(Options.LOG_TYPES)).contains((Object)LogType.SDU_USAGE)) {
            String sduUsageLog = (String)this.options.get(LogOptions.LOG_SDU_USAGE_FILE);
            filters.add(Pattern.quote(sduUsageLog));
            if (this.options.is(Options.INCLUDE_ROTATED_LOGS)) {
                filters.add(sduUsageLog + ".+");
            }
        }
    }

    private void addGcLogs(List<String> filters) {
        if (((Set)this.options.get(Options.LOG_TYPES)).contains((Object)LogType.GC)) {
            filters.add(Pattern.quote("gc.log"));
            if (this.options.is(Options.INCLUDE_ROTATED_LOGS)) {
                filters.add("gc\\.log.+");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLogFile(ZipOutputStream theZip, Path sourceFile) {
        if (!Files.isRegularFile(sourceFile, new LinkOption[0])) {
            return;
        }
        Integer lineCount = (Integer)this.options.get(Options.LINE_COUNT);
        try {
            Path destPath = this.home.relativize(sourceFile);
            LOGGER.debug("Adding log file {} as {}", (Object)sourceFile, (Object)destPath);
            ZipEntry aZipEntry = new ZipEntry(destPath.toString());
            theZip.putNextEntry(aZipEntry);
            if (lineCount == null) {
                MoreFiles.asByteSource((Path)sourceFile, (OpenOption[])new OpenOption[0]).copyTo((OutputStream)theZip);
            } else {
                PrintStream out = new PrintStream(theZip);
                try (ReversedLinesFileReader reader = ((ReversedLinesFileReader.Builder)((ReversedLinesFileReader.Builder)ReversedLinesFileReader.builder().setPath(sourceFile)).setCharset(StandardCharsets.UTF_8)).get();){
                    List lines = reader.readLines(lineCount.intValue());
                    int size = lines.size();
                    ListIterator it = lines.listIterator(size);
                    Stream.generate(it::previous).limit(size).forEach(out::println);
                }
                finally {
                    out.flush();
                }
            }
            theZip.closeEntry();
        }
        catch (IOException e) {
            LOGGER.warn("Cannot retrieve log file " + String.valueOf(sourceFile), (Throwable)e);
        }
    }

    public static String convertLog4jPatternToRegex(String filePattern) {
        String datePlaceholder = "_DATE_";
        String numberPlaceholder = "_NUM_";
        String regex = filePattern;
        regex = regex.replaceAll("%(d|date)\\{.*?\\}", datePlaceholder).replaceAll("%i", numberPlaceholder);
        regex = SPECIAL_REGEX_CHARS.matcher(regex).replaceAll("\\\\$0");
        regex = regex.replace(datePlaceholder, ".*").replace(numberPlaceholder, "\\d+");
        return "^" + regex + "$";
    }

    public static class Options {
        public static final Option<String> OUTPUT_FILE = Option.create((String)"log.output.file");
        public static final Option<Set<LogType>> LOG_TYPES = Option.create((String)"log.types", EnumSet.of(LogType.STARDOG, LogType.STARROCKS, LogType.GC));
        public static final Option<Boolean> INCLUDE_ROTATED_LOGS = Option.create((String)"log.rotated", (Object)false);
        public static final Option<Integer> LINE_COUNT = Option.create((String)"log.line.count");
        public static final int MAX_LINE_COUNT = 1000000;
    }

    public static enum LogType {
        STARDOG,
        STARROCKS,
        AUDIT,
        SDU_USAGE,
        GC;

    }
}

