/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.util;

import com.stardog.stark.Values;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.TimeUnit;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;

public class DurationUtils {
    public static long toMonths(Duration theDuration) {
        return theDuration.getSign() * (12 * theDuration.getYears() + theDuration.getMonths());
    }

    public static long toMillis(Duration theDuration) {
        BigDecimal aSeconds = (BigDecimal)theDuration.getField(DatatypeConstants.SECONDS);
        int aMillis = 0;
        if (aSeconds != null) {
            aMillis = aSeconds.movePointRight(3).intValue();
        }
        return (long)theDuration.getSign() * (TimeUnit.DAYS.toMillis(theDuration.getDays()) + TimeUnit.HOURS.toMillis(theDuration.getHours()) + TimeUnit.MINUTES.toMillis(theDuration.getMinutes()) + (long)aMillis);
    }

    public static Duration newDurationYearMonth(long theMonths) {
        boolean isPositive = theMonths > 0L;
        theMonths = Math.abs(theMonths);
        return DurationUtils.newDurationYearMonth(isPositive, theMonths / 12L, theMonths % 12L);
    }

    public static Duration newDurationYearMonth(boolean isPositive, long theYear, long theMonth) {
        BigInteger aYear;
        BigInteger bigInteger = aYear = theYear == 0L ? null : BigInteger.valueOf(theYear);
        BigInteger aMonth = theMonth == 0L ? (theYear != 0L ? null : BigInteger.ZERO) : BigInteger.valueOf(theMonth);
        return Values.DATATYPE_FACTORY.newDurationYearMonth(isPositive, aYear, aMonth);
    }

    public static Duration newDurationDayTime(long durationInMilliSeconds) {
        long s;
        boolean isPositive;
        long l = durationInMilliSeconds;
        if (l == 0L) {
            return Values.DATATYPE_FACTORY.newDuration(true, null, null, null, null, null, BigDecimal.ZERO);
        }
        boolean is0x8000000000000000L = false;
        boolean bl = isPositive = l >= 0L;
        if (!isPositive) {
            if (l == Long.MIN_VALUE) {
                ++l;
                is0x8000000000000000L = true;
            }
            l *= -1L;
        }
        BigDecimal seconds = (s = l % 60000L + (long)(is0x8000000000000000L ? 1 : 0)) == 0L ? null : (s % 1000L == 0L ? BigDecimal.valueOf(s / 1000L) : BigDecimal.valueOf(s, 3));
        long m = (l /= 60000L) % 60L;
        BigInteger minutes = m == 0L ? null : BigInteger.valueOf(m);
        long h = (l /= 60L) % 24L;
        BigInteger hours = h == 0L ? null : BigInteger.valueOf(h);
        BigInteger days = (l /= 24L) == 0L ? null : BigInteger.valueOf(l);
        return Values.DATATYPE_FACTORY.newDuration(isPositive, null, null, days, hours, minutes, seconds);
    }

    public static OrderedDurationType getOrderedDurationType(Duration theDuration) {
        if (theDuration == null) {
            return null;
        }
        boolean yearSet = theDuration.isSet(DatatypeConstants.YEARS);
        boolean monthSet = theDuration.isSet(DatatypeConstants.MONTHS);
        if (!yearSet && !monthSet) {
            return OrderedDurationType.DAY_TIME;
        }
        boolean daySet = theDuration.isSet(DatatypeConstants.DAYS);
        boolean hourSet = theDuration.isSet(DatatypeConstants.HOURS);
        boolean minuteSet = theDuration.isSet(DatatypeConstants.MINUTES);
        boolean secondSet = theDuration.isSet(DatatypeConstants.SECONDS);
        if (!(daySet || hourSet || minuteSet || secondSet)) {
            return OrderedDurationType.YEAR_MONTH;
        }
        return null;
    }

    public static enum OrderedDurationType {
        YEAR_MONTH,
        DAY_TIME;

    }
}

