/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.security;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;

public final class Shroud {
    private final UUID mDefaultPad = new UUID(-1774107057469307100L, -5085536540702663583L);
    private byte[] mPad;

    public Shroud() {
        this.mPad = Shroud.uuidToBytes(this.mDefaultPad);
    }

    public Shroud(UUID padUuid) {
        this.mPad = Shroud.uuidToBytes(padUuid == null ? this.mDefaultPad : padUuid);
    }

    public String shroudString(String input) {
        byte[] shroudedBytes = this.shroudStringToBytes(input);
        return Base64.getEncoder().encodeToString(shroudedBytes);
    }

    public String shroudByteArray(byte[] input) {
        byte[] shroudedBytes = this.shroudBytes(input);
        return Base64.getEncoder().encodeToString(shroudedBytes);
    }

    public String unshroudString(String input) {
        byte[] decodedBytes = Base64.getDecoder().decode(input);
        return this.unshroudStringFromBytes(decodedBytes);
    }

    public byte[] unshroudByteArray(String input) {
        byte[] decodedBytes = Base64.getDecoder().decode(input);
        return this.unshroudBytes(decodedBytes);
    }

    byte[] shroudStringToBytes(String input) {
        return this.shroudBytes(input.getBytes(StandardCharsets.UTF_8));
    }

    String unshroudStringFromBytes(byte[] input) {
        byte[] strBytes = this.unshroudBytes(input);
        return new String(strBytes, StandardCharsets.UTF_8);
    }

    byte[] shroudBytes(byte[] input) {
        byte[] output = new byte[input.length];
        int k = 0;
        for (int j = 0; j < input.length; ++j) {
            output[j] = (byte)(input[j] ^ this.mPad[k]);
            if (++k < this.mPad.length) continue;
            k = 0;
        }
        return output;
    }

    byte[] unshroudBytes(byte[] input) {
        return this.shroudBytes(input);
    }

    private static byte[] uuidToBytes(UUID uuid) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        return byteBuffer.array();
    }
}

