/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.security;

import com.complexible.common.io.ByteReader;
import com.complexible.common.io.ByteWriter;
import com.complexible.stardog.metadata.ByteIO;
import com.complexible.stardog.metadata.GraphIO;
import com.complexible.stardog.metadata.TextIO;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public final class SensitiveProperty {
    public static final String DEFAULT_GROUP = "";
    private final String group;
    private final IRI iri;
    private static final Splitter mSplitter = Splitter.on((char)'=').limit(2);
    public static final TextIO<SensitiveProperty> TEXT_IO = new TextIO<SensitiveProperty>(){

        @Override
        public SensitiveProperty _read(String theValue) {
            String[] aStr = (String[])Iterables.toArray((Iterable)mSplitter.split((CharSequence)theValue), String.class);
            if (aStr.length != 2) {
                throw new IllegalArgumentException("Not a valid prefix definition: " + theValue);
            }
            return new SensitiveProperty(aStr[0], Values.iri((String)aStr[1]));
        }

        @Override
        public String _write(SensitiveProperty theValue) {
            return theValue.getGroup() + "=" + String.valueOf(theValue.getIRI());
        }
    };
    public static final GraphIO<SensitiveProperty> GRAPH_IO = new GraphIO<SensitiveProperty>(){

        @Override
        public SensitiveProperty read(Value theValue, Set<Statement> theGraph) {
            Literal aLiteral = (Literal)theValue;
            String aSchema = aLiteral.label();
            IRI aGraph = aLiteral.datatypeIRI();
            return new SensitiveProperty(aSchema, aGraph);
        }

        @Override
        public Value _write(SensitiveProperty theValue, Set<Statement> theGraph, Supplier<IRI> theValueGenerator) {
            return Values.literal((String)theValue.getGroup(), (IRI)theValue.getIRI());
        }
    };
    public static final ByteIO<SensitiveProperty> BYTE_IO = new ByteIO<SensitiveProperty>(){

        @Override
        public SensitiveProperty read(ByteReader theReader) throws IOException {
            return new SensitiveProperty(theReader.readString(), Values.iri((String)theReader.readString()));
        }

        @Override
        public void write(SensitiveProperty theValue, ByteWriter theByteWriter) throws IOException {
            theByteWriter.writeString(theValue.getGroup());
            theByteWriter.writeString(theValue.getIRI().toString());
        }
    };

    public SensitiveProperty(String theGroup, IRI theProp) {
        this.group = Objects.requireNonNull(theGroup);
        this.iri = Objects.requireNonNull(theProp);
    }

    public String getGroup() {
        return this.group;
    }

    public IRI getIRI() {
        return this.iri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SensitiveProperty property = (SensitiveProperty)o;
        if (!this.group.equals(property.group)) {
            return false;
        }
        return this.iri.equals((Object)property.iri);
    }

    public int hashCode() {
        int result = this.group.hashCode();
        result = 31 * result + this.iri.hashCode();
        return result;
    }

    public String toString() {
        return "(" + this.group + ", " + String.valueOf(this.iri) + ")";
    }
}

