/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.security;

import com.complexible.stardog.security.IllegalPasswordException;
import com.complexible.stardog.security.ResourceExistsException;
import com.complexible.stardog.security.ResourceInUseException;
import com.complexible.stardog.security.ResourceInvalidNameException;
import com.complexible.stardog.security.ResourceInvalidTypeException;
import com.complexible.stardog.security.ResourceNotFoundException;
import com.complexible.stardog.security.StardogAuthenticationException;
import com.complexible.stardog.security.StardogAuthorizationException;
import com.complexible.stardog.security.StardogSecurityException;
import com.complexible.stardog.server.IncorrectPrincipalTransactionException;
import com.stardog.ErrorCode;
import com.stardog.SkeletonErrorParser;

public class SecurityErrorParser
extends SkeletonErrorParser {
    public static String SECURITY_PREFIX = "SE";

    protected Throwable toThrowable(ErrorCode thePec, String theErrorMsg) {
        return ((SecurityErrorCode)thePec).toThrowable(theErrorMsg);
    }

    protected boolean canBeParsed(String theErrorCode) {
        return theErrorCode.startsWith(SECURITY_PREFIX);
    }

    protected ErrorCode[] getErrorCodes() {
        return SecurityErrorCode.values();
    }

    protected boolean codeMatches(ErrorCode thePec, Throwable theT) {
        return ((SecurityErrorCode)thePec).applies(theT);
    }

    public static enum SecurityErrorCode implements ErrorCode
    {
        ILLEGAL_PASSWORD("0IP", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            Throwable toThrowable(String msg) {
                return new IllegalPasswordException(msg);
            }

            @Override
            boolean applies(Throwable t) {
                return t instanceof IllegalPasswordException;
            }
        }
        ,
        INCORRECT_PRINCIPAL_TRANSACTION("IPT", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            Throwable toThrowable(String msg) {
                return new IncorrectPrincipalTransactionException(msg);
            }

            @Override
            boolean applies(Throwable t) {
                return t instanceof IncorrectPrincipalTransactionException;
            }
        }
        ,
        SECURITY_RESOURCE_EXISTS("0RE", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            Throwable toThrowable(String msg) {
                return new ResourceExistsException(msg);
            }

            @Override
            boolean applies(Throwable t) {
                return t instanceof ResourceExistsException;
            }
        }
        ,
        SECURITY_RESOURCE_IN_USE("RIU", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            Throwable toThrowable(String msg) {
                return new ResourceInUseException(msg);
            }

            @Override
            boolean applies(Throwable t) {
                return t instanceof ResourceInUseException;
            }
        }
        ,
        SECURITY_RESOURCE_TYPE_INVALID("RTI", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            Throwable toThrowable(String msg) {
                return new ResourceInvalidTypeException(msg);
            }

            @Override
            boolean applies(Throwable t) {
                return t instanceof ResourceInvalidTypeException;
            }
        }
        ,
        SECURITY_RESOURCE_NAME_INVALID("RNI", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            Throwable toThrowable(String msg) {
                return new ResourceInvalidNameException(msg);
            }

            @Override
            boolean applies(Throwable t) {
                return t instanceof ResourceInvalidNameException;
            }
        }
        ,
        SECURITY_RESOURCE_NOT_FOUND("RNF", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            Throwable toThrowable(String msg) {
                return new ResourceNotFoundException(msg);
            }

            @Override
            boolean applies(Throwable t) {
                return t instanceof ResourceNotFoundException;
            }
        }
        ,
        AUTHENTICATION_EXCEPTION("AEE", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            Throwable toThrowable(String msg) {
                return new StardogAuthenticationException(msg);
            }

            @Override
            boolean applies(Throwable t) {
                return t instanceof StardogAuthenticationException;
            }
        }
        ,
        AUTHORIZATION_EXCEPTION("AOE", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            Throwable toThrowable(String msg) {
                return new StardogAuthorizationException(msg);
            }

            @Override
            boolean applies(Throwable t) {
                return t instanceof StardogAuthorizationException;
            }
        }
        ,
        UNKNOWN_SECURITY_EXCEPTION("001", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            Throwable toThrowable(String msg) {
                return new StardogSecurityException(msg);
            }

            @Override
            boolean applies(Throwable t) {
                return t instanceof StardogSecurityException;
            }
        };

        private final String formattedCode;
        private final ErrorCode.Severity severity;

        private SecurityErrorCode(String formattedCode, ErrorCode.Severity severity) {
            this.formattedCode = SECURITY_PREFIX + formattedCode + severity.getEncodedString();
            this.severity = severity;
        }

        public String getFormattedString() {
            return this.formattedCode;
        }

        public ErrorCode.Severity getSeverity() {
            return this.severity;
        }

        public String getCategory() {
            return SECURITY_PREFIX;
        }

        abstract Throwable toThrowable(String var1);

        abstract boolean applies(Throwable var1);
    }
}

