/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.security;

import com.complexible.stardog.security.ActionType;
import com.complexible.stardog.security.CoreResourceType;
import com.complexible.stardog.security.ResourceInvalidNameException;
import com.complexible.stardog.security.SecurityResourceType;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;

public final class Permission
implements Serializable {
    private static final long serialVersionUID = -7171637425581962586L;
    private static Pattern resourceNamePattern = null;
    private final CoreResourceType mSubjectType;
    private final String mSubject;
    private final ActionType mActionType;
    private final SecurityResourceType mResourceType;
    private final ImmutableList<String> mResources;

    public Permission(String theSubject, ActionType theActionType, SecurityResourceType theResourceType, ImmutableList<String> theResourceNames) {
        this(theSubject, theActionType, CoreResourceType.ALL, theResourceType, theResourceNames);
    }

    public Permission(String theSubject, ActionType theActionType, CoreResourceType theSubjectType, SecurityResourceType theResourceType, ImmutableList<String> theResourceNames) {
        this.mSubjectType = theSubjectType;
        this.mSubject = (String)Preconditions.checkNotNull((Object)theSubject);
        this.mActionType = (ActionType)((Object)Preconditions.checkNotNull((Object)((Object)theActionType)));
        this.mResourceType = (SecurityResourceType)Preconditions.checkNotNull((Object)theResourceType);
        this.mResources = (ImmutableList)Preconditions.checkNotNull(theResourceNames);
        Preconditions.checkArgument((!theResourceNames.isEmpty() ? 1 : 0) != 0, (Object)"Must provide at least one resource name");
        if (resourceNamePattern != null) {
            theResourceNames.stream().filter(it -> !resourceNamePattern.matcher((CharSequence)it).matches()).findAny().ifPresent(r -> {
                throw new ResourceInvalidNameException("Invalid resource name: " + r);
            });
        }
    }

    public static void setResourceNamePattern(Pattern theResourceNamePattern) {
        Preconditions.checkNotNull((Object)theResourceNamePattern, (Object)"Resource name regex must not be null");
        resourceNamePattern = theResourceNamePattern;
    }

    public CoreResourceType getSubjectType() {
        return this.mSubjectType;
    }

    public String getSubject() {
        return this.mSubject;
    }

    public ActionType getActionType() {
        return this.mActionType;
    }

    public List<String> getResourceNames() {
        return this.mResources;
    }

    public SecurityResourceType getResourceType() {
        return this.mResourceType;
    }

    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null || this.getClass() != theObj.getClass()) {
            return false;
        }
        Permission aPerm = (Permission)theObj;
        return Objects.equal((Object)this.mSubject, (Object)aPerm.mSubject) && Objects.equal((Object)((Object)this.mActionType), (Object)((Object)aPerm.mActionType)) && Objects.equal((Object)this.mResourceType, (Object)aPerm.mResourceType) && Objects.equal(this.mResources, aPerm.mResources);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mSubject, this.mActionType, this.mResourceType, this.mResources});
    }

    public String toString() {
        return String.format("%s:%s:%s:%s", new Object[]{this.mSubject, this.mActionType, this.mResourceType, Joiner.on((char)'\\').join(this.mResources)});
    }
}

