/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.security;

import com.complexible.stardog.Environment;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PasswordFile {
    static final Logger LOGGER = LoggerFactory.getLogger(PasswordFile.class);
    public static final String SERVICES_FILENAME = "services.sdpass";
    public static final String SERVICES_FILENAME_PROPERTY = "stardog.services.sdpass";
    private final List<PasswordFileEntry> mEntries;
    private final List<String> mParseErrors;

    public static Optional<PasswordFile> get() {
        PasswordFile aPf;
        String aPath;
        String aHomePath = System.getProperty("user.home");
        File aUserHomeDir = new File(aHomePath);
        File aPwdFile = SystemUtils.IS_OS_WINDOWS ? new File(aUserHomeDir, "Application Data\\stardog\\sdpass.conf") : new File(aUserHomeDir, ".sdpass");
        if (!aPwdFile.exists() && (aPath = System.getProperty("stardog.passwd.file", null)) != null) {
            aPwdFile = new File(aPath);
        }
        Optional<Object> aPasswordFile = aPwdFile.exists() ? ((aPf = PasswordFile.parse(aPwdFile)).equals(PasswordFile.empty()) ? Optional.empty() : Optional.of(aPf)) : Optional.empty();
        return aPasswordFile;
    }

    public static PasswordFile getServicesFile() {
        File aServicesFile = new File(Environment.getHome(), SERVICES_FILENAME);
        if (aServicesFile.exists()) {
            return PasswordFile.parse(aServicesFile);
        }
        String aPath = System.getProperty(SERVICES_FILENAME_PROPERTY, null);
        if (aPath != null) {
            return PasswordFile.parse(new File(aPath));
        }
        return PasswordFile.empty();
    }

    private static PasswordFile parse(File aFile) {
        PasswordFile aPwdFile = PasswordFile.empty();
        try {
            aPwdFile = new PasswordFile(aFile);
            if (aPwdFile.hasParseErrors()) {
                LOGGER.error("There were parse errors reading the password file", (Object)Joiner.on((String)"\n").join(aPwdFile.getParseErrors()));
            }
        }
        catch (IOException e) {
            LOGGER.error("There was an error reading the password file", (Throwable)e);
        }
        return aPwdFile;
    }

    @VisibleForTesting
    PasswordFile(File theFile) throws IOException {
        EntryReader aReader = new EntryReader();
        try (Stream<String> aLines = Files.lines(theFile.toPath(), Charset.defaultCharset());){
            for (String aLine : aLines::iterator) {
                aReader.processLine(aLine);
            }
        }
        this.mEntries = aReader.getResult();
        this.mParseErrors = aReader.getErrors();
    }

    private PasswordFile(Reader theReader) throws IOException {
        EntryReader processor = new EntryReader();
        CharStreams.readLines((Readable)theReader, (LineProcessor)processor);
        this.mEntries = processor.getResult();
        this.mParseErrors = processor.getErrors();
    }

    private PasswordFile() {
        this.mEntries = Collections.emptyList();
        this.mParseErrors = Collections.emptyList();
    }

    public static PasswordFile empty() {
        return new PasswordFile();
    }

    public static PasswordFile read(File theFile) throws IOException {
        return new PasswordFile(theFile);
    }

    public static PasswordFile read(Reader theReader) throws IOException {
        return new PasswordFile(theReader);
    }

    @VisibleForTesting
    boolean hasParseErrors() {
        return !this.mParseErrors.isEmpty();
    }

    private List<String> getParseErrors() {
        return this.mParseErrors;
    }

    @VisibleForTesting
    PasswordFileEntryParseException parseErrors() throws PasswordFileEntryParseException {
        if (!this.hasParseErrors()) {
            throw new IllegalStateException();
        }
        throw new PasswordFileEntryParseException(Joiner.on((String)"\n").join(this.mParseErrors));
    }

    public Optional<PasswordAuthentication> getCredentials(URI theURI, String theDb) {
        return this.getCredentials(theURI, theDb, null);
    }

    public Optional<PasswordAuthentication> getCredentials(String theURI, String theDb, String theUser) {
        try {
            return this.getCredentials(new URI(theURI), theDb, theUser);
        }
        catch (URISyntaxException e) {
            LOGGER.error("Server URL provided to password file was not valid", (Throwable)e);
            return Optional.empty();
        }
    }

    public Optional<PasswordAuthentication> getCredentials(URI theURI, String theDb, String theUser) {
        return this.getCredentials(theURI.getHost(), theURI.getPort(), theDb, theUser);
    }

    public Optional<PasswordAuthentication> getCredentials(String theHost, int thePort, String theDb, String theUser) {
        for (PasswordFileEntry aEntry : this.mEntries) {
            if (aEntry.getProtocol().equals("s3") || !PasswordFile.isWildcard(aEntry.getHostName()) && !Objects.equals(theHost, aEntry.getHostName()) || aEntry.getPort() != -1 && aEntry.getPort() != thePort || !(PasswordFile.isWildcard(aEntry.getDatabase()) && theDb != null || !PasswordFile.isWildcard(aEntry.getDatabase()) && theDb == null) && !Objects.equals(this.nullToWC(theDb), aEntry.getDatabase()) || !(PasswordFile.isWildcard(aEntry.getUser()) && theUser != null || !PasswordFile.isWildcard(aEntry.getUser()) && theUser == null) && !Objects.equals(theUser, aEntry.getUser())) continue;
            return Optional.of(aEntry.getCredentials(theUser));
        }
        return Optional.empty();
    }

    public Optional<S3Authorization> getS3Auth(URI theURI, String theDateTime) throws IOException {
        String aHost = theURI.getHost();
        int aPort = theURI.getPort();
        String[] aPathElements = theURI.getPath().substring(1).split("/");
        if (aPathElements.length < 2) {
            return Optional.empty();
        }
        String aPathBucket = aPathElements[0];
        String aPathResource = theURI.getPath().substring(StringUtils.ordinalIndexOf((CharSequence)theURI.getPath(), (CharSequence)"/", (int)2) + 1);
        for (PasswordFileEntry aEntry : this.mEntries) {
            if (!aEntry.getProtocol().equals("s3")) continue;
            String aBucket = aEntry.getDatabase();
            String aAccessKey = aEntry.getUser();
            String aSecret = aEntry.getPassword();
            if (!PasswordFile.isWildcard(aEntry.getHostName()) && !Objects.equals(aHost, aEntry.getHostName()) || aEntry.getPort() != -1 && aEntry.getPort() != aPort || !PasswordFile.isWildcard(aBucket) && !aBucket.equals(aPathBucket)) continue;
            String UTF8 = "UTF-8";
            String HMACSHA1 = "HmacSHA1";
            String aCanonicalizedAmzHeaders = String.format("x-amz-date:%s", theDateTime);
            String aCanonicalizedResource = theURI.getPath();
            String aStringToSign = String.format("GET%n%n%n%n%s%n%s", aCanonicalizedAmzHeaders, aCanonicalizedResource);
            try {
                SecretKeySpec signingKey = new SecretKeySpec(aSecret.getBytes("UTF-8"), "HmacSHA1");
                Mac mac = Mac.getInstance("HmacSHA1");
                mac.init(signingKey);
                byte[] aHmacEncoded = mac.doFinal(aStringToSign.getBytes());
                String aSignature = Base64.getEncoder().encodeToString(aHmacEncoded);
                String aHeader = String.format("AWS %s:%s", aAccessKey, aSignature);
                return Optional.of(new S3Authorization(aEntry.getHostName(), aEntry.getPort(), aPathBucket, aPathResource, aAccessKey, aSecret, aHeader));
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
        }
        return Optional.empty();
    }

    private String nullToWC(String theStr) {
        return theStr != null ? theStr : "*";
    }

    public int size() {
        return this.mEntries.size();
    }

    Iterator<PasswordFileEntry> iterator() {
        return Iterators.unmodifiableIterator(this.mEntries.iterator());
    }

    @VisibleForTesting
    static boolean isWildcard(String theString) {
        return "*".equals(theString);
    }

    private static String unescape(String theString) {
        String aToken = theString;
        aToken = aToken.replace("\\\\", "\\");
        aToken = aToken.replace("\\:", "!!!!!");
        return aToken;
    }

    private static String redoColons(String theString) {
        return theString.replace("!!!!!", ":");
    }

    private static final class EntryReader
    implements LineProcessor<List<PasswordFileEntry>> {
        private final ImmutableList.Builder<PasswordFileEntry> mBuilder = ImmutableList.builder();
        private int mLineNo = 1;
        private final List<String> mErrors = Lists.newArrayList();

        private EntryReader() {
        }

        public boolean processLine(String theLine) throws IOException {
            String aLine = theLine.trim();
            if (aLine.startsWith("#") || aLine.equals("")) {
                return true;
            }
            try {
                this.mBuilder.add((Object)PasswordFileEntry.parse(PasswordFile.unescape(aLine)));
            }
            catch (PasswordFileEntryParseException e) {
                this.mErrors.add(String.format("Invalid password file entry, line %s: %s", this.mLineNo, e.getMessage()));
            }
            ++this.mLineNo;
            return true;
        }

        List<String> getErrors() {
            return this.mErrors;
        }

        public List<PasswordFileEntry> getResult() {
            return this.mBuilder.build();
        }
    }

    public static final class PasswordFileEntryParseException
    extends Exception {
        private PasswordFileEntryParseException(String theMsg) {
            super(theMsg);
        }

        public static PasswordFileEntryParseException noEntry() {
            return new PasswordFileEntryParseException("No entry found");
        }

        public static PasswordFileEntryParseException missingPort() {
            return new PasswordFileEntryParseException("Port number is missing");
        }

        public static PasswordFileEntryParseException invalidPort(String thePort) {
            return new PasswordFileEntryParseException(String.format("Invalid port: %s is not a number", thePort));
        }

        public static PasswordFileEntryParseException missingDatabase() {
            return new PasswordFileEntryParseException("Database name is missing");
        }

        public static PasswordFileEntryParseException missingUser() {
            return new PasswordFileEntryParseException("Username is missing");
        }

        public static PasswordFileEntryParseException missingPassword() {
            return new PasswordFileEntryParseException("Password is missing");
        }

        public static PasswordFileEntryParseException noWildcardPassword() {
            return new PasswordFileEntryParseException("Password cannot be a wildcard");
        }

        public static PasswordFileEntryParseException unexpectedToken(String theToken) {
            return new PasswordFileEntryParseException(String.format("Unexpected separator token, : expected but %s found.", theToken));
        }
    }

    static final class PasswordFileEntry {
        private final String mProtocol;
        private final String mHostName;
        private final int mPort;
        private final String mDatabase;
        private final String mUser;
        private final String mPassword;
        static final int ANY_PORT = -1;

        private PasswordFileEntry(String theProtocol, String theHostName, int thePort, String theDatabase, String theUser, String thePassword) {
            this.mProtocol = theProtocol;
            this.mHostName = theHostName;
            this.mPort = thePort;
            this.mDatabase = theDatabase;
            this.mUser = theUser;
            this.mPassword = thePassword;
        }

        public int hashCode() {
            return Objects.hash(this.mHostName, this.mPort, this.mDatabase, this.mUser, this.mPassword);
        }

        public boolean equals(Object theObj) {
            if (theObj == null) {
                return false;
            }
            if (theObj == this) {
                return true;
            }
            if (theObj instanceof PasswordFileEntry) {
                PasswordFileEntry aObj = (PasswordFileEntry)theObj;
                return this.mPort == aObj.mPort && Objects.equals(this.mHostName, aObj.mHostName) && Objects.equals(this.mDatabase, aObj.mDatabase) && Objects.equals(this.mUser, aObj.mUser) && Objects.equals(this.mPassword, aObj.mPassword);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("protocol", (Object)this.mProtocol).add("host", (Object)this.mHostName).add("port", this.mPort).add("db", (Object)this.mDatabase).add("user", (Object)this.mUser).add("passwd", (Object)this.mPassword).toString();
        }

        String getProtocol() {
            return this.mProtocol;
        }

        String getHostName() {
            return this.mHostName;
        }

        int getPort() {
            return this.mPort;
        }

        String getDatabase() {
            return this.mDatabase;
        }

        String getUser() {
            return this.mUser;
        }

        String getPassword() {
            return this.mPassword;
        }

        public PasswordAuthentication getCredentials(String theUser) {
            String aUser = this.mUser;
            if (PasswordFile.isWildcard(this.mUser)) {
                if (theUser == null) {
                    throw new IllegalStateException();
                }
                aUser = theUser;
            }
            return new PasswordAuthentication(aUser, this.mPassword.toCharArray());
        }

        private static PasswordFileEntry parse(String theLine) throws PasswordFileEntryParseException {
            int aPort;
            String aHostName;
            String aProtocol;
            Iterator aTokens = Splitter.on((String)":").omitEmptyStrings().trimResults().split((CharSequence)theLine).iterator();
            if (!aTokens.hasNext()) {
                throw PasswordFileEntryParseException.noEntry();
            }
            String aFirstToken = (String)aTokens.next();
            if (aFirstToken.equalsIgnoreCase("s3")) {
                aProtocol = "s3";
                aHostName = PasswordFile.redoColons((String)aTokens.next());
            } else {
                aProtocol = "http";
                aHostName = PasswordFile.redoColons(aFirstToken);
            }
            if (!aTokens.hasNext()) {
                throw PasswordFileEntryParseException.missingPort();
            }
            String aPortStr = (String)aTokens.next();
            if (PasswordFile.isWildcard(aPortStr)) {
                aPort = -1;
            } else {
                try {
                    aPort = Integer.parseInt(aPortStr);
                    if (aPort < 0) {
                        throw PasswordFileEntryParseException.invalidPort(aPortStr);
                    }
                }
                catch (NumberFormatException e) {
                    throw PasswordFileEntryParseException.invalidPort(aPortStr);
                }
            }
            if (!aTokens.hasNext()) {
                throw PasswordFileEntryParseException.missingDatabase();
            }
            String aDb = PasswordFile.redoColons((String)aTokens.next());
            if (!aTokens.hasNext()) {
                throw PasswordFileEntryParseException.missingUser();
            }
            String aUser = PasswordFile.redoColons((String)aTokens.next());
            if (!aTokens.hasNext()) {
                throw PasswordFileEntryParseException.missingPassword();
            }
            String aPassword = PasswordFile.redoColons((String)aTokens.next());
            if (PasswordFile.isWildcard(aPassword)) {
                throw PasswordFileEntryParseException.noWildcardPassword();
            }
            return new PasswordFileEntry(aProtocol, aHostName, aPort, aDb, aUser, aPassword);
        }

        public boolean matches(URL theConnURL, String theDatabase, String theUser) {
            return PasswordFile.isWildcard(this.mHostName) || this.mHostName.equals(theConnURL.getHost()) || theDatabase != null && (PasswordFile.isWildcard(this.mDatabase) || this.mDatabase.equals(theDatabase)) || theUser != null && (PasswordFile.isWildcard(this.mUser) || this.mUser.equals(theUser)) || -1 == this.mPort || this.mPort == theConnURL.getPort();
        }
    }

    public static final class S3Authorization {
        private final String mHostName;
        private final int mPort;
        private final String mBucket;
        private final String mResource;
        private final String mKey;
        private final String mSecret;
        private final String mHeader;

        private S3Authorization(String theHostName, int thePort, String theBucket, String theResource, String theKey, String theSecret, String theHeader) {
            this.mHostName = theHostName;
            this.mPort = thePort;
            this.mBucket = theBucket;
            this.mResource = theResource;
            this.mKey = theKey;
            this.mSecret = theSecret;
            this.mHeader = theHeader;
        }

        public String getHostName() {
            return this.mHostName;
        }

        public int getPort() {
            return this.mPort;
        }

        public String getBucket() {
            return this.mBucket;
        }

        public String getResource() {
            return this.mResource;
        }

        public String getKey() {
            return this.mKey;
        }

        public String getSecret() {
            return this.mSecret;
        }

        public String getHeader() {
            return this.mHeader;
        }
    }
}

