/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.security;

import com.complexible.stardog.security.SecurityResourceType;

public enum CoreResourceType implements SecurityResourceType
{
    ALL("*", false),
    USER("user", false),
    ROLE("role", false),
    ROLE_ASSIGNMENT("role-assignment", false),
    PERMISSION("permission", false),
    DATABASE("db", true),
    DATABASE_EXPORT("db-export", true),
    NAMED_GRAPH("named-graph", true),
    DATA_SOURCE("data-source", false),
    VIRTUAL_GRAPH("virtual-graph", false),
    DBMS_ADMIN("dbms-admin", false),
    DATABASE_METADATA("metadata", true),
    DATABASE_ADMIN("admin", true),
    DATABASE_MODELING("modeling", true),
    STORED_QUERY("stored-query", true),
    CACHE("cache", true),
    CACHE_TARGET("cache-target", true),
    SENSITIVE_PROPERTIES("sensitive-properties", true),
    ENTITY_RESOLUTION("entity-resolution", true);

    private final String mLabel;
    private final boolean mDatabaseType;

    private CoreResourceType(String theLabel, boolean theDatabaseType) {
        this.mLabel = theLabel;
        this.mDatabaseType = theDatabaseType;
    }

    @Override
    public String id() {
        return this.mLabel;
    }

    @Override
    public boolean isDatabaseType() {
        return this.mDatabaseType;
    }

    public static CoreResourceType fromString(String text) {
        if (text != null) {
            for (CoreResourceType b : CoreResourceType.values()) {
                if (!text.equalsIgnoreCase(b.mLabel)) continue;
                return b;
            }
        }
        return null;
    }
}

