/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.query.hints;

import com.complexible.stardog.query.hints.Hint;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class BaseHint<T>
implements Hint<T> {
    private final String mName;
    private final T mValue;

    public BaseHint(String theName, T theValue) {
        Preconditions.checkNotNull((Object)theName);
        this.mName = theName;
        this.mValue = theValue;
    }

    @Override
    public String name() {
        return this.mName;
    }

    @Override
    public T value() {
        return this.mValue;
    }

    public String toString() {
        return "#pragma " + this.mName + " " + String.valueOf(this.mValue);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BaseHint hint = (BaseHint)other;
        return this.mName.equals(hint.mName) && Objects.equals(this.mValue, hint.mValue);
    }

    public int hashCode() {
        return Objects.hash(this.mName, this.mValue);
    }
}

