/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.metadata;

import com.complexible.common.base.DateTime;
import com.complexible.common.base.Duration;
import com.complexible.stardog.Contexts;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.stardog.model.DataModelFormat;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespace;
import com.stardog.stark.Values;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;

public abstract class TextIO<T> {
    private static final Map<Class<?>, TextIO<?>> TYPES = Maps.newHashMap();
    private static final Map<Class<?>, TextIO<Collection<?>>> LISTS = Maps.newHashMap();
    private static final Map<Class<?>, TextIO<Collection<?>>> SETS = Maps.newHashMap();
    public static final UriIO URI_IO_WILDCARD_LOCAL = new UriIO(Contexts.LOCAL);
    public static final UriIO URI_IO_WILDCARD_ALL = new UriIO(Contexts.ALL);

    public String write(T theValue) {
        return theValue == null ? "" : this._write(theValue);
    }

    protected String _write(T theValue) {
        return theValue.toString();
    }

    public T read(String theValue) {
        return theValue.equals("") ? this.emptyValue() : this._read(theValue);
    }

    public T emptyValue() {
        return null;
    }

    protected abstract T _read(String var1);

    public static <T> TextIO<T> forClass(Class<T> theClass) {
        TextIO<?> aResult = TYPES.get(theClass);
        if (aResult == null && theClass.isEnum()) {
            aResult = new EnumIO(theClass);
            TYPES.put(theClass, aResult);
        }
        return aResult;
    }

    public static <T> TextIO<Collection<T>> forList(Class<T> theClass) {
        return TextIO.forCollection(theClass, null, true, true);
    }

    public static <T> TextIO<Collection<T>> forList(Class<T> theClass, TextIO<T> theBaseIO) {
        return TextIO.forCollection(theClass, theBaseIO, true, true);
    }

    public static <T> TextIO<Collection<T>> forList(Class<T> theClass, TextIO<T> theBaseIO, boolean isBackwards) {
        return TextIO.forCollection(theClass, theBaseIO, true, isBackwards);
    }

    public static <T> TextIO<Collection<T>> forSet(Class<T> theClass) {
        return TextIO.forCollection(theClass, null, false, true);
    }

    public static <T> TextIO<Collection<T>> forSet(Class<T> theClass, TextIO<T> theBaseIO) {
        return TextIO.forCollection(theClass, theBaseIO, false, true);
    }

    public static <T> TextIO<Collection<T>> forSet(Class<T> theClass, TextIO<T> theBaseIO, boolean isBackwards) {
        return TextIO.forCollection(theClass, theBaseIO, false, isBackwards);
    }

    private static <T> TextIO<Collection<T>> forCollection(Class<T> theClass, TextIO<T> theBaseIO, boolean isList, boolean isBackwards) {
        TextIO aResult;
        if (theBaseIO != null) {
            aResult = new CollectionIO<T>(theBaseIO, isList, isBackwards);
        } else {
            Map<Class<?>, TextIO<Collection<?>>> aRegistry = isList ? LISTS : SETS;
            aResult = aRegistry.get(theClass);
            if (aResult == null) {
                TextIO<?> aBaseIO = TYPES.get(theClass);
                aResult = new CollectionIO(aBaseIO, isList, isBackwards);
                aRegistry.put(theClass, aResult);
            }
        }
        return aResult;
    }

    static {
        TYPES.put(Boolean.class, new BooleanIO());
        TYPES.put(Byte.class, new ByteIO());
        TYPES.put(Short.class, new ShortIO());
        TYPES.put(Integer.class, new IntIO());
        TYPES.put(Long.class, new LongIO());
        TYPES.put(Float.class, new FloatIO());
        TYPES.put(Double.class, new DoubleIO());
        TYPES.put(String.class, new StringIO());
        TYPES.put(File.class, new FileIO());
        TYPES.put(IRI.class, URI_IO_WILDCARD_LOCAL);
        TYPES.put(DateTime.class, new DateTimeIO());
        TYPES.put(Namespace.class, new NamespaceIO());
        TYPES.put(Duration.class, new DurationIO());
        TYPES.put(UUID.class, new UuidIO());
        TYPES.put(DataModelFormat.class, new DataModelFormatIO());
    }

    private static class EnumIO<T extends Enum<T>>
    extends TextIO<T> {
        private final Class<T> mEnumType;

        private EnumIO(Class<T> mEnum) {
            this.mEnumType = mEnum;
        }

        @Override
        public T _read(String theValue) {
            for (Enum aEnumConstant : (Enum[])this.mEnumType.getEnumConstants()) {
                if (!aEnumConstant.name().equalsIgnoreCase(theValue)) continue;
                return (T)aEnumConstant;
            }
            throw new IllegalArgumentException("The value '" + theValue + "' is not a valid enumeration for " + this.mEnumType.getName());
        }
    }

    public static class CollectionIO<T>
    extends TextIO<Collection<T>> {
        private final TextIO<T> mBaseIO;
        private final boolean mOrdered;
        private final boolean mBackwards;

        public CollectionIO(TextIO<T> theBaseIO, boolean theOrdered, boolean theBackwards) {
            this.mBaseIO = theBaseIO;
            this.mOrdered = theOrdered;
            this.mBackwards = theBackwards;
        }

        @Override
        public Collection<T> _read(String theValue) {
            ImmutableList.Builder aColl;
            Object object = aColl = this.mOrdered ? ImmutableList.builder() : ImmutableSet.builder();
            int aSplitChar = this.mBackwards ? (theValue.contains(String.valueOf('\u0002')) ? 2 : 44) : 2;
            for (String aElem : Splitter.on((char)aSplitChar).omitEmptyStrings().trimResults().split((CharSequence)theValue)) {
                aColl.add(this.mBaseIO.read(aElem.trim()));
            }
            return aColl.build();
        }

        @Override
        public String _write(Collection<T> theValues) {
            return Joiner.on((char)'\u0002').join(Iterables.transform(theValues, this.mBaseIO::write));
        }

        @Override
        public Collection<T> emptyValue() {
            return this.mOrdered ? Collections.EMPTY_LIST : Collections.EMPTY_SET;
        }
    }

    private static class UriIO
    extends TextIO<IRI> {
        private final IRI mWildcardValue;

        private UriIO(IRI wildcardValue) {
            this.mWildcardValue = wildcardValue;
        }

        @Override
        public IRI _read(String theValue) {
            if (theValue.equals("default")) {
                return Contexts.DEFAULT;
            }
            if (theValue.equals("*")) {
                return this.mWildcardValue;
            }
            return Values.iri((String)theValue);
        }

        @Override
        public String _write(IRI theValue) {
            return theValue.toString();
        }
    }

    private static class BooleanIO
    extends TextIO<Boolean> {
        private BooleanIO() {
        }

        @Override
        public Boolean _read(String theValue) {
            if (theValue.equalsIgnoreCase("true") || theValue.equalsIgnoreCase("yes")) {
                return Boolean.TRUE;
            }
            if (theValue.equalsIgnoreCase("false") || theValue.equalsIgnoreCase("no")) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("Invalid boolean value: " + theValue);
        }
    }

    private static class ByteIO
    extends TextIO<Byte> {
        private ByteIO() {
        }

        @Override
        public Byte _read(String theValue) {
            return Byte.valueOf(theValue);
        }
    }

    private static class ShortIO
    extends TextIO<Short> {
        private ShortIO() {
        }

        @Override
        public Short _read(String theValue) {
            return Short.valueOf(theValue);
        }
    }

    private static class IntIO
    extends TextIO<Integer> {
        private IntIO() {
        }

        @Override
        public Integer _read(String theValue) {
            return Integer.valueOf(theValue);
        }
    }

    private static class LongIO
    extends TextIO<Long> {
        private LongIO() {
        }

        @Override
        public Long _read(String theValue) {
            return Long.valueOf(theValue);
        }
    }

    private static class FloatIO
    extends TextIO<Float> {
        private FloatIO() {
        }

        @Override
        public Float _read(String theValue) {
            return Float.valueOf(theValue);
        }
    }

    private static class DoubleIO
    extends TextIO<Double> {
        private DoubleIO() {
        }

        @Override
        public Double _read(String theValue) {
            return Double.valueOf(theValue);
        }
    }

    private static class StringIO
    extends TextIO<String> {
        private StringIO() {
        }

        @Override
        public String emptyValue() {
            return "";
        }

        @Override
        public String _read(String theValue) {
            return theValue;
        }
    }

    private static class FileIO
    extends TextIO<File> {
        private FileIO() {
        }

        @Override
        public File _read(String theValue) {
            return new File(theValue);
        }

        @Override
        public String _write(File theValue) {
            return theValue.getAbsolutePath();
        }
    }

    private static class DateTimeIO
    extends TextIO<DateTime> {
        private DateTimeIO() {
        }

        @Override
        public DateTime _read(String theValue) {
            return DateTime.valueOf((String)theValue);
        }
    }

    private static class NamespaceIO
    extends TextIO<Namespace> {
        private static final Splitter mSplitter = Splitter.on((char)'=').limit(2);

        private NamespaceIO() {
        }

        @Override
        public Namespace _read(String theValue) {
            String[] aStr = (String[])Iterables.toArray((Iterable)mSplitter.split((CharSequence)theValue), String.class);
            if (aStr.length != 2) {
                throw new IllegalArgumentException("Not a valid prefix definition: " + theValue);
            }
            return Values.namespace((String)aStr[0], (String)aStr[1]);
        }

        @Override
        public String _write(Namespace theValue) {
            return theValue.prefix() + "=" + theValue.iri();
        }
    }

    private static class DurationIO
    extends TextIO<Duration> {
        private DurationIO() {
        }

        @Override
        public Duration _read(String theValue) {
            return Duration.valueOf((String)theValue);
        }
    }

    private static class UuidIO
    extends TextIO<UUID> {
        private UuidIO() {
        }

        @Override
        protected UUID _read(String theValue) {
            return UUID.fromString(theValue);
        }
    }

    private static class DataModelFormatIO
    extends TextIO<DataModelFormat> {
        private DataModelFormatIO() {
        }

        @Override
        protected DataModelFormat _read(String theValue) {
            return DataModelFormat.forName((String)theValue);
        }
    }
}

