/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.metadata;

import com.complexible.stardog.metadata.ByteIO;
import com.complexible.stardog.metadata.ConfigProperty;
import com.complexible.stardog.metadata.GraphIO;
import com.complexible.stardog.metadata.InfoProperty;
import com.complexible.stardog.metadata.OptionsCategory;
import com.complexible.stardog.metadata.TextIO;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetaProperty<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaProperty.class);
    private static final long MAX_JAVASCRIPT_NUMBER = 0x1FFFFFFFFFFFFFL;
    private final String mName;
    private String mDescription = "";
    private String mLabel;
    private OptionsCategory mCategory = OptionsCategory.MISC;
    private String mPermissionName;
    private T mDefaultValue;
    private T mSystemDefaultValue;
    private Collection<T> mPossibleValues = Collections.emptyList();
    private Class<?> mType;
    private CollectionType mCollectionType;
    EnumSet<Flag> mFlags = EnumSet.noneOf(Flag.class);
    private TextIO<T> mTextIO = null;
    private GraphIO<T> mGraphIO = null;
    private ByteIO<T> mByteIO = null;

    protected MetaProperty(String theName) {
        this.mName = theName;
        this.mLabel = theName;
    }

    public String getPermission() {
        if (this.mPermissionName == null) {
            return "";
        }
        return this.mPermissionName;
    }

    public String getName() {
        return this.mName;
    }

    public void setLabel(String theLabel) {
        this.mLabel = theLabel;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public void setDescription(String theDescription) {
        this.mDescription = theDescription;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public OptionsCategory getCategory() {
        return this.mCategory;
    }

    public void setCategory(OptionsCategory theCategory) {
        if (theCategory == null) {
            throw new NullPointerException("Category cannot be null");
        }
        this.mCategory = theCategory;
    }

    protected void setType(Class<?> theType) {
        this.mType = theType;
    }

    public Class<?> getType() {
        return this.mType;
    }

    public CollectionType getCollectionType() {
        return this.mCollectionType;
    }

    void setCollectionType(CollectionType theCollectionType) {
        this.mCollectionType = theCollectionType;
    }

    public T getDefaultValue() {
        return this.mDefaultValue;
    }

    void setDefaultValue(T theValue) {
        this.mDefaultValue = theValue;
    }

    public Collection<T> getPossibleValues() {
        return this.mPossibleValues;
    }

    void setPossibleValues(Collection<T> theValues) {
        this.mPossibleValues = ImmutableList.copyOf(theValues);
    }

    public T getSystemDefaultValue() {
        return this.mSystemDefaultValue;
    }

    void setSystemDefaultValue(T theSystemDefaultValue) {
        this.mSystemDefaultValue = theSystemDefaultValue;
    }

    public boolean isConfig() {
        return false;
    }

    public boolean isInfo() {
        return false;
    }

    public boolean isSecure() {
        return this.mFlags.contains((Object)Flag.SECURE);
    }

    public boolean isTemporary() {
        return this.mFlags.contains((Object)Flag.TEMPORARY);
    }

    public boolean isDatabase() {
        return this.mFlags.contains((Object)Flag.DATABASE);
    }

    public boolean isDiskIndex() {
        return this.mFlags.contains((Object)Flag.DISK);
    }

    public boolean isMemoryIndex() {
        return this.mFlags.contains((Object)Flag.MEMORY);
    }

    public boolean isIndex() {
        return this.isDiskIndex() | this.isMemoryIndex();
    }

    public boolean isReadable() {
        return this.mFlags.contains((Object)Flag.READ);
    }

    public boolean isServer() {
        return this.mFlags.contains((Object)Flag.SERVER);
    }

    public boolean isWritableOnline() {
        return this.mFlags.contains((Object)Flag.WRITE_ONLINE);
    }

    public ByteIO<T> getByteIO() {
        return this.mByteIO;
    }

    protected void setByteIO(ByteIO<T> theByteIO) {
        this.mByteIO = theByteIO;
    }

    public TextIO<T> getTextIO() {
        return this.mTextIO;
    }

    public void setTextIO(TextIO<T> theTextIO) {
        this.mTextIO = theTextIO;
    }

    public GraphIO<T> getGraphIO() {
        return this.mGraphIO;
    }

    protected void setGraphIO(GraphIO<T> theGraphIO) {
        this.mGraphIO = theGraphIO;
    }

    public boolean isValid(T theValue) {
        if (this.mCollectionType == null) {
            return this.mType.isInstance(theValue);
        }
        return this.mCollectionType.isInstance(theValue) && Iterables.all((Iterable)((Iterable)theValue), (Predicate)Predicates.instanceOf(this.mType));
    }

    public int hashCode() {
        return 17 * this.mName.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof MetaProperty && this.mName.equals(((MetaProperty)other).mName);
    }

    public String toString() {
        return this.mName;
    }

    public static <T> Builder<T, ConfigProperty<T>> config(String theName, T theDefaultValue) {
        if (theDefaultValue == null) {
            throw new NullPointerException("Default value cannot be null. Use config(String, Class<T>) instead.");
        }
        return new Builder(new ConfigProperty(theName), theDefaultValue, theDefaultValue.getClass(), false);
    }

    public static <T> Builder<T, ConfigProperty<T>> config(String theName, Class<T> theClass) {
        return new Builder(new ConfigProperty(theName), null, theClass, false);
    }

    public static <T> Builder<T, ConfigProperty<T>> config(String theName, Class<T> theClass, T theDefaultValue) {
        return new Builder(new ConfigProperty(theName), theDefaultValue, theClass, false);
    }

    public static <T> Builder<Collection<T>, ConfigProperty<Collection<T>>> config(String theName, Class<T> theClass, Collection<T> theDefaultValue) {
        return new Builder<Collection<T>, ConfigProperty<Collection<T>>>(new ConfigProperty(theName), theDefaultValue, theClass, true);
    }

    public static <T> Builder<List<T>, ConfigProperty<List<T>>> configList(String theName, Class<T> theClass, List<T> theDefaultValue) {
        return new Builder<List<T>, ConfigProperty<List<T>>>(new ConfigProperty(theName), theDefaultValue, theClass, true);
    }

    public static <T> Builder<T, InfoProperty<T>> info(String theName, T theDefaultValue) {
        return new Builder(new InfoProperty(theName), theDefaultValue, theDefaultValue.getClass(), false);
    }

    public static <T> Builder<T, InfoProperty<T>> info(String theName, Class<T> theClass) {
        return new Builder(new InfoProperty(theName), null, theClass, false);
    }

    public static <T> Builder<Collection<T>, InfoProperty<Collection<T>>> info(String theName, Class<T> theClass, Collection<T> theDefaultValue) {
        return new Builder<Collection<T>, InfoProperty<Collection<T>>>(new InfoProperty(theName), theDefaultValue, theClass, true);
    }

    protected static enum Flag {
        READ,
        WRITE,
        WRITE_ONLINE,
        CREATE,
        MEMORY,
        DISK,
        DATABASE,
        SECURE,
        TEMPORARY,
        SERVER;

    }

    private static enum CollectionType {
        LIST(List.class),
        SET(Set.class);

        private final Class<?> mType;

        private CollectionType(Class<?> theType) {
            this.mType = theType;
        }

        private boolean isInstance(Object theObj) {
            return this.mType.isInstance(theObj);
        }
    }

    public static class Builder<T, P extends MetaProperty<T>> {
        private final P mOption;

        private Builder(P theOption, T theDefaultValue, Class<?> theClass, boolean isCollection) {
            TextIO<Collection<?>> aTextIO;
            boolean isList = isCollection && theDefaultValue instanceof List;
            boolean isSet = isCollection && theDefaultValue instanceof Set;
            this.mOption = theOption;
            ((MetaProperty)this.mOption).setDefaultValue(theDefaultValue);
            ((MetaProperty)this.mOption).setType(theClass);
            ((MetaProperty)this.mOption).setCollectionType(isList ? CollectionType.LIST : (isSet ? CollectionType.SET : null));
            ((MetaProperty)this.mOption).setByteIO(ByteIO.getGeneric());
            TextIO<Collection<?>> textIO = isList ? TextIO.forList(theClass) : (aTextIO = isSet ? TextIO.forSet(theClass) : TextIO.forClass(theClass));
            GraphIO<Collection<?>> aGraphIO = isList ? GraphIO.forList(theClass) : (isSet ? GraphIO.forSet(theClass) : GraphIO.forClass(theClass));
            ((MetaProperty)this.mOption).setTextIO(aTextIO);
            ((MetaProperty)this.mOption).setGraphIO(aGraphIO);
            ((MetaProperty)this.mOption).mFlags.add(Flag.SECURE);
            if (theClass.isEnum()) {
                ((MetaProperty)this.mOption).setPossibleValues(ImmutableList.copyOf((Object[])theClass.getEnumConstants()));
            }
        }

        public Builder<T, P> secure() {
            ((MetaProperty)this.mOption).mFlags.add(Flag.SECURE);
            return this;
        }

        public Builder<T, P> nonsecure() {
            ((MetaProperty)this.mOption).mFlags.remove((Object)Flag.SECURE);
            return this;
        }

        public Builder<T, P> byteIO(ByteIO<T> theByteIO) {
            ((MetaProperty)this.mOption).setByteIO(theByteIO);
            return this;
        }

        public Builder<T, P> textIO(TextIO<T> theTextIO) {
            ((MetaProperty)this.mOption).setTextIO(theTextIO);
            return this;
        }

        public Builder<T, P> graphIO(GraphIO<T> theGraphIO) {
            ((MetaProperty)this.mOption).setGraphIO(theGraphIO);
            return this;
        }

        public Builder<T, P> readable() {
            ((MetaProperty)this.mOption).mFlags.add(Flag.READ);
            return this;
        }

        public Builder<T, P> creatable() {
            if (this.mOption instanceof InfoProperty) {
                throw new UnsupportedOperationException("InfoProperty cannot be creatable");
            }
            ((MetaProperty)this.mOption).mFlags.add(Flag.CREATE);
            return this;
        }

        public Builder<T, P> writable() {
            if (this.mOption instanceof InfoProperty) {
                throw new UnsupportedOperationException("InfoProperty cannot be writable");
            }
            ((MetaProperty)this.mOption).mFlags.add(Flag.WRITE);
            return this;
        }

        public Builder<T, P> writableWhileOnline() {
            if (this.mOption instanceof InfoProperty) {
                throw new UnsupportedOperationException("InfoProperty cannot be writable");
            }
            ((MetaProperty)this.mOption).mFlags.add(Flag.WRITE_ONLINE);
            return this;
        }

        public Builder<T, P> server() {
            if (this.mOption instanceof InfoProperty) {
                throw new UnsupportedOperationException("InfoProperty cannot be a server property");
            }
            ((MetaProperty)this.mOption).mFlags.add(Flag.SERVER);
            return this;
        }

        public Builder<T, P> database() {
            ((MetaProperty)this.mOption).mFlags.add(Flag.DATABASE);
            return this;
        }

        public Builder<T, P> index() {
            return this.diskIndex().memoryIndex();
        }

        public Builder<T, P> diskIndex() {
            ((MetaProperty)this.mOption).mFlags.add(Flag.DISK);
            return this;
        }

        public Builder<T, P> memoryIndex() {
            ((MetaProperty)this.mOption).mFlags.add(Flag.MEMORY);
            return this;
        }

        public Builder<T, P> temporary() {
            ((MetaProperty)this.mOption).mFlags.add(Flag.TEMPORARY);
            return this;
        }

        public Builder<T, P> label(String theLabel) {
            ((MetaProperty)this.mOption).setLabel(theLabel);
            return this;
        }

        public Builder<T, P> description(String theDescription) {
            ((MetaProperty)this.mOption).setDescription(theDescription);
            return this;
        }

        public Builder<T, P> category(OptionsCategory theCategory) {
            ((MetaProperty)this.mOption).setCategory(theCategory);
            return this;
        }

        @Deprecated
        public Builder<T, P> category(String theCategoryName) {
            ((MetaProperty)this.mOption).setCategory(OptionsCategory.create(theCategoryName, theCategoryName));
            return this;
        }

        public Builder<T, P> systemDefaultValue(T theValue) {
            ((MetaProperty)this.mOption).setSystemDefaultValue(theValue);
            return this;
        }

        public Builder<T, P> possibleValues(Collection<T> theValues) {
            ((MetaProperty)this.mOption).setPossibleValues(theValues);
            return this;
        }

        public P build() {
            if (!((MetaProperty)this.mOption).isTemporary()) {
                String msg = null;
                if (((MetaProperty)this.mOption).getByteIO().equals(ByteIO.getGeneric()) && !ByteIO.isGenericType(((MetaProperty)this.mOption).getType())) {
                    msg = String.format("Option %s needs a custom ByteIO implementation because %s is not supported by the generic implementation", ((MetaProperty)this.mOption).getName(), ((MetaProperty)this.mOption).getType());
                } else if (((MetaProperty)this.mOption).getTextIO() == null) {
                    msg = String.format("Option %s needs a custom TextIO implementation because %s is not supported by default", ((MetaProperty)this.mOption).getName(), ((MetaProperty)this.mOption).getType());
                } else if (((MetaProperty)this.mOption).getGraphIO() == null) {
                    msg = String.format("Option %s needs a custom GraphIO implementation because %s is not supported by default", ((MetaProperty)this.mOption).getName(), ((MetaProperty)this.mOption).getType());
                } else if (!((MetaProperty)this.mOption).isReadable()) {
                    msg = String.format("Option %s is neither temporary nor readable", ((MetaProperty)this.mOption).getName());
                } else if (((MetaProperty)this.mOption).getDefaultValue() instanceof Long && (Long)((MetaProperty)this.mOption).getDefaultValue() > 0x1FFFFFFFFFFFFFL) {
                    msg = String.format("Option %s is using a default value that cannot be represented in Javascript", ((MetaProperty)this.mOption).getName());
                }
                if (msg != null) {
                    LOGGER.error(msg);
                    throw new IllegalArgumentException(msg);
                }
            }
            return this.mOption;
        }
    }
}

