/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.metadata;

import com.complexible.stardog.SystemStatusOptions;
import com.complexible.stardog.db.DatabaseOptions;
import com.complexible.stardog.metadata.ConfigProperty;
import com.complexible.stardog.metadata.InfoProperty;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.MetaPropertyProvider;
import com.complexible.stardog.metadata.Metadata;
import com.complexible.stardog.metadata.PartitionedMetadata;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetaProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaProperties.class);
    private static final Map<String, MetaProperty<?>> ALL_PROPS = Maps.newHashMap();
    public static final Predicate<MetaProperty<?>> WRITABLE = theOption -> theOption instanceof ConfigProperty && ((ConfigProperty)theOption).isWritable();
    public static final Predicate<MetaProperty<?>> CREATABLE = theOption -> theOption instanceof ConfigProperty && ((ConfigProperty)theOption).isCreatable();
    public static final Ordering<MetaProperty<?>> NAME_ORDERING = Ordering.natural().lexicographical().onResultOf((Function)new Function<String, Iterable<String>>(){
        final Splitter mSplitter = Splitter.on((char)'.');

        public Iterable<String> apply(String theArg) {
            return this.mSplitter.split((CharSequence)theArg);
        }
    }).onResultOf(MetaProperty::getName);

    public static <T> MetaProperty<T> get(String name) {
        return ALL_PROPS.get(name);
    }

    public static boolean contains(String theName) {
        return ALL_PROPS.containsKey(theName);
    }

    public static boolean contains(MetaProperty<?> theOption) {
        return ALL_PROPS.containsKey(theOption.getName());
    }

    public static Iterable<MetaProperty<?>> allProperties() {
        return Collections.unmodifiableCollection(ALL_PROPS.values());
    }

    public static Iterable<MetaProperty<?>> databaseProperties() {
        return Iterables.filter(MetaProperties.allProperties(), MetaProperty::isDatabase);
    }

    public static Iterable<MetaProperty<?>> memoryProperties() {
        return Iterables.filter(MetaProperties.allProperties(), MetaProperty::isMemoryIndex);
    }

    public static Iterable<MetaProperty<?>> diskProperties() {
        return Iterables.filter(MetaProperties.allProperties(), MetaProperty::isDiskIndex);
    }

    public static Iterable<MetaProperty<?>> indexProperties() {
        return Iterables.concat(MetaProperties.memoryProperties(), MetaProperties.diskProperties());
    }

    public static Iterable<ConfigProperty<?>> configProperties(Iterable<MetaProperty<?>> theProperties) {
        return Iterables.filter(theProperties, ConfigProperty.class);
    }

    public static Iterable<InfoProperty<?>> infoProperties(Iterable<MetaProperty<?>> theProperties) {
        return Iterables.filter(theProperties, InfoProperty.class);
    }

    public static Metadata defaults(Iterable<MetaProperty<?>> theStardogOptions) {
        Metadata aOptions = Metadata.create();
        for (MetaProperty<?> aOption : theStardogOptions) {
            if (aOption.getDefaultValue() == null) continue;
            aOptions.set(aOption, aOption.getDefaultValue());
        }
        return aOptions;
    }

    public static Metadata filter(Metadata theOptions, Predicate<MetaProperty<?>> theFilter) {
        Metadata aNewOptions = Metadata.create();
        for (MetaProperty<Object> aOption : theOptions) {
            if (!theFilter.test(aOption)) continue;
            aNewOptions.set(aOption, theOptions.get(aOption));
        }
        return aNewOptions;
    }

    public static PartitionedMetadata partition(Metadata theOptions, Predicate<MetaProperty<?>> theFilter, boolean theMemory) {
        return new PartitionedMetadata(theOptions, theFilter, theMemory);
    }

    public static Metadata combine(Metadata ... theOptionsArray) {
        Metadata aResult = Metadata.create();
        for (Metadata aOptions : theOptionsArray) {
            aResult.setAll(aOptions);
        }
        return aResult;
    }

    public static synchronized void register(Class<? extends MetaPropertyProvider> aProvider) {
        HashMap aBuilder = Maps.newHashMap();
        LOGGER.debug("Process option provider: {}", aProvider);
        for (Field aField : aProvider.getDeclaredFields()) {
            try {
                Object aFieldValue = aField.get(null);
                if (!(aFieldValue instanceof MetaProperty)) continue;
                MetaProperty aOption = (MetaProperty)aFieldValue;
                LOGGER.debug("Register option: {}", (Object)aOption.getName());
                if (aBuilder.containsKey(aOption.getName()) || ALL_PROPS.containsKey(aOption.getName())) {
                    LOGGER.debug("Cannot register duplicate option: {}", (Object)aOption);
                    continue;
                }
                aBuilder.put(aOption.getName(), aOption);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ALL_PROPS.putAll(aBuilder);
    }

    private MetaProperties() {
    }

    static {
        MetaProperties.register(DatabaseOptions.class);
        MetaProperties.register(SystemStatusOptions.class);
    }
}

