/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.metadata;

import com.complexible.common.base.DateTime;
import com.complexible.common.base.Duration;
import com.complexible.common.base.Durations;
import com.complexible.stardog.metadata.TextIO;
import com.complexible.stardog.util.DurationUtils;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.stardog.model.DataModelFormat;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Namespace;
import com.stardog.stark.RDFLists;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Statements;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.impl.DurationLiteral;
import com.stardog.stark.vocabs.RDF;
import com.stardog.stark.vocabs.XSD;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraphIO<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphIO.class);
    private static final Map<Class<?>, GraphIO<?>> TYPES = Maps.newHashMap();
    private static final Map<Class<?>, GraphIO<Collection<?>>> LISTS = Maps.newHashMap();
    private static final Map<Class<?>, GraphIO<Collection<?>>> SETS = Maps.newHashMap();

    public Value write(T theValue, Set<Statement> theGraph, final String theUniquePrefix) {
        Supplier<IRI> theValueGenerator = new Supplier<IRI>(){
            private int mGenerated = 0;

            @Override
            public IRI get() {
                return Values.iri((String)(theUniquePrefix + "_" + ++this.mGenerated));
            }
        };
        return this._write(theValue, theGraph, theValueGenerator);
    }

    protected abstract Value _write(T var1, Set<Statement> var2, Supplier<IRI> var3);

    public abstract T read(Value var1, Set<Statement> var2);

    private static <T> void addTypedLiteralIO(Class<T> theClass, IRI theDatatype) {
        TYPES.put(theClass, new TypedLiteralIO<T>(theDatatype, theClass));
    }

    public static <T> GraphIO<T> forClass(Class<T> theClass) {
        GraphIO<?> aResult = TYPES.get(theClass);
        if (aResult == null && theClass.isEnum()) {
            aResult = new EnumIO(theClass);
            TYPES.put(theClass, aResult);
        }
        return aResult;
    }

    public static <T> GraphIO<Collection<T>> forList(Class<T> theClass) {
        return GraphIO.forCollection(theClass, true);
    }

    public static <T> GraphIO<Collection<T>> forSet(Class<T> theClass) {
        return GraphIO.forCollection(theClass, false);
    }

    private static <T> GraphIO<Collection<T>> forCollection(Class<T> theClass, boolean isList) {
        Map<Class<?>, GraphIO<Collection<?>>> TestIO = isList ? LISTS : SETS;
        GraphIO<Collection<T>> aResult = TestIO.get(theClass);
        if (aResult == null) {
            GraphIO<?> aBaseIO = TYPES.get(theClass);
            aResult = new CollectionIO(aBaseIO, isList);
            TestIO.put(theClass, aResult);
        }
        return aResult;
    }

    static {
        GraphIO.addTypedLiteralIO(Boolean.class, XSD.BOOLEAN);
        GraphIO.addTypedLiteralIO(Byte.class, XSD.BYTE);
        GraphIO.addTypedLiteralIO(Short.class, XSD.SHORT);
        GraphIO.addTypedLiteralIO(Integer.class, XSD.INT);
        GraphIO.addTypedLiteralIO(Long.class, XSD.LONG);
        GraphIO.addTypedLiteralIO(Float.class, XSD.FLOAT);
        GraphIO.addTypedLiteralIO(Double.class, XSD.DOUBLE);
        GraphIO.addTypedLiteralIO(String.class, XSD.STRING);
        GraphIO.addTypedLiteralIO(DateTime.class, XSD.DATETIME);
        TYPES.put(Duration.class, new DurationIO());
        TYPES.put(IRI.class, new UriIO());
        TYPES.put(Namespace.class, new NamespaceIO());
        TYPES.put(UUID.class, new UUIDIO());
        TYPES.put(DataModelFormat.class, new DataModelFormatIO());
    }

    private static class TypedLiteralIO<T>
    extends GraphIO<T> {
        private final IRI mDatatype;
        private final TextIO<T> mBaseIO;

        private TypedLiteralIO(IRI theDatatype, Class<T> theClass) {
            this.mDatatype = theDatatype;
            this.mBaseIO = TextIO.forClass(theClass);
        }

        @Override
        public T read(Value theValue, Set<Statement> theGraph) {
            return this.mBaseIO.read(((Literal)theValue).label());
        }

        @Override
        public Value _write(T theValue, Set<Statement> theGraph, Supplier<IRI> theValueGenerator) {
            return Values.literal((String)theValue.toString(), (IRI)this.mDatatype);
        }
    }

    private static class EnumIO<T extends Enum<T>>
    extends GraphIO<T> {
        private final Class<T> mEnumType;

        private EnumIO(Class<T> mEnum) {
            this.mEnumType = mEnum;
        }

        @Override
        public T read(Value theValue, Set<Statement> theGraph) {
            for (Enum aEnumConstant : (Enum[])this.mEnumType.getEnumConstants()) {
                if (!aEnumConstant.name().equalsIgnoreCase(Value.lex((Value)theValue))) continue;
                return (T)aEnumConstant;
            }
            throw new IllegalArgumentException("The value '" + String.valueOf(theValue) + "' is not a valid enumeration for " + this.mEnumType.getName());
        }

        @Override
        public Value _write(T theValue, Set<Statement> theGraph, Supplier<IRI> theValueGenerator) {
            return Values.literal((String)((Enum)theValue).name());
        }
    }

    public static class CollectionIO<T>
    extends GraphIO<Collection<T>> {
        private final GraphIO<T> mBaseIO;
        private final boolean mOrdered;

        public CollectionIO(GraphIO<T> theBaseIO, boolean theOrdered) {
            this.mBaseIO = theBaseIO;
            this.mOrdered = theOrdered;
        }

        @Override
        public Collection<T> read(Value theValue, Set<Statement> theGraph) {
            if (theValue instanceof BNode || RDF.NIL.equals((Object)theValue)) {
                List listStuff = theGraph.stream().filter(s -> s.predicate().equals((Object)RDF.FIRST) || s.predicate().equals((Object)RDF.REST)).collect(Collectors.toList());
                Collector collector = this.mOrdered ? Collectors.toList() : Collectors.toSet();
                return RDFLists.fromStatements((Resource)((Resource)theValue), listStuff).stream().map(v -> this.mBaseIO.read((Value)v, theGraph)).collect(collector);
            }
            Collector aCollector = this.mOrdered ? ImmutableCollectionCollector.toList() : ImmutableCollectionCollector.toSet();
            return (Collection)theGraph.stream().filter(Statements.matches((Resource)((Resource)theValue), (IRI)RDF.VALUE, null, (Resource[])new Resource[0])).map(Statement::object).map(v -> this.mBaseIO.read((Value)v, theGraph)).collect(aCollector);
        }

        @Override
        public Value _write(Collection<T> theValues, Set<Statement> theGraph, Supplier<IRI> theValueGenerator) {
            if (this.mOrdered) {
                List values = theValues.stream().map(v -> this.mBaseIO._write(v, theGraph, theValueGenerator)).collect(Collectors.toList());
                return RDFLists.create(values, theGraph::add);
            }
            Resource theResult = (Resource)theValueGenerator.get();
            for (T theValue : theValues) {
                theGraph.add(Values.statement((Resource)theResult, (IRI)RDF.VALUE, (Value)this.mBaseIO._write(theValue, theGraph, theValueGenerator)));
            }
            return theResult;
        }
    }

    private static class DurationIO
    extends GraphIO<Duration> {
        private DurationIO() {
        }

        @Override
        public Duration read(Value theValue, Set<Statement> theGraph) {
            String theName = Value.lex((Value)theValue);
            if (theName.startsWith("P")) {
                javax.xml.datatype.Duration aDuration = theValue instanceof DurationLiteral ? ((DurationLiteral)theValue).durationValue() : Values.DATATYPE_FACTORY.newDuration(theName);
                return new Duration(DurationUtils.toMillis(aDuration));
            }
            return new Duration(Durations.parse((String)theName));
        }

        @Override
        public Value _write(Duration theValue, Set<Statement> theGraph, Supplier<IRI> theValueGenerator) {
            return Values.literal((javax.xml.datatype.Duration)Values.DATATYPE_FACTORY.newDuration(theValue.getMillis()));
        }
    }

    private static class UriIO
    extends GraphIO<IRI> {
        private UriIO() {
        }

        @Override
        public IRI read(Value theValue, Set<Statement> theGraph) {
            return (IRI)theValue;
        }

        @Override
        public Value _write(IRI theValue, Set<Statement> theGraph, Supplier<IRI> theValueGenerator) {
            return theValue;
        }
    }

    private static class NamespaceIO
    extends GraphIO<Namespace> {
        private NamespaceIO() {
        }

        @Override
        public Namespace read(Value theValue, Set<Statement> theGraph) {
            Literal aLiteral = (Literal)theValue;
            String aPrefix = aLiteral.label();
            String aNamespace = aLiteral.datatypeIRI().toString();
            return Values.namespace((String)aPrefix, (String)aNamespace);
        }

        @Override
        public Value _write(Namespace theValue, Set<Statement> theGraph, Supplier<IRI> theValueGenerator) {
            return Values.literal((String)theValue.prefix(), (IRI)Values.iri((String)theValue.iri()));
        }
    }

    private static class UUIDIO
    extends GraphIO<UUID> {
        private UUIDIO() {
        }

        @Override
        public UUID read(Value theValue, Set<Statement> theGraph) {
            return UUID.fromString(Value.lex((Value)theValue));
        }

        @Override
        public Value _write(UUID theValue, Set<Statement> theGraph, Supplier<IRI> theValueGenerator) {
            return Values.literal((String)theValue.toString());
        }
    }

    public static class DataModelFormatIO
    extends GraphIO<DataModelFormat> {
        @Override
        protected Value _write(DataModelFormat theValue, Set<Statement> theGraph, Supplier<IRI> theValueGenerator) {
            return Values.literal((String)theValue.getName());
        }

        @Override
        public DataModelFormat read(Value theValue, Set<Statement> theGraph) {
            return DataModelFormat.forName((String)Value.lex((Value)theValue));
        }
    }

    private static final class ImmutableCollectionCollector<T, A extends ImmutableCollection.Builder<T>, R extends ImmutableCollection<T>>
    implements Collector<T, A, R> {
        private final Supplier<A> mBuilderSupplier;

        public ImmutableCollectionCollector(Supplier<A> theBuilderSupplier) {
            this.mBuilderSupplier = theBuilderSupplier;
        }

        public static <T> Collector<T, ImmutableSet.Builder<T>, ImmutableSet<T>> toSet() {
            return new ImmutableCollectionCollector(ImmutableSet.Builder::new);
        }

        public static <T> Collector<T, ImmutableList.Builder<T>, ImmutableList<T>> toList() {
            return new ImmutableCollectionCollector(ImmutableList.Builder::new);
        }

        @Override
        public Supplier<A> supplier() {
            return this.mBuilderSupplier;
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return ImmutableCollection.Builder::add;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return (theBuilder, theOtherBuilder) -> {
                theBuilder.addAll((Iterable)theOtherBuilder.build());
                return theBuilder;
            };
        }

        @Override
        public Function<A, R> finisher() {
            return theBuilder -> theBuilder.build();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return ImmutableSet.of((Object)((Object)Collector.Characteristics.UNORDERED));
        }
    }
}

