/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.metadata;

import com.complexible.common.base.DateTime;
import com.complexible.common.base.ImmutableCollectors;
import com.complexible.common.io.ByteReader;
import com.complexible.common.io.ByteWriter;
import com.complexible.common.io.Persistable;
import com.complexible.common.io.impl.ByteReaderInputStream;
import com.complexible.common.io.impl.ByteWriterOutputStream;
import com.complexible.common.io.impl.PushbackByteReader;
import com.complexible.common.rdf.model.StardogIRI;
import com.complexible.stardog.LoggedCommitResult;
import com.complexible.stardog.metadata.MetaPropertyChange;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import com.stardog.model.DataModelFormat;
import com.stardog.stark.Namespace;
import com.stardog.stark.Values;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class ByteIO<T> {
    private static final Map<Class<?>, Integer> TYPE_MAP = Maps.newLinkedHashMap();
    public static final ByteIO<Namespace> NAMESPACE;
    private static final ByteIO<Object> GENERIC;

    public abstract T read(ByteReader var1) throws IOException;

    public abstract void write(T var1, ByteWriter var2) throws IOException;

    public static <T> ByteIO<Collection<T>> set(ByteIO<T> theIO) {
        return new CollectionByteIO<T>((ByteIO)theIO){

            @Override
            protected ImmutableCollection.Builder<T> newBuilder() {
                return ImmutableSet.builder();
            }
        };
    }

    public static <T> ByteIO<Collection<T>> list(ByteIO<T> theIO) {
        return new CollectionByteIO<T>((ByteIO)theIO){

            @Override
            protected ImmutableCollection.Builder<T> newBuilder() {
                return ImmutableList.builder();
            }
        };
    }

    public static boolean isGenericType(Class<?> type) {
        for (Class<?> aCls : TYPE_MAP.keySet()) {
            if (!aCls.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public static ByteIO<Object> getGeneric() {
        return GENERIC;
    }

    public static <T, V> ByteIO<T> uplift(final ByteIO<V> theByteIO, final Function<V, T> theFunc) {
        return new ByteIO<T>(){

            @Override
            public T read(ByteReader theReader) throws IOException {
                return theFunc.apply(theByteIO.read(theReader));
            }

            @Override
            public void write(T theValue, ByteWriter theByteWriter) throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> ByteIO<T> legacySerializable(String theOld, String theNew) {
        return ByteIO.legacySerializable(theOld, theNew, null);
    }

    public static <T> ByteIO<T> legacySerializable(String theOld, String theNew, ByteIO<T> theNewByteIO) {
        return LegacySerializableConversionByteIO.create(theOld, theNew, theNewByteIO);
    }

    static {
        TYPE_MAP.put(Integer.class, 1);
        TYPE_MAP.put(Boolean.class, 2);
        TYPE_MAP.put(Double.class, 4);
        TYPE_MAP.put(Short.class, 8);
        TYPE_MAP.put(Long.class, 16);
        TYPE_MAP.put(Float.class, 32);
        TYPE_MAP.put(Byte.class, 64);
        TYPE_MAP.put(String.class, 128);
        TYPE_MAP.put(Date.class, 256);
        TYPE_MAP.put(Persistable.class, 512);
        TYPE_MAP.put(File.class, 1024);
        TYPE_MAP.put(Serializable.class, 2048);
        TYPE_MAP.put(DateTime.class, 5092);
        TYPE_MAP.put(LoggedCommitResult.class, 3);
        TYPE_MAP.put(DataModelFormat.class, 5);
        TYPE_MAP.put(MetaPropertyChange.class, 6);
        NAMESPACE = new ByteIO<Namespace>(){

            @Override
            public Namespace read(ByteReader theReader) throws IOException {
                return Values.namespace((String)theReader.readString(), (String)theReader.readString());
            }

            @Override
            public void write(Namespace theValue, ByteWriter theByteWriter) throws IOException {
                theByteWriter.writeString(theValue.prefix());
                theByteWriter.writeString(theValue.iri());
            }
        };
        GENERIC = new ByteIO<Object>(){

            @Override
            public void write(Object theValue, ByteWriter theByteWriter) throws IOException {
                boolean written = false;
                for (Class<?> aCls : TYPE_MAP.keySet()) {
                    if (!aCls.isInstance(theValue)) continue;
                    written = true;
                    int aType = TYPE_MAP.get(aCls);
                    theByteWriter.writeInt(aType);
                    switch (aType) {
                        case 1: {
                            theByteWriter.writeInt(((Integer)theValue).intValue());
                            break;
                        }
                        case 2: {
                            theByteWriter.writeByte((Boolean)theValue != false ? (byte)1 : 0);
                            break;
                        }
                        case 4: {
                            theByteWriter.writeDouble(((Double)theValue).doubleValue());
                            break;
                        }
                        case 8: {
                            theByteWriter.writeShort(((Short)theValue).shortValue());
                            break;
                        }
                        case 16: {
                            theByteWriter.writeLong(((Long)theValue).longValue());
                            break;
                        }
                        case 32: {
                            theByteWriter.writeFloat(((Float)theValue).floatValue());
                            break;
                        }
                        case 64: {
                            theByteWriter.writeByte(((Byte)theValue).byteValue());
                            break;
                        }
                        case 128: {
                            theByteWriter.writeString((String)theValue);
                            break;
                        }
                        case 256: {
                            theByteWriter.writeLong(((Date)theValue).getTime());
                            break;
                        }
                        case 512: {
                            ((Persistable)theValue).write(theByteWriter);
                            break;
                        }
                        case 1024: {
                            theByteWriter.writeString(((File)theValue).getAbsolutePath());
                            break;
                        }
                        case 2048: {
                            ObjectOutputStream aOut = new ObjectOutputStream((OutputStream)new ByteWriterOutputStream(theByteWriter));
                            aOut.writeObject(theValue);
                            aOut.flush();
                            aOut.close();
                            break;
                        }
                        case 5092: {
                            theByteWriter.writeLong(((DateTime)theValue).getTime());
                            break;
                        }
                        case 3: {
                            LoggedCommitResult aResult = (LoggedCommitResult)theValue;
                            theByteWriter.writeString(aResult.getTxId());
                            theByteWriter.writeLong(aResult.getAdded());
                            theByteWriter.writeLong(aResult.getRemoved());
                            break;
                        }
                        case 5: {
                            DataModelFormat aFormat = (DataModelFormat)theValue;
                            theByteWriter.writeString(aFormat.getName());
                            break;
                        }
                        case 6: {
                            MetaPropertyChange aChange = (MetaPropertyChange)theValue;
                            theByteWriter.writeString(aChange.getPropertyName());
                            theByteWriter.writeString(aChange.getNewValue());
                        }
                    }
                    break;
                }
                if (!written) {
                    throw new IOException("Unsupported class type for Option value persistence: " + String.valueOf(theValue.getClass()));
                }
            }

            @Override
            public Object read(ByteReader aReader) throws IOException {
                int aType = aReader.readInt();
                switch (aType) {
                    case 1: {
                        return aReader.readInt();
                    }
                    case 2: {
                        return aReader.readByte() == 1;
                    }
                    case 4: {
                        return aReader.readDouble();
                    }
                    case 8: {
                        return aReader.readShort();
                    }
                    case 16: {
                        return aReader.readLong();
                    }
                    case 32: {
                        return Float.valueOf(aReader.readFloat());
                    }
                    case 64: {
                        return aReader.readByte();
                    }
                    case 128: {
                        return aReader.readString();
                    }
                    case 256: {
                        return new Date(aReader.readLong());
                    }
                    case 512: {
                        try {
                            String aClassName = aReader.readString();
                            Class<?> aClass = Class.forName(aClassName);
                            Persistable aPersistable = (Persistable)aClass.newInstance();
                            aPersistable.read(aReader);
                            return aPersistable;
                        }
                        catch (IOException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new IOException(e.getMessage());
                        }
                    }
                    case 1024: {
                        return new File(aReader.readString());
                    }
                    case 2048: {
                        try {
                            ObjectInputStream ois = new ObjectInputStream((InputStream)new ByteReaderInputStream(aReader));
                            Object obj = ois.readObject();
                            obj = this.mapLegacyIRIs(obj);
                            return obj;
                        }
                        catch (ClassNotFoundException e) {
                            throw new IOException(e);
                        }
                    }
                    case 5092: {
                        return new DateTime(aReader.readLong());
                    }
                    case 3: {
                        return new LoggedCommitResult(aReader.readString(), aReader.readLong(), aReader.readLong());
                    }
                    case 5: {
                        return DataModelFormat.forName((String)aReader.readString());
                    }
                    case 6: {
                        return new MetaPropertyChange(aReader.readString(), aReader.readString());
                    }
                }
                return null;
            }

            private Object mapLegacyIRIs(Object obj) {
                if (obj instanceof StardogIRI) {
                    return Values.iri((String)((StardogIRI)obj).stringValue());
                }
                if (obj instanceof ImmutableList) {
                    return ((ImmutableList)obj).stream().map(this::mapLegacyIRIs).collect(ImmutableCollectors.toList());
                }
                if (obj instanceof ImmutableSet) {
                    return ((ImmutableSet)obj).stream().map(this::mapLegacyIRIs).collect(ImmutableCollectors.toSet());
                }
                return obj;
            }
        };
    }

    public static final class LegacySerializableConversionByteIO<T>
    extends ByteIO<T> {
        private final String mOld;
        private final String mNew;
        private final ByteIO<T> mNewByteIO;

        private LegacySerializableConversionByteIO(String theOld, String theNew) {
            this(theOld, theNew, null);
        }

        private LegacySerializableConversionByteIO(String theOld, String theNew, ByteIO<T> theNewByteIO) {
            this.mNewByteIO = theNewByteIO;
            this.mOld = theOld;
            this.mNew = theNew;
        }

        public static <T> LegacySerializableConversionByteIO<T> create(String theOld, String theNew) {
            return new LegacySerializableConversionByteIO<T>(theOld, theNew);
        }

        public static <T> LegacySerializableConversionByteIO<T> create(String theOld, String theNew, ByteIO<T> theNewIO) {
            return new LegacySerializableConversionByteIO<T>(theOld, theNew, theNewIO);
        }

        @Override
        public T read(ByteReader aReader) throws IOException {
            int aType = aReader.readInt();
            if (aType != 2048) {
                return (T)(this.mNewByteIO != null ? this.mNewByteIO.read((ByteReader)new PushbackByteReader(aReader, Ints.toByteArray((int)aType))) : ByteIO.getGeneric().read((ByteReader)new PushbackByteReader(aReader, Ints.toByteArray((int)aType))));
            }
            try {
                TransformingObjectInputStream ois = new TransformingObjectInputStream((InputStream)new ByteReaderInputStream(aReader), this.isObjectInPackage(this.mOld), new Rename(this.mOld, this.mNew));
                return (T)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e.getMessage());
            }
        }

        private Predicate<ObjectStreamClass> isObjectInPackage(String thePkg) {
            return theObjectStreamClass -> theObjectStreamClass != null && theObjectStreamClass.getName().startsWith(thePkg);
        }

        @Override
        public void write(T theValue, ByteWriter theByteWriter) throws IOException {
            if (this.mNewByteIO == null) {
                ByteIO.getGeneric().write(theValue, theByteWriter);
            } else {
                this.mNewByteIO.write(theValue, theByteWriter);
            }
        }
    }

    public static final class TransformingObjectInputStream
    extends ObjectInputStream {
        private final Predicate<ObjectStreamClass> mFilter;
        private final Function<ObjectStreamClass, ObjectStreamClass> mMapping;

        public TransformingObjectInputStream(InputStream theInputStream, Predicate<ObjectStreamClass> theFilter, Function<ObjectStreamClass, ObjectStreamClass> theMapping) throws IOException {
            super(theInputStream);
            this.mFilter = theFilter;
            this.mMapping = theMapping;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass theObjectStreamClass) throws IOException, ClassNotFoundException {
            if (this.mFilter.test(theObjectStreamClass)) {
                return super.resolveClass(this.mMapping.apply(theObjectStreamClass));
            }
            return super.resolveClass(theObjectStreamClass);
        }
    }

    private static final class Rename
    implements Function<ObjectStreamClass, ObjectStreamClass> {
        private final String mToFind;
        private final String mReplace;

        private Rename(String theToFind, String theReplace) {
            this.mReplace = theReplace;
            this.mToFind = theToFind;
        }

        @Override
        public ObjectStreamClass apply(ObjectStreamClass theObjectStreamClass) {
            try {
                return theObjectStreamClass != null && theObjectStreamClass.getName().contains(this.mToFind) ? ObjectStreamClass.lookup(Class.forName(theObjectStreamClass.getName().replace(this.mToFind, this.mReplace))) : theObjectStreamClass;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static abstract class CollectionByteIO<T>
    extends ByteIO<Collection<T>> {
        private final ByteIO<T> mElementIO;

        protected CollectionByteIO(ByteIO<T> theElementIO) {
            this.mElementIO = theElementIO;
        }

        protected abstract ImmutableCollection.Builder<T> newBuilder();

        @Override
        public Collection<T> read(ByteReader theReader) throws IOException {
            ImmutableCollection.Builder<T> aBuilder = this.newBuilder();
            int aNum = theReader.readInt();
            for (int i = 0; i < aNum; ++i) {
                aBuilder.add(this.mElementIO.read(theReader));
            }
            return aBuilder.build();
        }

        @Override
        public void write(Collection<T> theValue, ByteWriter theByteWriter) throws IOException {
            theByteWriter.writeInt(theValue.size());
            for (T aObj : theValue) {
                this.mElementIO.write(aObj, theByteWriter);
            }
        }
    }
}

