/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.logging;

import com.complexible.stardog.ErrorCodes;
import com.stardog.ErrorCode;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;

@Plugin(name="ErrorRewritePolicy", category="Core", elementType="rewritePolicy", printObject=true)
public class ErrorEncodingPolicy
implements RewritePolicy {
    private final boolean printStackTraces;

    private ErrorEncodingPolicy(boolean thePrintStackTraces) {
        this.printStackTraces = thePrintStackTraces;
    }

    public LogEvent rewrite(LogEvent source) {
        Throwable aThrown = source.getThrown();
        if (aThrown == null) {
            return source;
        }
        Message codedMessage = this.getCodedMessage(source.getMessage(), aThrown);
        Log4jLogEvent.Builder eventBuilder = new Log4jLogEvent.Builder(source).setMessage(codedMessage);
        if (!this.printStackTraces && source.getLevel().isMoreSpecificThan(Level.INFO)) {
            eventBuilder = eventBuilder.setThrown(null);
        }
        return eventBuilder.build();
    }

    public String toString() {
        return "ErrorEncodingPolicy";
    }

    private Message getCodedMessage(Message baseMessage, Throwable thrown) {
        String mStr = baseMessage.getFormattedMessage();
        ErrorCode code = ErrorCodes.parseCode(thrown);
        if (thrown.getMessage() != null) {
            return new ParameterizedMessage("{} (error {}: {})", new Object[]{mStr, code.getFormattedString(), thrown.getMessage()});
        }
        return new ParameterizedMessage("{} (error {}: {})", new Object[]{mStr, code.getFormattedString(), thrown.getClass().getName()});
    }

    @PluginFactory
    public static ErrorEncodingPolicy createPolicy(@PluginAttribute(value="printStackTrace") boolean thePrintStackTraces) {
        return new ErrorEncodingPolicy(thePrintStackTraces);
    }
}

