/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.index.disk;

import com.complexible.common.unsafe.UnsafeUtil;
import com.complexible.stardog.index.IndexOptions;
import com.complexible.stardog.metadata.ConfigProperty;
import com.complexible.stardog.metadata.MetaProperties;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.MetaPropertyProvider;
import com.complexible.stardog.metadata.Metadata;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public final class DiskOptions
implements MetaPropertyProvider {
    private static final String OPTION_BUCKET_SIZE = "load.bucket.size";
    private static final String OPTION_FILESIZE = "index.disk.file.size";
    private static final String OPTION_PAGESIZE = "index.disk.page.size";
    private static final String OPTION_TOTAL_PAGE_COUNT = "index.disk.page.count.total";
    private static final String OPTION_USED_PAGE_COUNT = "index.disk.page.count.used";
    private static final String OPTION_PAGE_FILL_RATIO = "index.disk.page.fill.ratio";
    private static final String OPTION_STATS_TYPE = "index.stats.type";
    private static final String OPTION_FILE_FACTORY = "index.disk.file.factory";
    private static final String OPTION_DICTIONARY_TYPE = "index.dictionary.type";
    private static final String OPTION_DICTIONARY_PAGE_SIZE = "index.dictionary.page.size";
    private static final String OPTION_DICTIONARY_COMPRESS_NAMESPACE = "index.dictionary.compress.namespace";
    private static final String OPTION_DICTIONARY_COMPRESS_LITERAL = "index.dictionary.compress.literal";
    private static final String OPTION_DICTIONARY_MINIMIZE = "index.dictionary.minimize";
    private static final byte DEFAULT_DICTIONARY = 1;
    @Deprecated
    public static final ConfigProperty<Integer> PAGESIZE = MetaProperty.config("index.disk.page.size", 8192).diskIndex().temporary().build();
    @Deprecated
    public static final ConfigProperty<Long> TOTAL_PAGE_COUNT = MetaProperty.config("index.disk.page.count.total", 0L).diskIndex().temporary().readable().build();
    @Deprecated
    public static final ConfigProperty<Long> USED_PAGE_COUNT = MetaProperty.config("index.disk.page.count.used", 0L).diskIndex().temporary().readable().build();
    @Deprecated
    public static final ConfigProperty<Double> PAGE_FILL_RATIO = MetaProperty.config("index.disk.page.fill.ratio", 0.0).diskIndex().temporary().readable().build();
    @Deprecated
    public static final ConfigProperty<Long> FILESIZE = MetaProperty.config("index.disk.file.size", Integer.MAX_VALUE).diskIndex().temporary().build();
    public static final ConfigProperty<Integer> BULK_LOADING_BUCKET_SIZE = MetaProperty.config("load.bucket.size", 1000000).index().temporary().build();
    @Deprecated
    public static final ConfigProperty<Byte> STATS_TYPE = MetaProperty.config("index.stats.type", (byte)0).diskIndex().temporary().build();
    @Deprecated
    public static final ConfigProperty<Byte> FILE_FACTORY = MetaProperty.config("index.disk.file.factory", (byte)0).diskIndex().temporary().build();
    public static final ConfigProperty<Byte> DICTIONARY_TYPE = MetaProperty.config("index.dictionary.type", (byte)1).diskIndex().temporary().build();
    @Deprecated
    public static final ConfigProperty<String> PAGES_FILENAME = MetaProperty.config("index.file.name.pages", "pages").diskIndex().temporary().build();
    @Deprecated
    public static final ConfigProperty<String> KEYS_FILENAME = MetaProperty.config("index.file.name.keys", "keys").diskIndex().temporary().build();
    @Deprecated
    public static final ConfigProperty<String> STATS_FILENAME = MetaProperty.config("index.file.name.stats", "stats").diskIndex().temporary().build();
    public static final ConfigProperty<String> DICT_FILENAME = MetaProperty.config("index.file.name.dict", "dict").diskIndex().temporary().build();
    @Deprecated
    public static final ConfigProperty<String> DIFF_FILENAME = MetaProperty.config("index.file.name.diff", "diff").diskIndex().temporary().build();
    public static final ConfigProperty<Integer> DICT_PAGE_SIZE = MetaProperty.config("index.dictionary.page.size", UnsafeUtil.UNSAFE_AVAILABLE ? UnsafeUtil.UNSAFE.pageSize() : 4096).diskIndex().temporary().creatable().build();
    public static final ConfigProperty<Boolean> DICT_COMPRESS_NAMESPACE = MetaProperty.config("index.dictionary.compress.namespace", true).diskIndex().creatable().readable().build();
    public static final ConfigProperty<Integer> DICT_COMPRESS_LITERAL = MetaProperty.config("index.dictionary.compress.literal", 2048).diskIndex().creatable().readable().build();
    public static final ConfigProperty<Boolean> DICT_MINIMIZE = MetaProperty.config("index.dictionary.minimize", false).diskIndex().creatable().readable().build();
    public static final ConfigProperty<Integer> DICTIONARY_PARALLELISM = MetaProperty.config("dictionary.parallelism", Integer.class).diskIndex().creatable().readable().build();
    @Deprecated
    public static final ConfigProperty<Boolean> MMAP_PAGES = MetaProperty.config("index.mmap.pages", false).diskIndex().temporary().build();

    @Inject
    DiskOptions() {
    }

    public static int pageSize(Metadata theOptions) {
        return theOptions.get(PAGESIZE);
    }

    public static long fileSize(Metadata theOptions) {
        return theOptions.get(FILESIZE);
    }

    public static int bulkLoadingBucketSize(Metadata theOptions) {
        return theOptions.get(BULK_LOADING_BUCKET_SIZE);
    }

    public static Metadata defaults() {
        return MetaProperties.defaults(MetaProperties.diskProperties()).set(IndexOptions.INDEX_TYPE, IndexOptions.IndexType.Disk).set(IndexOptions.PERSIST, true);
    }
}

