/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.index;

import com.complexible.stardog.index.IndexOrder;
import com.complexible.stardog.index.IndexOrderDependency;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;

public enum IndexStrategy {
    FULL_QUADS(new IndexOrderDependency(IndexOrder.SPO, IndexOrder.SP, IndexOrder.S, IndexOrder.C), new IndexOrderDependency(IndexOrder.POS, IndexOrder.PO, IndexOrder.P), new IndexOrderDependency(IndexOrder.OSP, IndexOrder.OS, IndexOrder.O), new IndexOrderDependency(IndexOrder.PSO, IndexOrder.PS), new IndexOrderDependency(IndexOrder.SOP, IndexOrder.SO), new IndexOrderDependency(IndexOrder.OPS, IndexOrder.OP), new IndexOrderDependency(IndexOrder.SPOC, IndexOrder.SPC, IndexOrder.SC), new IndexOrderDependency(IndexOrder.PSOC, IndexOrder.PSC), new IndexOrderDependency(IndexOrder.POSC, IndexOrder.POC, IndexOrder.PC), new IndexOrderDependency(IndexOrder.OPSC, IndexOrder.OPC), new IndexOrderDependency(IndexOrder.OSPC, IndexOrder.OSC, IndexOrder.OC), new IndexOrderDependency(IndexOrder.SOPC, IndexOrder.SOC)),
    QUADS(new IndexOrderDependency(IndexOrder.SPO, IndexOrder.SC, IndexOrder.C), new IndexOrderDependency(IndexOrder.POS, IndexOrder.POC, IndexOrder.PC), new IndexOrderDependency(IndexOrder.OSP, IndexOrder.OC), new IndexOrderDependency(IndexOrder.PSO, IndexOrder.PSC), new IndexOrderDependency(IndexOrder.SPOC), new IndexOrderDependency(IndexOrder.POSC), new IndexOrderDependency(IndexOrder.OSPC), new IndexOrderDependency(IndexOrder.PSOC)),
    REDUCED_QUADS(new IndexOrderDependency(IndexOrder.SPO, IndexOrder.C), new IndexOrderDependency(IndexOrder.POS), new IndexOrderDependency(IndexOrder.OSP), new IndexOrderDependency(IndexOrder.PSO), new IndexOrderDependency(IndexOrder.SPOC), new IndexOrderDependency(IndexOrder.POSC), new IndexOrderDependency(IndexOrder.OSPC), new IndexOrderDependency(IndexOrder.PSOC)),
    FULL_QUADS_NO_AGG(new IndexOrderDependency(IndexOrder.SPO), new IndexOrderDependency(IndexOrder.POS), new IndexOrderDependency(IndexOrder.OSP), new IndexOrderDependency(IndexOrder.PSO), new IndexOrderDependency(IndexOrder.SOP), new IndexOrderDependency(IndexOrder.OPS), new IndexOrderDependency(IndexOrder.SPOC), new IndexOrderDependency(IndexOrder.PSOC), new IndexOrderDependency(IndexOrder.POSC), new IndexOrderDependency(IndexOrder.OPSC), new IndexOrderDependency(IndexOrder.OSPC), new IndexOrderDependency(IndexOrder.SOPC)),
    NO_AGGREGATE_INDEXES(new IndexOrderDependency(IndexOrder.SPO), new IndexOrderDependency(IndexOrder.POS), new IndexOrderDependency(IndexOrder.OSP), new IndexOrderDependency(IndexOrder.PSO), new IndexOrderDependency(IndexOrder.SPOC), new IndexOrderDependency(IndexOrder.POSC), new IndexOrderDependency(IndexOrder.OSPC), new IndexOrderDependency(IndexOrder.PSOC));

    private final ImmutableList<IndexOrderDependency> mGroups;
    private final ImmutableSet<IndexOrder> mOrders;

    private IndexStrategy(IndexOrderDependency ... theGroups) {
        this.mGroups = ImmutableList.copyOf((Object[])theGroups);
        HashSet aOrders = Sets.newHashSet();
        for (IndexOrderDependency aGroup : theGroups) {
            aOrders.add(aGroup.ternary());
            aOrders.add(aGroup.binary());
            aOrders.add(aGroup.unary());
            aOrders.add(aGroup.context());
        }
        aOrders.remove(null);
        this.mOrders = Sets.immutableEnumSet((Iterable)aOrders);
    }

    public ImmutableSet<IndexOrder> getOrders() {
        return this.mOrders;
    }

    public ImmutableList<IndexOrderDependency> getGroups() {
        return this.mGroups;
    }

    public boolean contains(IndexOrder theOrder) {
        return this.mOrders.contains((Object)theOrder);
    }
}

