/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.index;

import com.complexible.stardog.index.IndexOrder;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;

@Immutable
public final class IndexOrderDependency {
    private final IndexOrder mTernaryOrder;
    private final IndexOrder mBinaryOrder;
    private final IndexOrder mUnaryOrder;
    private final IndexOrder mContextOrder;

    public IndexOrderDependency(IndexOrder ... theOrders) {
        int n = theOrders.length;
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"Ternary index order cannot be null");
        this.mTernaryOrder = theOrders[0];
        Preconditions.checkArgument((this.mTernaryOrder != null && this.mTernaryOrder.isTernary() ? 1 : 0) != 0, (Object)"First index order should be a ternary order");
        int i = 1;
        this.mBinaryOrder = i < n && theOrders[i].isBinary() ? theOrders[i++] : null;
        this.mUnaryOrder = i < n && theOrders[i].isUnary() ? theOrders[i++] : null;
        this.mContextOrder = i < n && theOrders[i].isContext() ? theOrders[i++] : null;
        Preconditions.checkArgument((i == n ? 1 : 0) != 0, (Object)"Invalid index orders");
    }

    public IndexOrder ternary() {
        return this.mTernaryOrder;
    }

    public IndexOrder binary() {
        return this.mBinaryOrder;
    }

    public IndexOrder unary() {
        return this.mUnaryOrder;
    }

    public IndexOrder context() {
        return this.mContextOrder;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("(");
        Joiner.on((String)" - ").skipNulls().appendTo(sb, (Object)this.mTernaryOrder, (Object)this.mBinaryOrder, new Object[]{this.mUnaryOrder, this.mContextOrder});
        sb.append(")");
        return sb.toString();
    }

    public int indexCount() {
        int count = 1;
        if (this.mBinaryOrder != null) {
            ++count;
        }
        if (this.mUnaryOrder != null) {
            ++count;
        }
        if (this.mContextOrder != null) {
            ++count;
        }
        return count;
    }
}

