/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv.shacl.validator;

import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.complexible.common.rdf.rio.TurtleValueWriter;
import com.complexible.stardog.icv.Constraint;
import com.complexible.stardog.icv.ValidationOptions;
import com.complexible.stardog.icv.shacl.SHACL;
import com.complexible.stardog.icv.shacl.ShaclConstraint;
import com.complexible.stardog.icv.shacl.ShaclWriter;
import com.complexible.stardog.icv.shacl.ValidationResult;
import com.complexible.stardog.icv.shacl.validator.Vars;
import com.complexible.stardog.query.hints.Toggle;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespaces;
import com.stardog.stark.OWL;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFWriters;
import com.stardog.stark.io.WriterOptions;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.impl.MapBindingSet;
import com.stardog.stark.vocabs.RDF;
import com.stardog.stark.vocabs.RDFS;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ShaclUtils {
    public static final List<String> VALIDATE_SERVICE_VARS = Vars.ALL;
    public static final String VALIDATE_SERVICE_CALL = "    SERVICE icv:validate {\n      _:serviceParams\n         icv:resultSeverity ?severity ;\n         icv:resultMessage ?message ;\n         icv:sourceShape ?shape ;\n         icv:sourceConstraint ?constraint ;\n         icv:sourceConstraintComponent ?component ;\n         icv:focusNode ?focusNode ;\n         icv:resultPath ?path ;\n         icv:value ?valueNode ;\n    }\n";
    public static final String VALIDATE_SERVICE_CONSTRUCT = ShaclUtils.createValidateReportConstructQuery("    SERVICE icv:validate {\n      _:serviceParams\n         icv:resultSeverity ?severity ;\n         icv:resultMessage ?message ;\n         icv:sourceShape ?shape ;\n         icv:sourceConstraint ?constraint ;\n         icv:sourceConstraintComponent ?component ;\n         icv:focusNode ?focusNode ;\n         icv:resultPath ?path ;\n         icv:value ?valueNode ;\n    }\n");
    public static final String VALIDATE_SERVICE_SELECT = "PREFIX icv: <tag:stardog:api:icv:>\nSELECT * {\n    SERVICE icv:validate {\n      _:serviceParams\n         icv:resultSeverity ?severity ;\n         icv:resultMessage ?message ;\n         icv:sourceShape ?shape ;\n         icv:sourceConstraint ?constraint ;\n         icv:sourceConstraintComponent ?component ;\n         icv:focusNode ?focusNode ;\n         icv:resultPath ?path ;\n         icv:value ?valueNode ;\n    }\n}";
    public static final Set<IRI> SHACL_PREDICATES = ImmutableSet.of((Object)SHACL.deactivated, (Object)SHACL.targetClass, (Object)SHACL.targetNode, (Object)SHACL.targetObjectsOf, (Object)SHACL.targetSubjectsOf, (Object)SHACL.message, (Object[])new IRI[]{SHACL.severity, SHACL.conforms, SHACL.result, SHACL.shapesGraphWellFormed, SHACL.detail, SHACL.focusNode, SHACL.resultMessage, SHACL.resultPath, SHACL.resultSeverity, SHACL.sourceConstraint, SHACL.sourceShape, SHACL.sourceConstraintComponent, SHACL.value, SHACL.shapesGraph, SHACL.suggestedShapesGraph, SHACL.entailment, SHACL.path, SHACL.inversePath, SHACL.alternativePath, SHACL.zeroOrMorePath, SHACL.oneOrMorePath, SHACL.zeroOrOnePath, SHACL.parameter, SHACL.labelTemplate, SHACL.optional, SHACL.validator, SHACL.nodeValidator, SHACL.propertyValidator, SHACL.and, SHACL.closed, SHACL.ignoredProperties, SHACL.datatype, SHACL.disjoint, SHACL.equals, SHACL.hasValue, SHACL.in, SHACL.languageIn, SHACL.lessThan, SHACL.lessThanOrEquals, SHACL.maxCount, SHACL.maxExclusive, SHACL.maxInclusive, SHACL.maxLength, SHACL.minCount, SHACL.minExclusive, SHACL.minInclusive, SHACL.minLength, SHACL.node, SHACL.nodeKind, SHACL.not, SHACL.or, SHACL.flags, SHACL.pattern, SHACL.property, SHACL.qualifiedMaxCount, SHACL.qualifiedMinCount, SHACL.qualifiedValueShape, SHACL.qualifiedValueShapesDisjoint, SHACL.uniqueLang, SHACL.xone, SHACL.ask, SHACL.construct, SHACL.select, SHACL.update, SHACL.prefixes, SHACL.declare, SHACL.prefix, SHACL.namespace, SHACL.sparql, SHACL.defaultValue, SHACL.description, SHACL.group, SHACL.name, SHACL.order, SHACL.target, SHACL.returnType, SHACL.resultAnnotation, SHACL.annotationProperty, SHACL.annotationValue, SHACL.annotationVarName, SHACL.filterShape, SHACL.nodes, SHACL.intersection, SHACL.union, SHACL.expression, SHACL.rule, SHACL.condition, SHACL.subject, SHACL.predicate, SHACL.object, SHACL.js, SHACL.jsFunctionName, SHACL.jsLibrary, SHACL.jsLibraryURL, SHACL.customNamedGraphs, SHACL._class, SHACL._this, RDF.FIRST, RDF.REST, OWL.IMPORTS});
    public static final Set<IRI> SHACL_TYPES = ImmutableSet.of((Object)RDFS.CLASS, (Object)OWL.CLASS);

    public static String createValidateReportConstructQuery(String body) {
        return "PREFIX icv: <tag:stardog:api:icv:>\nPREFIX sh: <http://www.w3.org/ns/shacl#> \nCONSTRUCT {\n    ?report a sh:ValidationReport ;\n    sh:conforms ?conforms ;\n    sh:result ?result .\n    ?result \n        a sh:ValidationResult ;\n        sh:resultSeverity ?severity ;\n        sh:resultMessage ?message ;\n        sh:sourceShape ?shape ;\n        sh:sourceConstraint ?constraint ;\n        sh:sourceConstraintComponent ?component ;\n        sh:focusNode ?focusNode ;\n        sh:resultPath ?path ;\n        sh:value ?valueNode ;\n}\nWHERE {\n  OPTIONAL {\n" + body + "    BIND(bnode() as ?result)\n  }\n  BIND(!bound(?result) as ?conforms)\n  BIND(bnode(sha1(str(now()))) as ?report)\n}";
    }

    public static String createValidateQuery(Options options) {
        int limit;
        int limit2;
        StringBuilder mBuilder = new StringBuilder();
        TurtleValueWriter mTermRenderer = new TurtleValueWriter((Iterable)Namespaces.DEFAULT, WriterOptions.defaults().set(WriterOptions.PRETTY_PRINT, (Object)false));
        if (options.contains(ValidationOptions.TARGET_CLASS_SIMPLE)) {
            Toggle value = options.is(ValidationOptions.TARGET_CLASS_SIMPLE) ? Toggle.ON : Toggle.OFF;
            mBuilder.append("#pragma simple.target ").append((Object)value).append("\n");
        }
        mBuilder.append("VALIDATE");
        Collection targetNodes = (Collection)options.get(ValidationOptions.NODES);
        for (Value targetNode : targetNodes) {
            mBuilder.append(" ").append(mTermRenderer.write(targetNode));
        }
        boolean containsTargetGraphs = options.contains(ValidationOptions.GRAPHS);
        if (containsTargetGraphs) {
            mBuilder.append(" ").append("GRAPH");
            Collection targetGraphs = (Collection)options.get(ValidationOptions.GRAPHS);
            for (IRI targetGraph : targetGraphs) {
                mBuilder.append(" ").append(mTermRenderer.write((Value)targetGraph));
            }
        }
        if (targetNodes.isEmpty() && !containsTargetGraphs) {
            mBuilder.append(" ALL");
        }
        Collection constraints = (Collection)options.get(ValidationOptions.CONSTRAINTS);
        Collection shapes = (Collection)options.get(ValidationOptions.SHAPES);
        if (!constraints.isEmpty()) {
            mBuilder.append("\nUSING SHAPES {\n");
            Set<Statement> stmts = ShaclUtils.toStatements(constraints, shapes);
            Iterator<Statement> iterator = stmts.iterator();
            while (iterator.hasNext()) {
                Statement stmt = iterator.next();
                mBuilder.append(mTermRenderer.write((Value)stmt.subject())).append(" ").append(mTermRenderer.write((Value)stmt.predicate())).append(" ").append(mTermRenderer.write(stmt.object())).append(" .\n");
            }
            mBuilder.append("}");
        } else if (!shapes.isEmpty()) {
            mBuilder.append("\n").append("USING SHAPES");
            for (IRI shape : shapes) {
                mBuilder.append(" ").append(mTermRenderer.write((Value)shape));
            }
        } else if (options.contains(ValidationOptions.SHAPE_GRAPHS)) {
            mBuilder.append("\n").append("USING SHAPES").append(" ").append("GRAPH");
            Collection shapeGraphs = (Collection)options.get(ValidationOptions.SHAPE_GRAPHS);
            for (IRI shapeGraph : shapeGraphs) {
                mBuilder.append(" ").append(mTermRenderer.write((Value)shapeGraph));
            }
        }
        if (options.contains(ValidationOptions.COUNT_LIMIT) && (limit2 = ((Integer)options.get(ValidationOptions.COUNT_LIMIT)).intValue()) != -1) {
            mBuilder.append("\n");
            mBuilder.append("LIMIT").append(" ").append(limit2);
        }
        if (options.contains(ValidationOptions.COUNT_LIMIT_PER_SHAPE) && (limit = ((Integer)options.get(ValidationOptions.COUNT_LIMIT_PER_SHAPE)).intValue()) != -1) {
            mBuilder.append("\n");
            mBuilder.append("LIMIT PER SHAPE").append(" ").append(limit);
        }
        return mBuilder.toString();
    }

    public static String createValidateServiceConstructQuery(Options options) {
        return ShaclUtils.createValidateServiceQuery(VALIDATE_SERVICE_CONSTRUCT, options);
    }

    public static String createValidateServiceSelectQuery(Options options) {
        return ShaclUtils.createValidateServiceQuery(VALIDATE_SERVICE_SELECT, options);
    }

    public static String createValidateServiceQuery(String template, Options options) {
        StringBuilder sb = new StringBuilder();
        ShaclUtils.addServiceParam(sb, "icv:shape", options, ValidationOptions.SHAPES);
        ShaclUtils.addServiceParam(sb, "icv:shapesGraph", options, ValidationOptions.SHAPE_GRAPHS);
        ShaclUtils.addServiceParam(sb, "icv:dataGraph", options, ValidationOptions.GRAPHS);
        ShaclUtils.addServiceParam(sb, "icv:targetNode", options, ValidationOptions.NODES);
        Collection constraints = (Collection)options.get(ValidationOptions.CONSTRAINTS);
        if (!constraints.isEmpty()) {
            Set<Statement> stmts = ShaclUtils.toStatements(constraints, (Collection)options.get(ValidationOptions.SHAPES));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            RDFWriters.write((OutputStream)out, (RDFFormat)RDFFormats.NTRIPLES, stmts);
            template = template.replace("_:serviceParams", String.valueOf(out) + "\n\n_:serviceParams");
        }
        return template.replace("_:serviceParams", "_:serviceParams " + String.valueOf(sb));
    }

    private static <T extends Value> void addServiceParam(StringBuilder sb, String param, Options options, Option<Collection<T>> option) {
        TurtleValueWriter writer = new TurtleValueWriter((Iterable)Namespaces.DEFAULT);
        if (options.contains(option)) {
            sb.append(((Collection)options.get(option)).stream().map(arg_0 -> ((TurtleValueWriter)writer).write(arg_0)).collect(Collectors.joining(" , ", param + " ", ";\n")));
        }
    }

    public static BindingSet toBindingSet(ValidationResult result) {
        MapBindingSet bindings = new MapBindingSet();
        ShaclUtils.addProperty(bindings, "severity", (Value)result.getSeverity());
        ShaclUtils.addProperty(bindings, "message", (Value)result.getMessage());
        ShaclUtils.addProperty(bindings, "shape", (Value)result.getShape());
        ShaclUtils.addProperty(bindings, "focusNode", result.getFocusNode());
        if (result.getPath() != null) {
            ShaclUtils.addProperty(bindings, "path", (Value)Values.literal((String)result.getPath().toString()));
        }
        ShaclUtils.addProperty(bindings, "valueNode", result.getValueNode());
        ShaclUtils.addProperty(bindings, "constraint", (Value)result.getConstraint());
        ShaclUtils.addProperty(bindings, "component", (Value)result.getComponent());
        return bindings;
    }

    private static void addProperty(MapBindingSet bindings, String var, Value value) {
        if (value != null) {
            bindings.add(var, value);
        }
    }

    public static Set<Statement> toStatements(Collection<Constraint> constraints, Collection<IRI> shapes) {
        Set shapeSet = shapes instanceof Set ? (Set)shapes : Sets.newHashSet(shapes);
        ShaclWriter writer = new ShaclWriter();
        constraints.stream().map(ShaclConstraint.class::cast).map(ShaclConstraint::getShape).filter(shape -> shapeSet.isEmpty() || shapeSet.contains(shape.getResource())).forEach(writer::writeShape);
        return writer.getGraph().graph();
    }
}

