/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv.shacl;

import com.complexible.common.base.CloseableIterator;
import com.complexible.common.rdf.StatementIterator;
import com.complexible.stardog.icv.shacl.PropertyPaths;
import com.complexible.stardog.icv.shacl.SHACL;
import com.complexible.stardog.icv.shacl.ValidationResult;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.vocabs.RDF;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public class ValidationResultWriter
extends AbstractIterator<Statement>
implements StatementIterator {
    private final CloseableIterator<ValidationResult> violations;
    private final List<Statement> report = Lists.newArrayList();
    private Iterator<Statement> stmtIt;
    private final Resource reportRes;

    public ValidationResultWriter(CloseableIterator<ValidationResult> theViolations) {
        this.violations = theViolations;
        this.reportRes = Values.bnode();
        this.stmtIt = Iterators.forArray((Object[])new Statement[]{Values.statement((Resource)this.reportRes, (IRI)RDF.TYPE, (Value)SHACL.ValidationReport), Values.statement((Resource)this.reportRes, (IRI)SHACL.conforms, (Value)Values.literal((!this.violations.hasNext() ? 1 : 0) != 0))});
    }

    public void close() throws RuntimeException {
        this.violations.close();
    }

    public Namespaces namespaces() {
        return Namespaces.DEFAULT;
    }

    protected Statement computeNext() {
        if (!this.stmtIt.hasNext()) {
            if (!this.violations.hasNext()) {
                return (Statement)this.endOfData();
            }
            this.report.clear();
            Resource violationRes = ValidationResultWriter.writeResult((ValidationResult)this.violations.next(), this.report::add);
            this.report.add(Values.statement((Resource)this.reportRes, (IRI)SHACL.result, (Value)violationRes));
            this.stmtIt = this.report.iterator();
            return this.stmtIt.next();
        }
        return this.stmtIt.next();
    }

    public static Resource writeResult(ValidationResult result, Consumer<Statement> graph) {
        BNode violationRes = Values.bnode();
        ValidationResultWriter.addProperty(graph, (Resource)violationRes, RDF.TYPE, (Value)SHACL.ValidationResult);
        ValidationResultWriter.addProperty(graph, (Resource)violationRes, SHACL.resultSeverity, (Value)result.getSeverity());
        ValidationResultWriter.addProperty(graph, (Resource)violationRes, SHACL.sourceShape, (Value)result.getShape());
        ValidationResultWriter.addProperty(graph, (Resource)violationRes, SHACL.sourceConstraint, (Value)result.getConstraint());
        ValidationResultWriter.addProperty(graph, (Resource)violationRes, SHACL.sourceConstraintComponent, (Value)result.getComponent());
        ValidationResultWriter.addProperty(graph, (Resource)violationRes, SHACL.focusNode, result.getFocusNode());
        if (result.getPath() != null) {
            PropertyPaths.writePath(graph, (Resource)violationRes, SHACL.resultPath, result.getPath());
        }
        ValidationResultWriter.addProperty(graph, (Resource)violationRes, SHACL.value, result.getValueNode());
        ValidationResultWriter.addProperty(graph, (Resource)violationRes, SHACL.resultMessage, (Value)result.getMessage());
        return violationRes;
    }

    private static void addProperty(Consumer<Statement> graph, Resource resource, IRI property, Value value) {
        if (value != null) {
            graph.accept(Values.statement((Resource)resource, (IRI)property, (Value)value));
        }
    }
}

