/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv.shacl;

import com.complexible.stardog.icv.shacl.PropertyPath;
import com.complexible.stardog.icv.shacl.SHACL;
import com.complexible.stardog.icv.shacl.Shape;
import com.complexible.stardog.icv.shacl.ValidationResultWriter;
import com.google.common.base.MoreObjects;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import java.util.Objects;
import java.util.function.Consumer;

public class ValidationResult {
    private final Value focusNode;
    private final PropertyPath path;
    private final Value valueNode;
    private final Resource shape;
    private final Literal message;
    private final IRI severity;
    private final Resource constraint;
    private final IRI component;

    private ValidationResult(Builder theBuilder) {
        this.focusNode = theBuilder.focusNode;
        this.path = theBuilder.path;
        this.valueNode = theBuilder.valueNode;
        this.shape = theBuilder.shape;
        this.message = theBuilder.message;
        this.severity = theBuilder.severity;
        this.constraint = theBuilder.constraint;
        this.component = theBuilder.component;
    }

    public Value getFocusNode() {
        return this.focusNode;
    }

    public PropertyPath getPath() {
        return this.path;
    }

    public Value getValueNode() {
        return this.valueNode;
    }

    public Resource getShape() {
        return this.shape;
    }

    public Literal getMessage() {
        return this.message;
    }

    public IRI getSeverity() {
        return this.severity;
    }

    public Resource getConstraint() {
        return this.constraint;
    }

    public IRI getComponent() {
        return this.component;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ValidationResult that = (ValidationResult)obj;
        return Objects.equals(this.path, that.path) && this.valuesEqual(this.focusNode, that.focusNode) && this.valuesEqual(this.valueNode, that.valueNode) && this.valuesEqual((Value)this.shape, (Value)that.shape) && this.valuesEqual((Value)this.severity, (Value)that.severity) && this.valuesEqual((Value)this.constraint, (Value)that.constraint) && this.valuesEqual((Value)this.component, (Value)that.component);
    }

    private boolean valuesEqual(Value v1, Value v2) {
        if (v1 == null) {
            return v2 == null;
        }
        if (v1 instanceof BNode) {
            return v2 instanceof BNode;
        }
        return v1.equals((Object)v2);
    }

    private Value valueOrNull(Value value) {
        return value instanceof BNode ? null : value;
    }

    public int hashCode() {
        return Objects.hash(this.path, this.valueOrNull(this.focusNode), this.valueOrNull(this.valueNode), this.valueOrNull((Value)this.shape), this.severity, this.valueOrNull((Value)this.constraint), this.component);
    }

    public String toString() {
        return "ValidationResult{focusNode=" + String.valueOf(this.focusNode) + ", path=" + String.valueOf(this.path) + ", valueNode=" + String.valueOf(this.valueNode) + ", shape=" + String.valueOf(this.shape) + ", message=" + String.valueOf(this.message) + ", severity=" + String.valueOf(this.severity) + ", constraint=" + String.valueOf(this.constraint) + ", component=" + String.valueOf(this.component) + "}";
    }

    public Resource toRDF(Consumer<Statement> consumer) {
        return ValidationResultWriter.writeResult(this, consumer);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Shape shape) {
        return new Builder().shape(shape.getResource()).message(shape.getMessage()).severity((IRI)MoreObjects.firstNonNull((Object)shape.getSeverity(), (Object)SHACL.Violation));
    }

    public static class Builder {
        private Value focusNode;
        private PropertyPath path;
        private Value valueNode;
        private Resource shape;
        private Literal message;
        private IRI severity;
        private Resource constraint;
        private IRI component;

        public Builder focusNode(Value theFocusNode) {
            this.focusNode = theFocusNode;
            return this;
        }

        public Builder valueNode(Value theValueNode) {
            this.valueNode = theValueNode;
            return this;
        }

        public Builder shape(Resource theShape) {
            this.shape = theShape;
            return this;
        }

        public Builder severity(IRI theSeverity) {
            this.severity = theSeverity;
            return this;
        }

        public Builder message(Literal theMessage) {
            this.message = theMessage;
            return this;
        }

        public Builder component(IRI theComponent) {
            this.component = theComponent;
            return this;
        }

        public Builder path(PropertyPath thePath) {
            this.path = thePath;
            return this;
        }

        public Builder constraint(Resource theConstraint) {
            this.constraint = theConstraint;
            return this;
        }

        public Builder reset() {
            this.focusNode = null;
            this.path = null;
            this.valueNode = null;
            this.shape = null;
            this.message = null;
            this.severity = null;
            this.constraint = null;
            this.component = null;
            return this;
        }

        public ValidationResult build() {
            return new ValidationResult(this);
        }
    }
}

