/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv.shacl;

import com.complexible.stardog.icv.shacl.SHACL;
import com.stardog.stark.IRI;
import com.stardog.stark.Value;
import com.stardog.stark.util.ResourceBuilder;

public class Targets {
    public static NodeTarget nodeTarget(Value theTargetNode) {
        return new NodeTarget(theTargetNode);
    }

    public static ClassTarget classTarget(IRI theTargetClass) {
        return new ClassTarget(theTargetClass);
    }

    public static SubjectsOfTarget subjectsOfTarget(IRI theProperty) {
        return new SubjectsOfTarget(theProperty);
    }

    public static ObjectsOfTarget objectsOfTarget(IRI theProperty) {
        return new ObjectsOfTarget(theProperty);
    }

    public static class NodeTarget
    implements Target {
        private final Value targetNode;

        public NodeTarget(Value theTargetNodes) {
            this.targetNode = theTargetNodes;
        }

        public Value getTargetNode() {
            return this.targetNode;
        }

        @Override
        public void toRDF(ResourceBuilder shape) {
            shape.addProperty(SHACL.targetNode, this.targetNode);
        }
    }

    public static class ClassTarget
    implements Target {
        private final IRI targetClass;

        public ClassTarget(IRI theTargetClass) {
            this.targetClass = theTargetClass;
        }

        public IRI getTargetClass() {
            return this.targetClass;
        }

        @Override
        public void toRDF(ResourceBuilder shape) {
            shape.addProperty(SHACL.targetClass, (Value)this.targetClass);
        }
    }

    public static class SubjectsOfTarget
    implements Target {
        private final IRI property;

        public SubjectsOfTarget(IRI theProperty) {
            this.property = theProperty;
        }

        public IRI getProperty() {
            return this.property;
        }

        @Override
        public void toRDF(ResourceBuilder shape) {
            shape.addProperty(SHACL.targetSubjectsOf, (Value)this.property);
        }
    }

    public static class ObjectsOfTarget
    implements Target {
        private final IRI property;

        public ObjectsOfTarget(IRI theProperty) {
            this.property = theProperty;
        }

        public IRI getProperty() {
            return this.property;
        }

        @Override
        public void toRDF(ResourceBuilder shape) {
            shape.addProperty(SHACL.targetObjectsOf, (Value)this.property);
        }
    }

    public static interface Target {
        public void toRDF(ResourceBuilder var1);
    }
}

