/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv.shacl;

import com.complexible.common.base.ImmutableCollectors;
import com.complexible.common.base.Objects2;
import com.complexible.stardog.icv.shacl.ConstraintComponents;
import com.complexible.stardog.icv.shacl.NodeShape;
import com.complexible.stardog.icv.shacl.PropertyPath;
import com.complexible.stardog.icv.shacl.PropertyPaths;
import com.complexible.stardog.icv.shacl.PropertyShape;
import com.complexible.stardog.icv.shacl.SHACL;
import com.complexible.stardog.icv.shacl.Shape;
import com.complexible.stardog.icv.shacl.Targets;
import com.complexible.stardog.icv.shacl.ValidationReport;
import com.complexible.stardog.icv.shacl.ValidationResult;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.stardog.stark.Graphs;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Namespace;
import com.stardog.stark.OWL;
import com.stardog.stark.RDFLists;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.StatementPattern;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.impl.BooleanLiteral;
import com.stardog.stark.vocabs.RDF;
import com.stardog.stark.vocabs.RDFS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaclReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShaclReader.class);
    private final Multimap<Resource, Statement> stmtsBySubject = HashMultimap.create();
    private final Map<Resource, Shape> shapes = Maps.newHashMap();

    public Map<Resource, Shape> readShapes(Collection<Statement> statements) {
        this.shapes.clear();
        this.stmtsBySubject.clear();
        HashSet unsupportedPredicates = Sets.newHashSet();
        for (Statement stmt2 : statements) {
            this.stmtsBySubject.put((Object)stmt2.subject(), (Object)stmt2);
            if (!stmt2.predicate().equals((Object)SHACL.parameter)) continue;
            this.object(stmt2.object(), SHACL.path).ifPresent(unsupportedPredicates::add);
        }
        for (Statement stmt2 : statements) {
            try {
                this.processTriple(stmt2, statements);
            }
            catch (Exception e) {
                LOGGER.warn("Invalid SHACL statement: " + String.valueOf(stmt2), (Throwable)e);
            }
        }
        for (Shape shape : this.shapes.values()) {
            Resource shapeRes = shape.getResource();
            Collection shapeTriples = this.stmtsBySubject.get((Object)shapeRes);
            boolean isImplictTarget = Iterables.any((Iterable)shapeTriples, stmt -> stmt.predicate().equals((Object)RDF.TYPE) && (stmt.object().equals((Object)RDFS.CLASS) || stmt.object().equals((Object)OWL.CLASS)));
            if (!isImplictTarget) continue;
            shape.addTarget(Targets.classTarget((IRI)shapeRes));
        }
        return this.shapes;
    }

    private void processTriple(Statement stmt, Collection<Statement> statements) {
        Resource shapeRes = stmt.subject();
        if (stmt.predicate().equals((Object)SHACL.property)) {
            Shape shape = this.addShape(shapeRes);
            PropertyShape propertyShape = (PropertyShape)this.addShape((Resource)Objects2.castTo((Object)stmt.object(), Resource.class, (String)"Expected a resource for sh:property but found: ", (Object[])new Object[]{stmt.object()}));
            shape.addPropertyShape(propertyShape);
        } else if (stmt.predicate().equals((Object)SHACL.severity)) {
            Shape shape = this.addShape(shapeRes);
            shape.setSeverity((IRI)stmt.object());
        } else if (stmt.predicate().equals((Object)SHACL.message)) {
            Shape shape = this.addShape(shapeRes);
            shape.setMessage((Literal)stmt.object());
        } else if (stmt.predicate().equals((Object)SHACL.deactivated)) {
            Shape shape = this.addShape(shapeRes);
            shape.setDeactivated(BooleanLiteral.TRUE.equals((Object)stmt.object()));
        } else if (stmt.predicate().equals((Object)SHACL.targetClass)) {
            Shape shape = this.addShape(shapeRes);
            shape.addTarget(Targets.classTarget((IRI)stmt.object()));
        } else if (stmt.predicate().equals((Object)SHACL.targetNode)) {
            Shape shape = this.addShape(shapeRes);
            shape.addTarget(Targets.nodeTarget(stmt.object()));
        } else if (stmt.predicate().equals((Object)SHACL.targetSubjectsOf)) {
            Shape shape = this.addShape(shapeRes);
            shape.addTarget(Targets.subjectsOfTarget((IRI)stmt.object()));
        } else if (stmt.predicate().equals((Object)SHACL.targetObjectsOf)) {
            Shape shape = this.addShape(shapeRes);
            shape.addTarget(Targets.objectsOfTarget((IRI)stmt.object()));
        } else if (stmt.predicate().equals((Object)SHACL._class)) {
            Shape shape = this.addShape(shapeRes);
            shape.addConstraint(new ConstraintComponents.ClassConstraintComponent((IRI)stmt.object()));
        } else if (stmt.predicate().equals((Object)SHACL.hasValue)) {
            Shape shape = this.addShape(shapeRes);
            shape.addConstraint(new ConstraintComponents.HasValueConstraintComponent(stmt.object()));
        } else if (stmt.predicate().equals((Object)SHACL.datatype)) {
            Shape shape = this.addShape(shapeRes);
            shape.addConstraint(new ConstraintComponents.DatatypeConstraintComponent((IRI)stmt.object()));
        } else if (stmt.predicate().equals((Object)SHACL.nodeKind)) {
            Shape shape = this.addShape(shapeRes);
            shape.addConstraint(new ConstraintComponents.NodeKindConstraintComponent((IRI)stmt.object()));
        } else if (stmt.predicate().equals((Object)SHACL.minCount)) {
            Shape shape = this.addShape(shapeRes);
            shape.addConstraint(new ConstraintComponents.MinCountConstraintComponent((Literal)stmt.object()));
        } else if (stmt.predicate().equals((Object)SHACL.maxCount)) {
            Shape shape = this.addShape(shapeRes);
            shape.addConstraint(new ConstraintComponents.MaxCountConstraintComponent((Literal)stmt.object()));
        } else if (stmt.predicate().equals((Object)SHACL.qualifiedMinCount) || stmt.predicate().equals((Object)SHACL.qualifiedMaxCount)) {
            boolean isMin = stmt.predicate().equals((Object)SHACL.qualifiedMinCount);
            Shape shape = this.addShape(shapeRes);
            Shape arg = this.addShape(this.object((Value)shapeRes, SHACL.qualifiedValueShape, Resource.class).get());
            Boolean disjoint = this.object((Value)shapeRes, SHACL.qualifiedValueShapesDisjoint, Literal.class).map(Literal::booleanValue).orElse(Boolean.FALSE);
            shape.addConstraint(isMin ? new ConstraintComponents.QualifiedMinCountConstraintComponent((Literal)stmt.object(), arg, disjoint) : new ConstraintComponents.QualifiedMaxCountConstraintComponent((Literal)stmt.object(), arg, disjoint));
        } else if (stmt.predicate().equals((Object)SHACL.minInclusive)) {
            Shape shape = this.addShape(shapeRes);
            shape.addConstraint(new ConstraintComponents.MinInclusiveConstraintComponent((Literal)stmt.object()));
        } else if (stmt.predicate().equals((Object)SHACL.minExclusive)) {
            Shape shape = this.addShape(shapeRes);
            shape.addConstraint(new ConstraintComponents.MinExclusiveConstraintComponent((Literal)stmt.object()));
        } else if (stmt.predicate().equals((Object)SHACL.maxInclusive)) {
            Shape shape = this.addShape(shapeRes);
            shape.addConstraint(new ConstraintComponents.MaxInclusiveConstraintComponent((Literal)stmt.object()));
        } else if (stmt.predicate().equals((Object)SHACL.maxExclusive)) {
            Shape shape = this.addShape(shapeRes);
            shape.addConstraint(new ConstraintComponents.MaxExclusiveConstraintComponent((Literal)stmt.object()));
        } else if (stmt.predicate().equals((Object)SHACL.minLength)) {
            Shape shape = this.addShape(shapeRes);
            shape.addConstraint(new ConstraintComponents.MinLengthComparisonConstraintComponent((Literal)stmt.object()));
        } else if (stmt.predicate().equals((Object)SHACL.maxLength)) {
            Shape shape = this.addShape(shapeRes);
            shape.addConstraint(new ConstraintComponents.MaxLengthComparisonConstraintComponent((Literal)stmt.object()));
        } else if (stmt.predicate().equals((Object)SHACL.equals)) {
            Shape shape = this.addShape(shapeRes);
            shape.addConstraint(new ConstraintComponents.EqualsConstraintComponent((IRI)stmt.object()));
        } else if (stmt.predicate().equals((Object)SHACL.disjoint)) {
            Shape shape = this.addShape(shapeRes);
            shape.addConstraint(new ConstraintComponents.DisjointConstraintComponent((IRI)stmt.object()));
        } else if (stmt.predicate().equals((Object)SHACL.lessThan)) {
            Shape shape = this.addShape(shapeRes);
            shape.addConstraint(new ConstraintComponents.LessThanConstraintComponent((IRI)stmt.object()));
        } else if (stmt.predicate().equals((Object)SHACL.lessThanOrEquals)) {
            Shape shape = this.addShape(shapeRes);
            shape.addConstraint(new ConstraintComponents.LessThanOrEqualsConstraintComponent((IRI)stmt.object()));
        } else if (stmt.predicate().equals((Object)SHACL.pattern)) {
            Shape shape = this.addShape(shapeRes);
            Literal flags = this.object((Value)shapeRes, SHACL.flags).map(Literal.class::cast).orElse(ConstraintComponents.PatternConstraintComponent.NO_FLAGS);
            shape.addConstraint(new ConstraintComponents.PatternConstraintComponent((Literal)stmt.object(), flags));
        } else if (stmt.predicate().equals((Object)SHACL.closed)) {
            Shape shape = this.addShape(shapeRes);
            boolean isClosed = Literal.booleanValue((Literal)((Literal)stmt.object()));
            List ignoredProps = this.object((Value)shapeRes, SHACL.ignoredProperties).map(obj -> RDFLists.fromStatements((Resource)((Resource)obj), (Iterable)statements)).orElse((List)ImmutableList.of());
            shape.addConstraint(new ConstraintComponents.ClosedConstraintComponent(isClosed, ignoredProps));
        } else if (stmt.predicate().equals((Object)SHACL.uniqueLang)) {
            Shape shape = this.addShape(shapeRes);
            boolean isUnique = Literal.booleanValue((Literal)((Literal)stmt.object()));
            shape.addConstraint(new ConstraintComponents.UniqueLangConstraintComponent(isUnique));
        } else if (stmt.predicate().equals((Object)SHACL.in)) {
            Shape shape = this.addShape(shapeRes);
            List values = RDFLists.fromStatements((Resource)((Resource)stmt.object()), statements);
            shape.addConstraint(new ConstraintComponents.InConstraintComponent(values));
        } else if (stmt.predicate().equals((Object)SHACL.languageIn)) {
            Shape shape = this.addShape(shapeRes);
            List languages = RDFLists.fromStatements((Resource)((Resource)stmt.object()), statements);
            shape.addConstraint(new ConstraintComponents.LanguageInConstraintComponent(languages));
        } else if (stmt.predicate().equals((Object)SHACL.node)) {
            Shape shape = this.addShape(shapeRes);
            Shape arg = this.addShape((Resource)stmt.object());
            shape.addConstraint(new ConstraintComponents.NodeConstraintComponent(arg));
        } else if (stmt.predicate().equals((Object)SHACL.sparql)) {
            Shape shape = this.addShape(shapeRes);
            Resource res = (Resource)stmt.object();
            String query = this.object((Value)res, SHACL.select).map(Value::lex).get();
            List namespaces = (List)this.object((Value)res, SHACL.prefixes).map(this::readNamespaces).orElse(Stream.empty()).collect(ImmutableCollectors.toList());
            Literal message = (Literal)Objects2.castTo(this.object((Value)res, SHACL.message).orElse(null), Literal.class, (String)"Message should be a literal", (Object[])new Object[0]);
            Set<IRI> namedGraphs = this.objects((Value)res, SHACL.customNamedGraphs).map(g -> Values.iri((String)g.toString())).collect(Collectors.toSet());
            shape.addConstraint(new ConstraintComponents.SparqlConstraintComponent(res, query, namespaces, message, namedGraphs));
        } else if (stmt.predicate().equals((Object)SHACL.not)) {
            Shape shape = this.addShape(shapeRes);
            Shape arg = this.addShape((Resource)stmt.object());
            shape.addConstraint(new ConstraintComponents.NotConstraintComponent(arg));
        } else if (stmt.predicate().equals((Object)SHACL.and)) {
            Shape shape = this.addShape(shapeRes);
            List<Shape> args = RDFLists.fromStatements((Resource)((Resource)stmt.object()), statements).stream().map(val -> this.addShape((Resource)val)).collect(Collectors.toList());
            shape.addConstraint(new ConstraintComponents.AndConstraintComponent(args));
        } else if (stmt.predicate().equals((Object)SHACL.or)) {
            Shape shape = this.addShape(shapeRes);
            List<Shape> args = RDFLists.fromStatements((Resource)((Resource)stmt.object()), statements).stream().map(val -> this.addShape((Resource)val)).collect(Collectors.toList());
            shape.addConstraint(new ConstraintComponents.OrConstraintComponent(args));
        } else if (stmt.predicate().equals((Object)SHACL.xone)) {
            Shape shape = this.addShape(shapeRes);
            List<Shape> args = RDFLists.fromStatements((Resource)((Resource)stmt.object()), statements).stream().map(val -> this.addShape((Resource)val)).collect(Collectors.toList());
            shape.addConstraint(new ConstraintComponents.XoneConstraintComponent(args));
        }
    }

    private Shape addShape(Resource shapeRes) {
        Shape shape = this.shapes.get(shapeRes);
        if (shape == null) {
            shape = this.object((Value)shapeRes, SHACL.path).map(pathRes -> new PropertyShape(shapeRes, this.readPath((Value)pathRes))).orElse(new NodeShape(shapeRes));
            this.shapes.put(shapeRes, shape);
        }
        return shape;
    }

    private <T extends Value> Optional<T> object(Value subj, IRI pred, Class<T> cls) {
        String msg = "Excepting a %s but found %s for sh:%s: %s";
        return this.object(subj, pred).map(v -> (Value)Objects2.castTo((Object)v, (Class)cls, (String)String.format(msg, cls.getSimpleName(), v.getClass().getSimpleName(), pred.localName(), v), (Object[])new Object[0]));
    }

    private Optional<Value> object(Value subj, IRI pred) {
        return this.objects(subj, pred).findAny();
    }

    private Stream<Value> objects(Value subj, IRI pred) {
        Resource res = (Resource)Objects2.castTo((Object)subj, Resource.class, (String)"Expecting a resource but found %s: %s", (Object[])new Object[]{subj.getClass(), subj});
        return Graphs.matching((Iterable)this.stmtsBySubject.get((Object)res), (StatementPattern)StatementPattern.sp((Resource)res, (IRI)pred)).map(Statement::object);
    }

    private Collection<Statement> statementsBySubject(Value subj) {
        Resource res = (Resource)Objects2.castTo((Object)subj, Resource.class, (String)"Expecting a resource but found %s: %s", (Object[])new Object[]{subj.getClass(), subj});
        return this.stmtsBySubject.get((Object)res);
    }

    public Stream<Namespace> readNamespaces(Value prefixes) {
        return this.readNamespaces(prefixes, Sets.newHashSet());
    }

    public Stream<Namespace> readNamespaces(Value prefixes, Set<Value> alreadyImported) {
        HashMap seen = Maps.newHashMap();
        Stream<Namespace> namespaces = this.objects(prefixes, SHACL.declare).map(declaration -> {
            String ns;
            String prefix = this.object((Value)declaration, SHACL.prefix).map(Value::lex).get();
            String old = seen.put(prefix, ns = this.object((Value)declaration, SHACL.namespace).map(Value::lex).get());
            if (old != null && !old.equalsIgnoreCase(ns)) {
                throw new IllegalArgumentException("Multiple declarations for prefix " + prefix);
            }
            return Values.namespace((String)prefix, (String)ns);
        });
        alreadyImported.add(prefixes);
        Stream importedNamespaces = this.objects(prefixes, OWL.IMPORTS).filter(theValue -> !alreadyImported.contains(theValue)).flatMap(theValue -> this.readNamespaces((Value)theValue, alreadyImported));
        return Stream.concat(namespaces, importedNamespaces);
    }

    public PropertyPath readPath(Value path) {
        if (path instanceof IRI) {
            return PropertyPaths.predicate((IRI)path);
        }
        Iterator<Statement> iterator = this.statementsBySubject(path).iterator();
        if (iterator.hasNext()) {
            Statement stmt = iterator.next();
            if (stmt.predicate().equals((Object)SHACL.inversePath)) {
                return PropertyPaths.inverse(this.readPath(stmt.object()));
            }
            if (stmt.predicate().equals((Object)SHACL.zeroOrMorePath)) {
                return PropertyPaths.zeroOrMore(this.readPath(stmt.object()));
            }
            if (stmt.predicate().equals((Object)SHACL.zeroOrOnePath)) {
                return PropertyPaths.zeroOrOne(this.readPath(stmt.object()));
            }
            if (stmt.predicate().equals((Object)SHACL.oneOrMorePath)) {
                return PropertyPaths.oneOrMore(this.readPath(stmt.object()));
            }
            if (stmt.predicate().equals((Object)SHACL.alternativePath)) {
                return PropertyPaths.alternative(this.readPathList(stmt.object()));
            }
            return PropertyPaths.sequence(this.readPathList(path));
        }
        throw new IllegalArgumentException("Invalid property path " + String.valueOf(path));
    }

    private PropertyPath[] readPathList(Value path) {
        List list = RDFLists.fromStatements((Resource)((Resource)path), (Iterable)this.stmtsBySubject.values());
        PropertyPath[] paths = (PropertyPath[])list.stream().map(v -> this.readPath((Value)v)).toArray(PropertyPath[]::new);
        return paths;
    }

    public ValidationReport readReport(Iterable<Statement> statements) {
        return this.readReport(statements.iterator());
    }

    public ValidationReport readReport(Iterator<Statement> statements) {
        this.stmtsBySubject.clear();
        statements.forEachRemaining(stmt -> this.stmtsBySubject.put((Object)stmt.subject(), stmt));
        ArrayList results = Lists.newArrayList();
        for (Statement stmt2 : this.stmtsBySubject.values()) {
            if (!stmt2.predicate().equals((Object)SHACL.result)) continue;
            Resource resource = (Resource)stmt2.object();
            ValidationResult result = ValidationResult.builder().path(this.object((Value)resource, SHACL.resultPath).map(this::readPath).orElse(null)).focusNode(this.object((Value)resource, SHACL.focusNode).orElse(null)).valueNode(this.object((Value)resource, SHACL.value).orElse(null)).shape(this.object((Value)resource, SHACL.sourceShape).orElse(null)).constraint(this.object((Value)resource, SHACL.sourceConstraint).orElse(null)).component(this.object((Value)resource, SHACL.sourceConstraintComponent).orElse(null)).message(this.object((Value)resource, SHACL.resultMessage).orElse(null)).severity(this.object((Value)resource, SHACL.resultSeverity).orElse(null)).build();
            results.add(result);
        }
        return new ValidationReport(results);
    }
}

