/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv.shacl;

import com.complexible.common.base.Bool;
import com.complexible.common.base.Options;
import com.complexible.stardog.icv.shacl.ConstraintComponents;
import com.complexible.stardog.icv.shacl.PropertyPath;
import com.complexible.stardog.icv.shacl.PropertyPaths;
import com.complexible.stardog.icv.shacl.PropertyShape;
import com.complexible.stardog.icv.shacl.SHACL;
import com.complexible.stardog.icv.shacl.ShaclReader;
import com.complexible.stardog.icv.shacl.Shape;
import com.complexible.stardog.icv.shacl.Targets;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.stardog.model.DataModelBuilder;
import com.stardog.model.DataModelFormat;
import com.stardog.model.DataModelGenerator;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.OWL;
import com.stardog.stark.Statement;
import com.stardog.stark.vocabs.RDFS;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaclBasedDataModelGenerator
implements DataModelGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShaclBasedDataModelGenerator.class);
    private final Iterable<Shape> shapes;
    private final Set<Statement> metadata;

    public ShaclBasedDataModelGenerator(Iterable<Shape> theShapes) {
        this.shapes = theShapes;
        this.metadata = Collections.emptySet();
    }

    public ShaclBasedDataModelGenerator(Set<Statement> statements) {
        ShaclReader shaclReader = new ShaclReader();
        this.shapes = shaclReader.readShapes(statements).values();
        this.metadata = this.readMetadata(statements);
    }

    public DataModelFormat getFormat() {
        return DataModelFormat.SHACL;
    }

    public DataModelBuilder generate(DataModelBuilder model, Options options) {
        for (Shape shape : this.shapes) {
            this.createType(model, shape, null);
        }
        this.metadata.forEach(arg_0 -> ((DataModelBuilder)model).addStatement(arg_0));
        return model;
    }

    private Optional<IRI> getClassTarget(Shape shape) {
        return FluentIterable.from(shape.getTargets()).filter(Targets.ClassTarget.class).transform(Targets.ClassTarget::getTargetClass).first();
    }

    private Optional<IRI> getClassTarget(ConstraintComponents.NodeConstraintComponent constraint) {
        Shape shape = constraint.getArg();
        return this.getClassTarget(shape).or(FluentIterable.from(shape.getConstraints()).filter(ConstraintComponents.ClassConstraintComponent.class).transform(ConstraintComponents.ClassConstraintComponent::getClassIRI).first());
    }

    private DataModelBuilder.TypeBuilder createType(DataModelBuilder model, Shape shape, DataModelBuilder.TypeBuilder defaultType) {
        DataModelBuilder.TypeBuilder type;
        Optional<IRI> target = this.getClassTarget(shape);
        if (!target.isPresent()) {
            if (defaultType == null) {
                return null;
            }
            type = defaultType;
        } else {
            String name = ((IRI)target.get()).toString();
            type = model.newClass(name);
        }
        for (ConstraintComponents.ConstraintComponent constraint : shape.getConstraints()) {
            if (constraint instanceof ConstraintComponents.NodeConstraintComponent) {
                ConstraintComponents.NodeConstraintComponent nodeConstraint = (ConstraintComponents.NodeConstraintComponent)constraint;
                Optional<IRI> nodeType = this.getClassTarget(nodeConstraint);
                if (nodeType.isPresent()) {
                    type.addSuper(((IRI)nodeType.get()).toString());
                    continue;
                }
                this.createType(model, nodeConstraint.getArg(), type);
                continue;
            }
            if (!(constraint instanceof ConstraintComponents.ClassConstraintComponent)) continue;
            IRI classIRI = ((ConstraintComponents.ClassConstraintComponent)constraint).getClassIRI();
            type.addSuper(classIRI.toString());
        }
        for (PropertyShape propertyShape : shape.getPropertyShapes()) {
            PropertyPath path = propertyShape.getPath();
            if (!(path instanceof PropertyPaths.PredicatePath)) continue;
            String prop = ((PropertyPaths.PredicatePath)path).getPredicate().toString();
            DataModelBuilder.PropertyBuilder builder = type.newProperty(prop);
            String range = null;
            Bool datatype = Bool.UNKNOWN;
            for (ConstraintComponents.ConstraintComponent constraint : propertyShape.getConstraints()) {
                if (constraint instanceof ConstraintComponents.ClassConstraintComponent) {
                    range = ((ConstraintComponents.ClassConstraintComponent)constraint).getClassIRI().toString();
                    continue;
                }
                if (constraint instanceof ConstraintComponents.DatatypeConstraintComponent) {
                    range = ((ConstraintComponents.DatatypeConstraintComponent)constraint).getDatatypeIRI().toString();
                    model.newDatatype(range);
                    continue;
                }
                if (constraint instanceof ConstraintComponents.NodeConstraintComponent) {
                    Optional<IRI> rangeType;
                    if (range != null || !(rangeType = this.getClassTarget((ConstraintComponents.NodeConstraintComponent)constraint)).isPresent()) continue;
                    range = ((IRI)rangeType.get()).toString();
                    continue;
                }
                if (constraint instanceof ConstraintComponents.MinCountConstraintComponent) {
                    builder.minCardinality(Literal.intValue((Literal)((ConstraintComponents.MinCountConstraintComponent)constraint).getCount()));
                    continue;
                }
                if (constraint instanceof ConstraintComponents.MaxCountConstraintComponent) {
                    builder.maxCardinality(Literal.intValue((Literal)((ConstraintComponents.MaxCountConstraintComponent)constraint).getCount()));
                    continue;
                }
                if (constraint instanceof ConstraintComponents.ComparisonConstraintComponent || constraint instanceof ConstraintComponents.LengthComparisonConstraintComponent || constraint instanceof ConstraintComponents.LanguageInConstraintComponent || constraint instanceof ConstraintComponents.UniqueLangConstraintComponent) {
                    datatype = Bool.TRUE;
                    continue;
                }
                if (constraint instanceof ConstraintComponents.NodeKindConstraintComponent) {
                    datatype = Bool.valueOf((((ConstraintComponents.NodeKindConstraintComponent)constraint).getNodeKind() == ConstraintComponents.NodeKind.LITERAL ? 1 : 0) != 0);
                    continue;
                }
                if (constraint instanceof ConstraintComponents.HasValueConstraintComponent) {
                    datatype = Bool.valueOf((boolean)(((ConstraintComponents.HasValueConstraintComponent)constraint).getValue() instanceof Literal));
                    continue;
                }
                if (!(constraint instanceof ConstraintComponents.InConstraintComponent)) continue;
                datatype = Bool.valueOf((boolean)((ConstraintComponents.InConstraintComponent)constraint).getValues().stream().allMatch(v -> v instanceof Literal));
            }
            if (range == null && datatype.isKnown()) {
                IRI rangeIRI = datatype.isTrue() ? RDFS.LITERAL : OWL.THING;
                range = rangeIRI.toString();
            }
            if (range == null) continue;
            builder.range(range);
        }
        return type;
    }

    private HashSet<Statement> readMetadata(Set<Statement> statements) {
        HashSet metadata = Sets.newHashSet();
        HashMultimap stmtsBySubject = HashMultimap.create();
        statements.forEach(arg_0 -> ShaclBasedDataModelGenerator.lambda$readMetadata$1((Multimap)stmtsBySubject, arg_0));
        for (Statement stmt : statements) {
            if (!this.isMetadataPredicate(stmt) && !this.isMetadataObject(stmt)) continue;
            metadata.add(stmt);
            Collection subjStmts = stmtsBySubject.get((Object)stmt.subject());
            if (!subjStmts.stream().anyMatch(s -> s.predicate().equals((Object)SHACL.path))) continue;
            statements.stream().filter(s -> s.predicate().equals((Object)SHACL.property) && s.object().equals((Object)stmt.subject())).forEach(metadata::add);
            subjStmts.stream().filter(s -> s.predicate().equals((Object)SHACL.path) || s.predicate().equals((Object)SHACL.datatype) || s.predicate().equals((Object)SHACL._class)).forEach(metadata::add);
        }
        return metadata;
    }

    private boolean isMetadataPredicate(Statement stmt) {
        String namespace = stmt.predicate().namespace();
        return namespace.equals("tag:stardog:api:model:") || namespace.equals("http://purl.org/dc/elements/1.1/");
    }

    private boolean isMetadataObject(Statement stmt) {
        if (stmt.object() instanceof IRI) {
            String namespace = ((IRI)stmt.object()).namespace();
            return namespace.equals("http://www.w3.org/ns/prov#") || namespace.equals("tag:stardog:api:model:") || namespace.equals("http://www.w3.org/ns/dcat#");
        }
        return false;
    }

    private static /* synthetic */ void lambda$readMetadata$1(Multimap stmtsBySubject, Statement stmt) {
        stmtsBySubject.put((Object)stmt.subject(), (Object)stmt);
    }
}

