/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.db;

import com.complexible.common.base.DateTime;
import com.complexible.common.base.Duration;
import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.complexible.common.rdf.rio.LowercaseBCP47LanguageHandler;
import com.complexible.common.rdf.rio.ParserConfigs;
import com.complexible.stardog.QueryMemoryExceedsStrategy;
import com.complexible.stardog.QueryPlanReuse;
import com.complexible.stardog.index.EqualityReasoningLevel;
import com.complexible.stardog.index.disk.DiskOptions;
import com.complexible.stardog.metadata.ByteIO;
import com.complexible.stardog.metadata.ConfigProperty;
import com.complexible.stardog.metadata.InfoProperty;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.MetaPropertyProvider;
import com.complexible.stardog.metadata.Metadata;
import com.complexible.stardog.metadata.OptionsCategory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Values;
import com.stardog.stark.io.LanguageHandler;
import com.stardog.stark.io.ParserOptions;
import com.stardog.stark.io.language.BCP47LanguageHandler;
import com.stardog.stark.io.language.RFC3066LanguageHandler;
import com.stardog.stark.vocabs.RDFS;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class DatabaseOptions
implements MetaPropertyProvider {
    private static final String OPTION_NAME = "database.name";
    private static final String OPTION_CREATOR = "database.creator";
    private static final String OPTION_TYPE = "database.type";
    private static final String OPTION_IGNORE_BULK_LOAD_FILE_ERRORS = "database.ignore.bulk.load.errors";
    private static final String OPTION_BULK_LOAD_STREAM_FACTORY = "database.bulk.load.stream.factory";
    private static final String OPTION_BULK_LOAD_STREAM_ARGS = "database.bulk.load.stream.args";
    private static final String OPTION_CREATE_TX = "database.transaction.create";
    private static final String OPTION_CREATION = "database.time.creation";
    private static final String OPTION_MODIFICATION = "database.time.modification";
    private static final String OPTION_TX_LOGGED = "transaction.logging";
    private static final String OPTION_TX_LOGS_SIZE = "transaction.logging.rotation.size";
    private static final String OPTION_TX_LOGS_REMOVE_OLD = "transaction.logging.rotation.remove";
    private static final String OPTION_TX_LOGS_KEEP_ROTATED_BACKUP_FILES = "transaction.logging.rotation.keep_backups";
    private static final String OPTION_TX_ISOLATION = "transaction.isolation";
    private static final String OPTION_TX_LOG_USE_ROTATED = "transaction.logging.use.rotated";
    private static final String OPTION_TX_LOG_CHUNK_SIZE = "transaction.logging.chunk.size";
    private static final String OPTION_TX_COMMIT_2P = "transaction.commit.twophase";
    private static final String OPTION_ONLINE = "database.online";
    private static final String OPTION_VIRTUAL_TRANSPARENCY = "virtual.transparency";
    private static final String OPTION_LOCAL_IRI_TEMPLATE_INCLUDES = "local.iri.template.includes";
    private static final String OPTION_LOCAL_IRI_TEMPLATE_EXCLUDES = "local.iri.template.excludes";
    private static final String OPTION_NAMESPACES = "database.namespaces";
    private static final String OPTION_QUERY_TIMEOUT = "query.timeout";
    private static final String OPTION_QUERY_UPDATE_TIMEOUT = "query.update.timeout";
    private static final String OPTION_CONNECTION_TIMEOUT = "database.connection.timeout";
    private static final String OPTION_ARCHETYPES = "database.archetypes";
    private static final String OPTION_STRICT_PARSING = "strict.parsing";
    private static final String OPTION_PRESERVE_BNODE_IDS = "preserve.bnode.ids";
    private static final String OPTION_LANGUAGE_NORMALIZATION = "literal.language.normalization";
    private static final String OPTION_EXTENDED_COMPARISON = "literal.comparison.extended";
    private static final String OPTION_QUERY_ALL_GRAPHS = "query.all.graphs";
    private static final String OPTION_QUERY_PLAN_REUSE = "query.plan.reuse";
    private static final String OPTION_QUERY_UPDATE_GRAPH_DIFF = "query.update.graph.diff";
    private static final String OPTION_LUCENE_MMAP = "index.lucene.mmap";
    private static final String OPTION_QUERY_DESCRIBE_STRATEGY = "query.describe.strategy";
    private static final String OPTION_QUERY_MM_MEMORY_LIMIT = "query.memory.limit";
    private static final String OPTION_QUERY_MM_EXCEEDS_STRATEGY = "query.memory.exceeds.strategy";
    public static final String OPTION_QUERY_LOG_ENABLED = "query.log.enabled";
    private static final String OPTION_SAME_AS_INFERENCES = "reasoning.sameas";
    private static final String OPTION_CATALOG_SCHEMA_EXPORT = "reasoning.schema.catalog.export.enabled";
    private static final String OPTION_EDGE_PROPERTIES = "edge.properties";
    private static final String OPTION_NATIVE_METRICS_REPORTING_INTERVAL = "metrics.native.reportingInterval";
    private static final String OPTION_QUERY_DICTIONARY_THRESHOLD = "query.dictionary.overflow.threshold";
    private static final String OPTION_GRAPH_ALIASES = "graph.aliases";
    private static final String PROPERTY_SPARQL_SERVICE_RESULT_LIMIT = "service.sparql.result.limit";
    private static final String PROPERTY_SERVICE_PREFETCH_THRESHOLD = "service.prefetch.threshold";
    private static final String PROPERTY_SPARQL_SERVICE_CREDENTIALS_PASSTHROUGH_REGEX = "service.sparql.credentials.passthrough.regex";
    private static final String PROPERTY_LABELS = "label.properties";
    private static final String OPTION_VOICEBOX_ENABLED = "voicebox.enabled";
    private static final String OPTION_VOICEBOX_OPTIMIZE = "optimize.voicebox";
    private static final String OPTION_VOICEBOX_PREPROCESSORS = "voicebox.preprocessors";
    private static final String OPTION_VOICEBOX_EXAMPLE_QUESTIONS = "voicebox.example.questions";
    private static final String OPTION_VOICEBOX_SCHEMA_LIMIT = "voicebox.schema.size.limit";
    private static final String OPTION_QUERY_EQUALITY_IDENTITY = "query.term.equality.identity";
    public static final ConfigProperty<Duration> NATIVE_METRICS_REPORTING_INTERVAL = MetaProperty.config("metrics.native.reportingInterval", Duration.valueOf((String)"10s")).database().readable().creatable().writable().build();
    public static final ConfigProperty<EqualityReasoningLevel> EQUALITY_REASONING = MetaProperty.config("reasoning.sameas", EqualityReasoningLevel.OFF).database().readable().creatable().writable().category(OptionsCategory.REASONING).label("SameAs").description("Option to enable owl:sameAs reasoning. When this option is set to \"ON\", then the reflexive, symmetric, and transitive closure of owl:sameAs triples in the database are computed. When it is set to \"FULL\", then owl:sameAs inferences are computed based on schema axioms, such as functional properties. See the docs for more information.").build();
    public static final ConfigProperty<Boolean> CATALOG_SCHEMA_EXPORT = MetaProperty.config("reasoning.schema.catalog.export.enabled", Boolean.TRUE).database().readable().creatable().writableWhileOnline().category(OptionsCategory.REASONING).label("Catalog Schema Export").description("Specifies whether reasoning schemas of this database are copied to Data Catalog").build();
    public static final ConfigProperty<Boolean> AUTO_SCHEMA_REASONING = MetaProperty.config("auto.schema.reasoning", false).database().readable().writableWhileOnline().creatable().category(OptionsCategory.REASONING).label("Auto Schema Reasoning").description("Enables reasoning when automatically generating schemas from OWL. This setting will affect automatic schema generation for GraphQL (if graphql.auto.schema is enabled) and BI/SQL (if sql.schema.auto is enabled).").build();
    public static final ConfigProperty<Boolean> STRICT_PARSING = MetaProperty.config("strict.parsing", true).database().index().readable().creatable().category(OptionsCategory.DATABASE).label("Strict Parsing").description("Controls whether Stardog parses RDF strictly (true, the default) or loosely (false). Setting this to \"false\" will allow, for example, integer literals with leading zeros.").nonsecure().build();
    public static final ConfigProperty<Boolean> EXTENDED_COMPARISON = MetaProperty.config("literal.comparison.extended", true).database().readable().creatable().writableWhileOnline().category(OptionsCategory.DATABASE).label("Extended Comparison").description("Controls whether query evaluation will use extended literal comparison. If enabled, literals of different datatypes are first compared based on their string values and then based on the string value of their datatypes.").build();
    public static final ConfigProperty<Boolean> PRESERVE_BNODE_IDS = MetaProperty.config("preserve.bnode.ids", true).database().index().readable().creatable().category(OptionsCategory.DATABASE).label("Preserve BNode IDs").description("Determines how the Stardog parser handles bnode (blank node) identifiers that may be present in RDF input. If this property is enabled, parsing and data loading performance are improved; but the other effect is that if distinct input files use (randomly or intentionally) the same bnode identifier, that bnode will point to one and the same node in the database. If you have input files that use explicit bnode identifiers, and more than one of those files may use the same bnode identifiers, and you don't want those bnodes to be smushed into a single node in the database, then this configuration option should be disabled. Note that, this option has no effect for input files using the JSON-LD syntax. JSON-LD API specification requires all bnode identifiers from the input document to be mapped to new identifiers so they cannot be preserved in the database.").nonsecure().build();
    public static final ConfigProperty<String> NAME = MetaProperty.config("database.name", String.class).database().index().readable().creatable().category(OptionsCategory.DATABASE).label("Name").description("A database name, the legal value of which is given by the regular expression [A-Za-z]{1}[A-Za-z0-9_-]").nonsecure().build();
    public static final InfoProperty<String> CREATOR = MetaProperty.info("database.creator", String.class).database().readable().category(OptionsCategory.DATABASE).label("Creator").description("Creator of the database").build();
    public static final ConfigProperty<String> TYPE = MetaProperty.config("database.type", "user").database().readable().creatable().category(OptionsCategory.DATABASE).label("Type").description("Specifies the database as either user or system.").build();
    public static final ConfigProperty<Boolean> IGNORE_BULK_LOAD_FILE_ERRORS = MetaProperty.config("database.ignore.bulk.load.errors", true).database().creatable().temporary().category(OptionsCategory.DATABASE).label("Ignore File Errors").description("Option for whether or not to ignore errors encountered while loading data at db creation time. By default, these errors are ignored and db creation will continue with as much data as loaded.").build();
    public static final ConfigProperty<String> BULK_LOAD_STREAM_FACTORY = MetaProperty.config("database.bulk.load.stream.factory", String.class).database().creatable().temporary().category(OptionsCategory.DATABASE).label("Stream Factory").description("Fully qualified class name denoting an implementation of the RDFStreamFactory interface that will be used to load data into the newly created database. This option only takes effect at db creation time. The configuration of the RDFStream instances created is defined via the option database.bulk.load.stream.args.").build();
    public static final ConfigProperty<String> BULK_LOAD_STREAM_ARGS = MetaProperty.config("database.bulk.load.stream.args", String.class).database().creatable().temporary().category(OptionsCategory.DATABASE).label("Stream Arguments").description("Arguments to be passed to the stream factory for configuring the details of the stream instances that will be created. The value should be a ';' separated list of key value pairs separated by ':'. For example, 'subjects: 5; graphs: 3'.").build();
    public static final InfoProperty<Long> CREATION_TX = MetaProperty.info("database.transaction.create", Long.class).database().readable().category(OptionsCategory.DATABASE).label("Creation TX").description("Transaction ID at which this database was created.").build();
    public static final InfoProperty<DateTime> CREATION_TIME = MetaProperty.info("database.time.creation", DateTime.class).database().index().readable().category(OptionsCategory.DATABASE).label("Creation Time").description("Creation time of the database").build();
    public static final InfoProperty<DateTime> MODIFICATION_TIME = MetaProperty.info("database.time.modification", DateTime.class).index().readable().category(OptionsCategory.DATABASE).label("Modification Time").description("Last modification time of the database").build();
    public static final ConfigProperty<Boolean> TRANSACTION_LOGGING = MetaProperty.config("transaction.logging", false).database().readable().writable().creatable().category(OptionsCategory.TRANSACTION).label("Transaction Logging").description("Option for whether or not the database logs all transactions events to disk. The default when not in Cluster mode is \"false\", and when in Cluster mode the default is \"true\".").build();
    public static final ConfigProperty<Boolean> TRANSACTION_LOGGING_USE_ROTATED = MetaProperty.config("transaction.logging.use.rotated", true).database().readable().writable().creatable().category(OptionsCategory.TRANSACTION).label("Transaction Logging Use Rotated").description("Enables using rotated transaction log").build();
    public static final ConfigProperty<Boolean> VIRTUAL_TRANSPARENCY = MetaProperty.config("virtual.transparency", false).database().readable().writableWhileOnline().creatable().category(OptionsCategory.VIRTUAL_GRAPHS).label("Virtual Transparency").description("Determines the default dataset the database evaluates queries against; if true, the named graphs portion of the dataset will default to local named graphs and accessible virtual graphs; if false (the default), the named graphs portion of the dataset will be limited to local named graphs only.").nonsecure().build();
    public static final ConfigProperty<Collection<String>> LOCAL_IRI_TEMPLATE_INCLUDES = MetaProperty.config("local.iri.template.includes", String.class, Collections.emptySet()).database().readable().writableWhileOnline().creatable().category(OptionsCategory.VIRTUAL_GRAPHS).label("Local IRI Template Includes").description("The set of IRI templates representing the form of IRIs which may be present in the subject position of triples in the local database. Used when optimizing queries including both the local database and virtual graphs. IRI templates use the same placeholder syntax as mappings (eg, `{field}`) but the field names are ignored. Templates included here should be used to indicate which IRIs may be present and should be updated when that changes.").build();
    public static final ConfigProperty<Collection<String>> LOCAL_IRI_TEMPLATE_EXCLUDES = MetaProperty.config("local.iri.template.excludes", String.class, Collections.emptySet()).database().readable().writableWhileOnline().creatable().category(OptionsCategory.VIRTUAL_GRAPHS).label("Local IRI Template Excludes").description("The set of IRI templates representing the form of IRIs which may NOT be present in the subject position of triples in the local database. Used when optimizing queries including both the local database and virtual graphs. IRI templates use the same placeholder syntax as mappings (eg, `{field}`) but the field names are ignored. Templates included here should be used to indicate which IRIs are guaranteed not to be present and should be updated when that changes.").build();
    public static final ConfigProperty<Boolean> EDGE_PROPERTIES = MetaProperty.config("edge.properties", false).index().database().readable().creatable().category(OptionsCategory.DATABASE).label("Edge Properties").description("Option for enabling edge properties that allows RDF statements to appear as subjects of RDF statements (aka RDF*). ").nonsecure().build();
    public static final ConfigProperty<String> TRANSACTION_LOGGING_ROTATION_SIZE = MetaProperty.config("transaction.logging.rotation.size", "500M").database().readable().writable().creatable().category(OptionsCategory.TRANSACTION).label("Transaction Logging Rotation Size").description("Determines the size at which the transaction log will be rotated. Accepts human-readable values (e.g., '500M', '1G') or byte values. When transaction.logging.use.rotated is enabled, total disk usage can be up to twice this value.").build();
    public static final ConfigProperty<Boolean> TRANSACTION_LOGGING_ROTATION_REMOVE = MetaProperty.config("transaction.logging.rotation.remove", false).database().readable().writable().creatable().category(OptionsCategory.TRANSACTION).label("Transaction Logging Rotation Remove").description("Determines whether the current log file will be rotated or removed (i.e., truncated)").build();
    public static final ConfigProperty<Boolean> TRANSACTION_LOGGING_KEEP_ROTATED_BACKUP_FILES = MetaProperty.config("transaction.logging.rotation.keep_backups", false).database().readable().writable().creatable().category(OptionsCategory.TRANSACTION).label("Transaction Logging Rotation Keep Backups").description("Determines whether we keep backups of the rotated log file").build();
    public static final ConfigProperty<Integer> TRANSACTION_LOGGING_CHUNK_SIZE = MetaProperty.config("transaction.logging.chunk.size", 1024).database().readable().writable().creatable().category(OptionsCategory.TRANSACTION).label("Transaction Logging Chunk Size").description("Number of statements per chunk when writing to the transaction log").build();
    public static final ConfigProperty<Boolean> ONLINE = MetaProperty.config("database.online", true).database().readable().creatable().category(OptionsCategory.DATABASE).label("Online").description("Whether or not the database is online").nonsecure().build();
    public static final ConfigProperty<Boolean> FAILED_INITIALIZE = MetaProperty.config("database.failed.initialize", false).database().readable().writableWhileOnline().temporary().category(OptionsCategory.DATABASE).label("Failed Initialize").description("Whether or not the database failed to initialize").nonsecure().build();
    public static final ConfigProperty<Boolean> QUERY_ALL_GRAPHS = MetaProperty.config("query.all.graphs", Boolean.class).creatable().readable().database().writableWhileOnline().category(OptionsCategory.QUERY).label("Query All Graphs").description("This option controls the behavior for answering queries that don't specify a dataset (FROM or FROM NAMED) in the query. In such cases, the SPARQL specification says that the query should be answered only using the information in default graph (no context). However, sometimes it is desirable to answer such queries using all the information in the database including the default graph and all named graphs. Setting this option to true changes the behavior of Stardog to do this. Queries that specify a dataset are not affected by this option.").systemDefaultValue(false).build();
    public static final ConfigProperty<QueryPlanReuse> QUERY_PLAN_REUSE = MetaProperty.config("query.plan.reuse", QueryPlanReuse.ALWAYS).creatable().readable().database().writableWhileOnline().category(OptionsCategory.QUERY).label("Query Plan Reuse").description("The conditions under which a cached plan will be reused. \"ALWAYS\" and \"NEVER\" determine query plan reuse as you would expect. \"CARDINALITY\" instructs Stardog to reuse cached query plans for structurally equivalent queries if the cardinality estimations of scans are similar.").build();
    public static final ConfigProperty<Collection<Namespace>> NAMESPACES = MetaProperty.config("database.namespaces", Namespace.class, Sets.newTreeSet((Iterable)Namespaces.DEFAULT)).database().creatable().readable().writableWhileOnline().nonsecure().byteIO(ByteIO.set(ByteIO.NAMESPACE)).category(OptionsCategory.DATABASE).label("Namespaces").description("The default namespaces for the database. Legal input is a comma-separated list of <prefix>=<namespace> values.").nonsecure().build();
    public static final ConfigProperty<Duration> CONNECTION_TIMEOUT = MetaProperty.config("database.connection.timeout", Duration.class).database().readable().creatable().writableWhileOnline().category(OptionsCategory.DATABASE).label("Connection Timeout").description("The amount of time a connection to the database can be open, but inactive, before being automatically closed to reclaim the resources. The following unit suffixes are available: \"ms\" for milliseconds, \"s\" for seconds, \"m\" for minutes, and \"h\" for hours.").systemDefaultValue(Duration.valueOf((String)"10m")).build();
    public static final ConfigProperty<Duration> QUERY_TIMEOUT = MetaProperty.config("query.timeout", Duration.class).database().readable().creatable().writableWhileOnline().category(OptionsCategory.QUERY).label("Query Timeout").description("Determines max execution time for query evaluation. This can also be overridden in a query's parameters.  The following unit suffixes are available: \"ms\" for milliseconds, \"s\" for seconds, \"m\" for minutes, and \"h\" for hours.").systemDefaultValue(Duration.valueOf((String)"5m")).build();
    public static final ConfigProperty<Duration> QUERY_UPDATE_TIMEOUT = MetaProperty.config("query.update.timeout", Duration.class).database().readable().creatable().writableWhileOnline().category(OptionsCategory.QUERY).label("Update Query Timeout").description("Determines max execution time for SPARQL update query evaluation. This can also be overridden in a query's parameters.  The following unit suffixes are available: \"ms\" for milliseconds, \"s\" for seconds, \"m\" for minutes, and \"h\" for hours.").systemDefaultValue(Duration.valueOf((String)"10h")).build();
    public static final ConfigProperty<Collection<String>> ARCHETYPES = MetaProperty.config("database.archetypes", String.class, ImmutableList.of()).database().readable().creatable().writable().category(OptionsCategory.DATABASE).label("Database Archetypes").description("The name of one or more database archetypes, used to associate ontologies and constraints with new databases. See the docs for instructions to create your own archetype.").build();
    public static final ConfigProperty<Boolean> LUCENE_MMAP = MetaProperty.config("index.lucene.mmap", true).database().readable().writable().creatable().category(OptionsCategory.INDEX).label("Lucene Memory-Mapping").description("Enables memory-mapping in lucene indices (e.g., search, spatial).").build();
    public static final ConfigProperty<String> QUERY_DESCRIBE_STRATEGY = MetaProperty.config("query.describe.strategy", "default").database().readable().writableWhileOnline().creatable().category(OptionsCategory.QUERY).label("Describe Strategy").description("The default DESCRIBE query strategy for the database. Built-in strategies include \"default\", \"cbd\" and \"bidirectional\". See the docs for instructions to create your own describe strategy.").build();
    public static final ConfigProperty<Boolean> QUERY_EQUALITY_IDENTITY = MetaProperty.config("query.term.equality.identity", false).database().readable().writable().creatable().category(OptionsCategory.QUERY).label("Query term equality as identity").description("If true, Stardog's query optimizer will interpret equality checks, like FILTER(?x = ?y), as if the variables range over IRIs or strings, i.e., each value can only be equal to itself. This is not true for certain numbers in SPARQL, for example, 1 is equal to 1.0. The default value is false, which is the spec-compliant behavior. Setting it to true can unlock additional optimizations for queries and rules with equality filters.").build();
    public static final ConfigProperty<TransactionIsolation> TRANSACTION_ISOLATION = MetaProperty.config("transaction.isolation", TransactionIsolation.SNAPSHOT).database().readable().creatable().writable().category(OptionsCategory.TRANSACTION).label("Transaction Isolation").description("Configures isolation level for transactions").build();
    public static final ConfigProperty<LanguageNormalization> LANGUAGE_NORMALIZATION = MetaProperty.config("literal.language.normalization", LanguageNormalization.DEFAULT).index().readable().creatable().category(OptionsCategory.DATABASE).label("Language Normalization").description("Configuration option for determining the normalization algorithm for the langauge tags of literals.").build();
    public static final ConfigProperty<Boolean> PROGRESS_MONITOR_ENABLED = MetaProperty.config("progress.monitor.enabled", true).database().readable().creatable().writableWhileOnline().category(OptionsCategory.DATABASE).label("Progress Monitoring Enabled").description("When enabled, the progress of various tasks will be printed in the server log.").build();
    public static final ConfigProperty<Boolean> QUERY_UPDATE_GRAPH_DIFF = MetaProperty.config("query.update.graph.diff", true).database().creatable().readable().writableWhileOnline().category(OptionsCategory.QUERY).label("Update Graph Diff").description("Configuration option for determining the update procedure that will be used for SPARQL update queries ADD, COPY and MOVE").build();
    public static final ConfigProperty<String> QUERY_MEMORY_LIMIT = MetaProperty.config("query.memory.limit", "9223372036854775807B").database().creatable().writableWhileOnline().readable().category(OptionsCategory.QUERY).label("Query memory limit").description("Configuration option for determining the memory limit used by query").build();
    public static final ConfigProperty<QueryMemoryExceedsStrategy> QUERY_MM_EXCEEDS_STRATEGY = MetaProperty.config("query.memory.exceeds.strategy", QueryMemoryExceedsStrategy.SPILL_TO_DISK).database().creatable().writableWhileOnline().readable().category(OptionsCategory.QUERY).label("Query limit exceeds strategy").description("Configuration option for determining strategy for the query behaviour once memory limit reached").build();
    public static final ConfigProperty<Boolean> QUERY_LOG_ENABLED = MetaProperty.config("query.log.enabled", Boolean.TRUE).database().creatable().writableWhileOnline().readable().category(OptionsCategory.QUERY).label("Query logging").description("If set to true, Stardog will log all queries executed against this database").build();
    public static final ConfigProperty<Long> QUERY_DICTIONARY_SIZE_THRESHOLD = MetaProperty.config("query.dictionary.overflow.threshold", 100000L).database().creatable().readable().writableWhileOnline().category(OptionsCategory.QUERY).label("Query Query overflow size threshold").description("Configuration option for the max number of entries in the query-local dictionary before a persistent data structure is used (which can spill data to disk)").build();
    public static final ConfigProperty<Boolean> GRAPH_ALIASES = MetaProperty.config("graph.aliases", false).database().creatable().readable().writable().category(OptionsCategory.DATABASE).label("Named graph aliases").description("Configuration option to enable or disable support for named graph aliases").nonsecure().build();
    public static final ConfigProperty<Long> SPARQL_SERVICE_RESULT_LIMIT = MetaProperty.config("service.sparql.result.limit", Long.class).database().creatable().readable().writableWhileOnline().category(OptionsCategory.QUERY).label("Federation results limit").description("Limits the number of results generated by SERVICE calls to SPARQL endpoints. A negative value means no limit.").build();
    public static final ConfigProperty<Integer> SERVICE_PREFETCH_THRESHOLD = MetaProperty.config("service.prefetch.threshold", Integer.class).database().creatable().readable().writableWhileOnline().category(OptionsCategory.QUERY).label("Cardinality threshold for prefetching solutions from services.").description("The cardinality threshold for prefetching solutions from remote services. A negative value disables prefetching and with a value of Integer.MAX_VALUE (2147483647) prefetching is always enabled. If the estimated cardinality of a service is below the threshold, 10K solutions will be prefetched by default. The number of solutions to be prefetched can be customized with the `service.prefetch.limit` query hint. ").build();
    public static final ConfigProperty<String> SPARQL_SERVICE_CREDENTIALS_PASSTHROUGH_REGEX = MetaProperty.config("service.sparql.credentials.passthrough.regex", String.class).database().creatable().readable().writableWhileOnline().category(OptionsCategory.QUERY).label("SPARQL service credentials passthrough regex").description("Specifies SPARQL endpoints for which SERVICE calls are allowed to pass through current credentials.").build();
    public static final ConfigProperty<Boolean> TX_COMMIT_2P = MetaProperty.config("transaction.commit.twophase", false).database().readable().creatable().writableWhileOnline().category(OptionsCategory.TRANSACTION).label("Two-phase commit").description("Enables two phase commit protocol for the cluster (this option has no effect for the single node server). When this option is enabled all the nodes in the cluster will prepare the transaction in the first phase of the commit. This ensures all nodes complete time-consuming operations and only after that the second phase of the commit will start where the coordinator will send the commit command to the other nodes. Once a node completes the commit operation the effects of the transaction will be visible in query results. With this option enabled the period of time where nodes might return different results to queries will be minimized. This option is most useful for long transactions (e.g., transactions that take several minutes or more) where the commit time for each node might differ in a noticeable way without the additional commit phase. For short transactions, enabling this option will not provide visible benefits (especially if transactions complete under a second) and the overhead of the additional commit phase will result in increased transaction times.").build();
    public static final ConfigProperty<InlineStoredQuery> INLINE_STORED_QUERY = MetaProperty.config("query.inline.sqs", InlineStoredQuery.OPTIMIZER).database().readable().writableWhileOnline().creatable().category(OptionsCategory.QUERY).label("Inline Stored Query").description("Option to control how stored queries should be evaluated inside the Stored Query Service (SQS). If stored queries referenced in SQS are inlined into the parent query some additional optimizations might become possible especially for stored queries involving virtual graphs. But inlined stored queries inherit the dataset of the parent query and might return different results compared to being executed in isolation. Some queries, e.g. stored queries that use path queries or correlation, cannot be inlined at all. The setting `optimizer` allows the optimizer to perform inlining when it is safe and improves query performance. Using the option `always` could cause some SQS executions fail.").build();
    public static final ConfigProperty<List<IRI>> LABEL_PROPERTIES = MetaProperty.configList("label.properties", IRI.class, List.of(RDFS.LABEL)).database().creatable().writable().readable().category(OptionsCategory.DATABASE).label("Label properties").description("Comma-separated list of property IRIs which may be used by the platform to look up entity labels by entity IRIs. By default it's only rdfs:label but properties from SKOS or other schema can be added. The order of the properties in the list reflect their rank when labels from different properties are present for an entity IRI.").build();
    public static final ConfigProperty<Boolean> MEDIA_ENABLED = MetaProperty.config("media.enabled", false).database().creatable().writableWhileOnline().readable().nonsecure().category(OptionsCategory.DATABASE).label("Render media in Stardog Applications").description("Option for whether or not to render media, such as URL hyperlinks in Stardog Applications. By default, media will not be rendered. Use additional caution before enabling this property when using public or unknown data sources.").build();
    public static final ConfigProperty<Boolean> VOICEBOX_ENABLED = MetaProperty.config("voicebox.enabled", Boolean.FALSE).database().creatable().writable().readable().category(OptionsCategory.VOICEBOX).label("Enable Voicebox").description("If set to true, Stardog enables the Voicebox LLM-based features for this database").nonsecure().build();
    public static final ConfigProperty<Boolean> VOICEBOX_OPTIMIZE = MetaProperty.config("optimize.voicebox", true).database().temporary().build();
    public static final ConfigProperty<Collection<String>> VOICEBOX_PREPROCESORS = MetaProperty.config("voicebox.preprocessors", String.class, List.of("default")).database().creatable().writable().readable().category(OptionsCategory.VOICEBOX).label("Voicebox Preprocessors").description("List of preprocessors that will be applied to the stored queries to canonicalize the query serialization. Preprocessors transform queries into a form that is more suitable for Voicebox. Using the 'default' value enables the default list of preprocessors. The value 'noop' can be used to disable preprocessing.").nonsecure().build();
    public static final ConfigProperty<Collection<String>> VOICEBOX_EXAMPLE_QUESTIONS = MetaProperty.config("voicebox.example.questions", String.class, List.of()).database().creatable().writableWhileOnline().readable().category(OptionsCategory.VOICEBOX).label("Voicebox Example Questions").description("List of example questions to showcase in the Voicebox UI for this database. These example questions may or may not correspond to a natural language question associated with a stored query. This option can be set without enabling Voicebox but in that case it will have no effect.").nonsecure().build();
    public static final ConfigProperty<Integer> VOICEBOX_MAX_SCHEMA_SIZE = MetaProperty.config("voicebox.schema.size.limit", Integer.class, 1000000).database().creatable().writable().readable().category(OptionsCategory.VOICEBOX).label("Voicebox Schema Size Limit").description("The max size (in triples) of the schema size that allows Voicebox to be enabled on the database.Large schemas may require long vector indexing time and delay bringing the database online.This limit also applies to Voicebox example questions since their query strings are also vector indexed.").nonsecure().build();
    public static final ConfigProperty<IRI> SQL_SCHEMA_GRAPH = MetaProperty.config("sql.schema.graph", IRI.class, Values.iri((String)"tag:stardog:api:sql:schema")).database().readable().writable().creatable().category(OptionsCategory.SQL).label("Schema Graph").description("Specifies which named graph in the database is used to read SQL schema mapping.").build();
    public static final ConfigProperty<Collection<String>> SYSTEM_GRAPHS = MetaProperty.config("system.graphs", String.class, Collections.singletonList("default")).database().readable().writable().creatable().category(OptionsCategory.DATABASE).label("System graphs").description("Specifies the IRIs of named graphs which contain system data and could be hidden from user queries by excluding the <tag:stardog:api:context:system> alias. By default, the alias is expanded to three graphs: the stored query graph for Voicebox-enabled databases, the graph which stored alias definitions, and the BI/SQL table mapping graph.").build();
    public static final long DEFAULT_OFFLINE_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    public static final String PARSER_OPTION_PREFIX = "parser.";
    public static final Map<MetaProperty<?>, Option<?>> PARSER_OPTIONS = ImmutableMap.builder().put(STRICT_PARSING, (Object)ParserConfigs.STRICT_PARSING).put(PRESERVE_BNODE_IDS, (Object)ParserOptions.PRESERVE_BNODE_IDS).put(NAMESPACES, (Object)ParserOptions.NAMESPACES).build();

    private DatabaseOptions() {
        throw new AssertionError();
    }

    public static Metadata defaults(String theName) {
        return DiskOptions.defaults().set(NAME, theName);
    }

    public static Options getParserOptions(Metadata theMetadata) {
        Options aOptions = Options.create();
        DatabaseOptions.copyParserOptions(theMetadata, aOptions);
        return aOptions;
    }

    public static void copyParserOptions(Metadata theMetadata, Options theOptions) {
        for (Map.Entry<MetaProperty<?>, Option<?>> aEntry : PARSER_OPTIONS.entrySet()) {
            MetaProperty<?> aProp = aEntry.getKey();
            Option<?> aOption = aEntry.getValue();
            DatabaseOptions.copyOption(theMetadata, aProp, theOptions, aOption);
        }
        LanguageNormalization aLanguageNormalization = theMetadata.get(LANGUAGE_NORMALIZATION);
        theOptions.set(ParserOptions.LANG_HANDLER, (Object)aLanguageNormalization.handler());
        theMetadata.forEach(theMetaProperty -> {
            if (theMetaProperty.getName().startsWith(PARSER_OPTION_PREFIX)) {
                Object aValue = theMetadata.get(theMetaProperty);
                Option aOption = Option.create((String)theMetaProperty.getName(), (Object)"");
                if (!theOptions.contains(aOption)) {
                    theOptions.set(aOption, (Object)aValue.toString());
                }
            }
        });
    }

    public static <T> void copyOption(Metadata theMetadata, MetaProperty<T> theProp, Options theOptions, Option<T> theOption) {
        if (!theOptions.contains(theOption)) {
            theOptions.set(theOption, theMetadata.get(theProp));
        }
    }

    public static Options getParserConfig(Metadata theMetadata) {
        return ParserConfigs.create((Options)DatabaseOptions.getParserOptions(theMetadata));
    }

    public static enum LanguageNormalization {
        DEFAULT(LowercaseBCP47LanguageHandler.INSTANCE),
        RFC3066((LanguageHandler)new RFC3066LanguageHandler()),
        BCP47((LanguageHandler)new BCP47LanguageHandler());

        private final LanguageHandler handler;

        private LanguageNormalization(LanguageHandler theHandler) {
            this.handler = theHandler;
        }

        public LanguageHandler handler() {
            return this.handler;
        }
    }

    public static enum TransactionIsolation {
        SNAPSHOT,
        SERIALIZABLE;

    }

    public static enum InlineStoredQuery {
        NEVER,
        OPTIMIZER,
        ALWAYS;

    }
}

