/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.server.ProcessDuplicateIDException;
import com.complexible.stardog.server.ProcessNotFoundException;
import com.complexible.stardog.server.ShutdownException;
import com.stardog.ErrorCode;
import com.stardog.SkeletonErrorParser;
import java.util.concurrent.CancellationException;

public class StardogErrorParser
extends SkeletonErrorParser {
    public static final String GENERIC_PREFIX = "00";

    protected Throwable toThrowable(ErrorCode thePec, String theErrorMsg) {
        return ((GenericErrorCode)thePec).toThrowable(theErrorMsg);
    }

    protected boolean canBeParsed(String theErrorCode) {
        return theErrorCode.startsWith(GENERIC_PREFIX);
    }

    protected ErrorCode[] getErrorCodes() {
        return GenericErrorCode.values();
    }

    protected boolean codeMatches(ErrorCode thePec, Throwable theT) {
        return ((GenericErrorCode)thePec).applies(theT);
    }

    public static enum GenericErrorCode implements ErrorCode
    {
        SHUTTING_DOWN("0SD", ErrorCode.Severity.FATAL){

            @Override
            boolean applies(Throwable t) {
                return t instanceof ShutdownException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new ShutdownException(errorMsg);
            }
        }
        ,
        ILLEGAL_ARGUMENT("0IA", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof IllegalArgumentException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new IllegalArgumentException(errorMsg);
            }
        }
        ,
        UNSUPPORTED_OPERATION("UOE", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof UnsupportedOperationException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new UnsupportedOperationException(errorMsg);
            }
        }
        ,
        PROCESS_EXISTS("PE", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof ProcessDuplicateIDException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new ProcessDuplicateIDException(errorMsg);
            }
        }
        ,
        PROCESS_NOT_FOUND("PNE", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof ProcessNotFoundException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new ProcessNotFoundException(errorMsg);
            }
        }
        ,
        PROCESS_CANCELLED("PCE", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof CancellationException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new CancellationException(errorMsg);
            }
        }
        ,
        UNKNOWN("001", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return false;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new StardogException(errorMsg);
            }
        };

        private final String formattedCode;
        private final ErrorCode.Severity severity;

        private GenericErrorCode(String theFTE, ErrorCode.Severity severity) {
            this.formattedCode = StardogErrorParser.GENERIC_PREFIX + theFTE + severity.getEncodedString();
            this.severity = severity;
        }

        public String getFormattedString() {
            return this.formattedCode;
        }

        public ErrorCode.Severity getSeverity() {
            return this.severity;
        }

        public String getCategory() {
            return StardogErrorParser.GENERIC_PREFIX;
        }

        abstract boolean applies(Throwable var1);

        abstract Throwable toThrowable(String var1);
    }
}

