/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog;

import java.util.Optional;

public enum StardogAgent {
    STUDIO("Studio"),
    EXPLORER("Explorer"),
    DESIGNER("Designer"),
    KNOWLEDGE_CATALOG("Knowledge Catalog"),
    PORTAL("Portal"),
    VOICEBOX("Voicebox"),
    STARDOG_INTERNAL("Stardog Internal");

    private final String mHeaderValue;

    private StardogAgent(String theHeaderValue) {
        this.mHeaderValue = theHeaderValue;
    }

    public String getHeaderValue() {
        return this.mHeaderValue;
    }

    public static Optional<StardogAgent> fromHeaderValue(String theHeaderValue) {
        if (theHeaderValue == null || theHeaderValue.isEmpty()) {
            return Optional.empty();
        }
        for (StardogAgent agent : StardogAgent.values()) {
            if (!agent.mHeaderValue.equalsIgnoreCase(theHeaderValue)) continue;
            return Optional.of(agent);
        }
        return Optional.empty();
    }

    public static boolean isValidAgent(String theHeaderValue) {
        return StardogAgent.fromHeaderValue(theHeaderValue).isPresent();
    }
}

