/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog;

import com.complexible.stardog.QueryMetadataKey;
import com.complexible.stardog.process.ProcessInfo;
import com.complexible.stardog.process.ProcessType;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public interface QueryInfo
extends ProcessInfo {
    public static final String DEFAULT_QUERY_TYPE = "SPARQL";

    public Status getStatus();

    public String getQuery();

    public boolean isReasoningEnabled();

    public String getReasoningSchema();

    public long getPreExecutionTime();

    public long getEndTime();

    public long getTimeout();

    default public boolean isStarted() {
        Status aStatus = this.getStatus();
        return aStatus == null ? this.getStartTime() != -1L : aStatus != Status.NOT_STARTED;
    }

    @Deprecated
    default public String getDB() {
        return this.getDBName();
    }

    @Override
    default public ProcessType getType() {
        return ProcessType.Query;
    }

    @Override
    default public boolean isEnded() {
        Status aStatus = this.getStatus();
        return aStatus == null ? this.getEndTime() != -1L : aStatus == Status.FINISHED;
    }

    @Override
    default public boolean isRunning() {
        return this.isStarted() && !this.isEnded();
    }

    public String getQueryType();

    public Optional<String> getRenderedPlan();

    default public Optional<String> getRenderedPlan(boolean verbose) {
        return this.getRenderedPlan();
    }

    default public Map<QueryMetadataKey, String> getMetadata() {
        return Collections.emptyMap();
    }

    public static enum Status {
        NOT_STARTED{

            public String toString() {
                return "Not started";
            }

            @Override
            public ProcessInfo.Status toProcessStatus() {
                return ProcessInfo.Status.NOT_STARTED;
            }
        }
        ,
        PRE_EXEC{

            public String toString() {
                return "Pre-execution";
            }

            @Override
            public ProcessInfo.Status toProcessStatus() {
                return ProcessInfo.Status.RUNNING;
            }
        }
        ,
        RUNNING{

            public String toString() {
                return "Running";
            }

            @Override
            public ProcessInfo.Status toProcessStatus() {
                return ProcessInfo.Status.RUNNING;
            }
        }
        ,
        TIMEDOUT{

            public String toString() {
                return "Terminating";
            }

            @Override
            public ProcessInfo.Status toProcessStatus() {
                return ProcessInfo.Status.KILLED;
            }
        }
        ,
        KILLED{

            public String toString() {
                return "Terminating";
            }

            @Override
            public ProcessInfo.Status toProcessStatus() {
                return ProcessInfo.Status.KILLED;
            }
        }
        ,
        FINISHED{

            public String toString() {
                return "Done";
            }

            @Override
            public ProcessInfo.Status toProcessStatus() {
                return ProcessInfo.Status.FINISHED;
            }
        };


        public abstract ProcessInfo.Status toProcessStatus();
    }
}

