/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog;

import com.complexible.mvcc.api.WriteConflictException;
import com.complexible.stardog.plan.eval.TranslateException;
import com.complexible.stardog.plan.eval.operator.OperatorException;
import com.complexible.stardog.plan.parser.QueryParseException;
import com.stardog.ErrorCode;
import com.stardog.SkeletonErrorParser;

public class IndexErrorParser
extends SkeletonErrorParser {
    private static final String QUERY_EXECUTION_PREFIX = "QE";

    protected Throwable toThrowable(ErrorCode thePec, String theErrorMsg) {
        return ((IndexErrorCode)thePec).toThrowable(theErrorMsg);
    }

    protected boolean canBeParsed(String theErrorCode) {
        return theErrorCode.startsWith(QUERY_EXECUTION_PREFIX);
    }

    protected ErrorCode[] getErrorCodes() {
        return IndexErrorCode.values();
    }

    protected boolean codeMatches(ErrorCode thePec, Throwable theT) {
        return ((IndexErrorCode)thePec).applies(theT);
    }

    public static enum IndexErrorCode implements ErrorCode
    {
        QUERY_PARSE_EXCEPTION("QE", "QPE", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof QueryParseException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return null;
            }
        }
        ,
        OPERATOR_EXCEPTION("QE", "QOE", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof OperatorException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new OperatorException(errorMsg);
            }
        }
        ,
        CANNOT_TRANSLATE_PLAN("QE", "CTP", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof TranslateException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new TranslateException(errorMsg);
            }
        }
        ,
        WRITE_CONFLICT_EXCEPTION("QE", "WCE", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof WriteConflictException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new WriteConflictException(errorMsg);
            }
        };

        private final String formattedCode;
        private final ErrorCode.Severity severity;

        private IndexErrorCode(String typePrefix, String code, ErrorCode.Severity seveerity) {
            this.formattedCode = typePrefix + code + seveerity.getEncodedString();
            this.severity = seveerity;
        }

        public String getFormattedString() {
            return this.formattedCode;
        }

        public ErrorCode.Severity getSeverity() {
            return this.severity;
        }

        public String getCategory() {
            return IndexErrorParser.QUERY_EXECUTION_PREFIX;
        }

        abstract boolean applies(Throwable var1);

        abstract Throwable toThrowable(String var1);
    }
}

