/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog;

import com.complexible.stardog.Schemas;
import com.complexible.stardog.StoredQuery;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.stardog.stark.IRI;
import com.stardog.stark.Value;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.apache.logging.log4j.util.Strings;

public final class ImmutableStoredQuery
implements Serializable,
StoredQuery {
    private static final long serialVersionUID = -7529237530863955266L;
    private final String id;
    private final String name;
    private final List<String> path;
    private final String description;
    private final String query;
    private final String creator;
    private final String database;
    private final boolean shared;
    private final String schema;
    private final ImmutableSetMultimap<IRI, Value> annotations;
    private final int triggerLimit;
    private final int triggerSchedule;
    private final int triggerTimeout;
    private final StoredQuery.TriggerPayloadType triggerPayloadType;
    private transient boolean mAvailable = true;
    private final transient AtomicReference<StoredQuery.TriggerStatus> mStatus = new AtomicReference();

    private ImmutableStoredQuery(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "Name cannot be null");
        this.path = Objects.requireNonNull(builder.path, "Path cannot be null");
        this.id = builder.id;
        this.description = builder.description;
        this.database = Objects.requireNonNull(builder.database, "Database cannot be null");
        this.creator = Objects.requireNonNull(builder.creator, "Creator cannot be null");
        this.query = Objects.requireNonNull(builder.query, "Query cannot be null");
        this.shared = builder.shared;
        this.schema = builder.schema;
        this.annotations = builder.annotations.build();
        this.triggerLimit = builder.triggerLimit;
        this.triggerSchedule = builder.triggerSchedule;
        this.triggerTimeout = builder.triggerTimeout;
        this.triggerPayloadType = builder.triggerPayloadType;
        if (builder.hasTriggerStatus) {
            this.mStatus.set(new StoredQuery.TriggerStatus(builder.triggerLastRun, builder.triggerNextRun, builder.triggerLastChange, builder.triggerErrorMessage));
        }
        Preconditions.checkArgument((boolean)StoredQuery.isValidName(this.name), (String)"Invalid name for stored query: %s", (Object)this.name);
        Preconditions.checkArgument((!this.isTrigger() || !Objects.equals("*", this.database) ? 1 : 0) != 0, (Object)"A trigger must be defined with a database");
    }

    @Override
    public void close() {
        this.mAvailable = false;
    }

    @Override
    public boolean isAvailable() {
        return this.mAvailable;
    }

    @Override
    @Nullable
    public StoredQuery.TriggerStatus getTriggerStatus() {
        return this.mStatus.get();
    }

    @Override
    public void setTriggerStatus(StoredQuery.TriggerStatus status) {
        this.mStatus.set(status);
    }

    @Override
    public StoredQuery.TriggerPayloadType getTriggerPayloadType() {
        return this.triggerPayloadType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getPath() {
        return this.path;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public boolean isShared() {
        return this.shared;
    }

    @Override
    public boolean isReasoning() {
        return this.schema != null;
    }

    @Override
    public boolean isTrigger() {
        return this.getTriggerSchedule() > 0;
    }

    @Override
    public int getTriggerLimit() {
        return this.triggerLimit;
    }

    @Override
    public int getTriggerSchedule() {
        return this.triggerSchedule;
    }

    @Override
    public int getTriggerTimeout() {
        return this.triggerTimeout;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public ImmutableSetMultimap<IRI, Value> getAnnotations() {
        return this.annotations;
    }

    public static ImmutableStoredQuery withId(StoredQuery theQuery, String theId) {
        if (theQuery instanceof ImmutableStoredQuery) {
            ImmutableStoredQuery immutableQuery = (ImmutableStoredQuery)theQuery;
            return immutableQuery.toBuilder().id(theId).build();
        }
        throw new IllegalArgumentException("Cannot assign id to stored query with an unexpected type: " + String.valueOf(theQuery.getClass()));
    }

    public static ImmutableStoredQuery ensureId(StoredQuery theQuery) {
        if (theQuery instanceof ImmutableStoredQuery) {
            ImmutableStoredQuery immutableQuery = (ImmutableStoredQuery)theQuery;
            if (Strings.isEmpty((CharSequence)immutableQuery.getId())) {
                return immutableQuery.toBuilder().id(UUID.randomUUID().toString()).build();
            }
            return immutableQuery;
        }
        throw new IllegalArgumentException("Cannot assign id to stored query with an unexpected type: " + String.valueOf(theQuery.getClass()));
    }

    public static ImmutableStoredQuery assignRandomId(StoredQuery theQuery) {
        if (theQuery instanceof ImmutableStoredQuery) {
            ImmutableStoredQuery immutableQuery = (ImmutableStoredQuery)theQuery;
            return immutableQuery.toBuilder().id(UUID.randomUUID().toString()).build();
        }
        throw new IllegalArgumentException("Cannot assign id to stored query with an unexpected type: " + String.valueOf(theQuery.getClass()));
    }

    public static ImmutableStoredQuery preserveId(StoredQuery theQuery, UnaryOperator<StoredQuery> theFunction) {
        if (theQuery instanceof ImmutableStoredQuery) {
            ImmutableStoredQuery immutableQuery = (ImmutableStoredQuery)theQuery;
            String id = immutableQuery.getId();
            ImmutableStoredQuery result = (ImmutableStoredQuery)theFunction.apply(immutableQuery);
            return result.toBuilder().id(id).build();
        }
        throw new IllegalArgumentException("Cannot preserve id in stored query with an unexpected type: " + String.valueOf(theQuery.getClass()));
    }

    @Override
    public Builder toBuilder() {
        return ((Builder)((Builder)ImmutableStoredQuery.builder().id(this.id).name(this.name).path((List)this.path)).description(this.description).query(this.query).creator(this.creator).database(this.database).shared(this.shared).schema(this.schema).annotations((Multimap)this.annotations)).triggerLimit(this.triggerLimit).triggerSchedule(this.triggerSchedule).triggerTimeout(this.triggerTimeout).triggerPayloadType(this.triggerPayloadType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableStoredQuery that = (ImmutableStoredQuery)obj;
        if (this.shared != that.shared) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.query.equals(that.query)) {
            return false;
        }
        if (!this.creator.equals(that.creator)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.database, that.database)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        return this.triggerLimit == that.triggerLimit && this.triggerSchedule == that.triggerSchedule;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "StoredQuery{name='" + this.name + "', path='" + String.join((CharSequence)"/", this.path) + "', description='" + this.description + "', query='" + this.query + "', creator='" + this.creator + "', database='" + this.database + "', shared=" + this.shared + ", reasoning=" + (this.schema != null) + ", schema=" + this.schema + ", annotations=" + String.valueOf(this.annotations) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements StoredQuery.Builder {
        private String id = "";
        private String name;
        private String description;
        private String query;
        private String creator;
        private String database = "*";
        private boolean shared = false;
        private String schema = Schemas.NULL;
        private ImmutableSetMultimap.Builder<IRI, Value> annotations = ImmutableSetMultimap.builder();
        private List<String> path = List.of();
        private int triggerLimit = 0;
        private int triggerSchedule = 0;
        private int triggerTimeout = 0;
        private StoredQuery.TriggerPayloadType triggerPayloadType = StoredQuery.TriggerPayloadType.None;
        private boolean hasTriggerStatus = false;
        private long triggerLastRun = 0L;
        private long triggerNextRun = 0L;
        private long triggerLastChange = 0L;
        private String triggerErrorMessage = null;

        public Builder() {
        }

        public Builder(StoredQuery theStoredQuery) {
            this.id = "";
            this.name = theStoredQuery.getName();
            this.path = theStoredQuery.getPath();
            this.description = theStoredQuery.getDescription();
            this.query = theStoredQuery.getQuery();
            this.creator = theStoredQuery.getCreator();
            this.database = theStoredQuery.getDatabase();
            this.shared = theStoredQuery.isShared();
            this.schema = theStoredQuery.getSchema();
            this.annotations.putAll(theStoredQuery.getAnnotations());
            this.triggerLimit = theStoredQuery.getTriggerLimit();
            this.triggerSchedule = theStoredQuery.getTriggerSchedule();
            this.triggerTimeout = theStoredQuery.getTriggerTimeout();
            this.triggerPayloadType = theStoredQuery.getTriggerPayloadType();
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder path(List<String> path) {
            this.path = path;
            return this;
        }

        @Override
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder database(String database) {
            this.database = database;
            return this;
        }

        @Override
        public Builder creator(String creator) {
            this.creator = creator;
            return this;
        }

        @Override
        public Builder query(String query) {
            this.query = query;
            return this;
        }

        @Override
        public Builder shared(boolean shared) {
            this.shared = shared;
            return this;
        }

        @Override
        public Builder reasoning(boolean reasoning) {
            this.schema = reasoning ? (String)MoreObjects.firstNonNull((Object)this.schema, (Object)"default") : Schemas.NULL;
            return this;
        }

        @Override
        public Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder annotation(IRI property, Value value) {
            this.annotations.put((Object)property, (Object)value);
            return this;
        }

        @Override
        public Builder annotations(Multimap<IRI, Value> annotations) {
            if (annotations != null) {
                this.annotations.putAll(annotations);
            }
            return this;
        }

        public Builder clearAnnotations() {
            this.annotations = ImmutableSetMultimap.builder();
            return this;
        }

        @Override
        public Builder trigger(boolean isTrigger) {
            if (isTrigger && this.triggerLimit <= 0) {
                this.triggerLimit = 1000;
            } else if (!isTrigger) {
                this.triggerLimit = 0;
            }
            return this;
        }

        @Override
        public Builder triggerLimit(int triggerLimit) {
            this.triggerLimit = triggerLimit;
            return this;
        }

        @Override
        public Builder triggerSchedule(int triggerFrequency) {
            this.triggerSchedule = triggerFrequency;
            return this;
        }

        @Override
        public Builder triggerTimeout(int triggerTimeout) {
            this.triggerTimeout = triggerTimeout;
            return this;
        }

        @Override
        public Builder triggerPayloadType(StoredQuery.TriggerPayloadType payloadType) {
            this.triggerPayloadType = payloadType;
            return this;
        }

        @Override
        public Builder triggerLastRun(long lastRun) {
            this.hasTriggerStatus = true;
            this.triggerLastRun = lastRun;
            return this;
        }

        public Builder triggerNextRun(long lastRun) {
            this.hasTriggerStatus = true;
            this.triggerNextRun = lastRun;
            return this;
        }

        @Override
        public Builder triggerLastChange(long lastChange) {
            this.hasTriggerStatus = true;
            this.triggerLastChange = lastChange;
            return this;
        }

        @Override
        public Builder triggerErrorMessage(String errorMessage) {
            this.hasTriggerStatus = true;
            this.triggerErrorMessage = errorMessage;
            return this;
        }

        @Override
        public ImmutableStoredQuery build() {
            return new ImmutableStoredQuery(this);
        }
    }
}

