/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog;

import com.complexible.common.rdf.query.parser.sparql.ASTSPARQLRenderer;
import com.complexible.common.rdf.query.parser.sparql.PrefixDeclProcessor;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTFunctionDefinition;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTFunctionDefinitions;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTIRI;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTOperationContainer;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTUnprefixedFunctionName;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTVar;
import com.complexible.common.rdf.query.parser.sparql.ast.Node;
import com.complexible.common.rdf.query.parser.sparql.ast.ParseException;
import com.complexible.common.rdf.query.parser.sparql.ast.SyntaxTreeBuilder;
import com.complexible.common.rdf.query.parser.sparql.ast.SyntaxTreeBuilderDefaultVisitor;
import com.complexible.common.rdf.query.parser.sparql.ast.SyntaxTreeBuilderVisitor;
import com.complexible.common.rdf.query.parser.sparql.ast.TokenMgrError;
import com.complexible.common.rdf.query.parser.sparql.ast.VisitorException;
import com.complexible.stardog.StoredFunction;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class ImmutableStoredFunction
implements StoredFunction {
    private final String name;
    private final List<String> parameters;
    private final String definition;

    private ImmutableStoredFunction(String theName, List<String> theParameters, String theDefinition) {
        this.name = theName;
        this.parameters = ImmutableList.copyOf(theParameters);
        this.definition = theDefinition;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getParameters() {
        return this.parameters;
    }

    @Override
    public String getDefinition() {
        return this.definition;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StoredFunction)) {
            return false;
        }
        StoredFunction that = (StoredFunction)obj;
        return this.name.equals(that.getName()) && this.parameters.equals(that.getParameters()) && this.definition.equals(that.getDefinition());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.definition;
    }

    public static ImmutableStoredFunction create(String definition) {
        List<ImmutableStoredFunction> functions = ImmutableStoredFunction.parse(definition);
        if (functions.size() > 1) {
            throw new IllegalArgumentException("More than one function definition found");
        }
        return functions.get(0);
    }

    public static List<ImmutableStoredFunction> parse(String definitions) {
        ArrayList functions = Lists.newArrayList();
        try {
            ASTFunctionDefinitions aDefinitions = SyntaxTreeBuilder.parseFunctionDefinitions((String)definitions);
            PrefixDeclProcessor.process((ASTOperationContainer)aDefinitions, (Map)ImmutableMap.of((Object)"", (Object)"http://api.stardog.com/"));
            ASTSPARQLRenderer renderer = new ASTSPARQLRenderer();
            for (ASTFunctionDefinition aFunctionDefinition : aDefinitions.jjtGetChildren(ASTFunctionDefinition.class)) {
                Node aFunctionCall = aFunctionDefinition.jjtGetChild(0);
                String name = ImmutableStoredFunction.functionName(aFunctionCall.jjtGetChild(0));
                ImmutableList.Builder aBuilder = ImmutableList.builder();
                for (int i = 1; i < aFunctionCall.jjtGetNumChildren(); ++i) {
                    aBuilder.add((Object)((ASTVar)aFunctionCall.jjtGetChild(i)).getName());
                }
                ImmutableList parameters = aBuilder.build();
                String definition = renderer.render((Node)aFunctionDefinition);
                functions.add(new ImmutableStoredFunction(name, (List<String>)parameters, definition));
            }
            return functions;
        }
        catch (ParseException | TokenMgrError e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static String functionName(Node theNode) {
        return theNode.jjtAccept((SyntaxTreeBuilderVisitor)new SyntaxTreeBuilderDefaultVisitor(){

            public Object visit(ASTUnprefixedFunctionName node, Object data) throws VisitorException {
                return node.getFunctionName();
            }

            public Object visit(ASTIRI node, Object data) throws VisitorException {
                return node.getValue();
            }
        }, null).toString();
    }
}

