/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog;

import com.complexible.stardog.StardogErrorParser;
import com.complexible.stardog.StardogException;
import com.google.common.base.Throwables;
import com.stardog.ErrorCode;
import com.stardog.ErrorParser;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArraySet;

public class ErrorCodes {
    private static final CopyOnWriteArraySet<ErrorParser> PARSERS = new CopyOnWriteArraySet();

    private ErrorCodes() {
    }

    public static void registerParser(ErrorParser theParser) {
        PARSERS.add(theParser);
    }

    public static ErrorCode parseCode(Throwable t) {
        t = Throwables.getRootCause((Throwable)t);
        for (ErrorParser ep : PARSERS) {
            Optional code = ep.parse(t);
            if (!code.isPresent()) continue;
            return (ErrorCode)code.get();
        }
        return StardogErrorParser.GenericErrorCode.UNKNOWN;
    }

    public static ErrorCode parseCode(String formattedString) {
        for (ErrorParser ep : PARSERS) {
            Optional code = ep.parseCode(formattedString);
            if (!code.isPresent()) continue;
            return (ErrorCode)code.get();
        }
        return StardogErrorParser.GenericErrorCode.UNKNOWN;
    }

    public static Throwable parseToThrowable(ErrorCode ec, String msg) {
        for (ErrorParser ep : PARSERS) {
            Optional t = ep.errorFor(ec, msg);
            if (!t.isPresent()) continue;
            return (Throwable)t.get();
        }
        return new StardogException(msg);
    }
}

