/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog;

import com.complexible.common.base.Progress;
import com.complexible.stardog.AbstractQueryInfo;
import com.complexible.stardog.QueryInfo;
import com.complexible.stardog.QueryMetadataKey;
import com.complexible.stardog.Schemas;
import com.complexible.stardog.process.ProcessInfo;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class DefaultQueryInfo
extends AbstractQueryInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String mKernelID;
    private final String mID;
    private final String mQueryType;
    private final String mQuery;
    private final String mDB;
    private final String mUser;
    private final String mReasoningSchema;
    private final long mStartTime;
    protected long mEndTime;
    protected long mPreExecutionTime;
    protected long mTimeout;
    protected QueryInfo.Status mStatus;
    protected transient Map<QueryMetadataKey, String> mMetadata;

    public DefaultQueryInfo(String theID, String theQuery, String theDB, String theUser, String theReasoningSchema, long theStartTime, long theEndTime, long thePreExecutionTime, long theTimeout, QueryInfo.Status theStatus) {
        this("", theID, "SPARQL", theQuery, theDB, theUser, theReasoningSchema, theStartTime, theEndTime, thePreExecutionTime, theTimeout, theStatus);
    }

    public DefaultQueryInfo(String theKernelID, String theID, String theQuery, String theDB, String theUser, String theReasoningSchema, long theStartTime, long theEndTime, long thePreExecutionTime, long theTimeout, String theStatus) {
        this(theKernelID, theID, "SPARQL", theQuery, theDB, theUser, theReasoningSchema, theStartTime, theEndTime, thePreExecutionTime, theTimeout, QueryInfo.Status.valueOf(theStatus));
    }

    public DefaultQueryInfo(String theKernelID, String theID, String theQueryType, String theQuery, String theDB, String theUser, String theReasoningSchema, long theStartTime, long theEndTime, long thePreExecutionTime, long theTimeout, QueryInfo.Status theStatus) {
        this.mKernelID = theKernelID;
        this.mID = theID;
        this.mQueryType = theQueryType;
        this.mQuery = theQuery;
        this.mDB = theDB;
        this.mUser = theUser;
        this.mReasoningSchema = theReasoningSchema;
        this.mStartTime = theStartTime;
        this.mEndTime = theEndTime;
        this.mPreExecutionTime = thePreExecutionTime;
        this.mTimeout = theTimeout;
        this.mStatus = (QueryInfo.Status)((Object)Preconditions.checkNotNull((Object)((Object)theStatus), (Object)"Status cannot be null"));
        Preconditions.checkArgument((this.isStarted() || !this.isEnded() ? 1 : 0) != 0, (Object)"Cannot have a query that did not start but ended");
    }

    @Override
    public String getKernelID() {
        return this.mKernelID;
    }

    @Override
    public String getID() {
        return this.mID;
    }

    @Override
    public String getQuery() {
        return this.mQuery;
    }

    @Override
    public String getDBName() {
        return this.mDB;
    }

    @Override
    public String getUser() {
        return this.mUser;
    }

    @Override
    public boolean isReasoningEnabled() {
        return this.mReasoningSchema != Schemas.NULL;
    }

    @Override
    public String getReasoningSchema() {
        return this.mReasoningSchema;
    }

    @Override
    public long getStartTime() {
        return this.mStartTime;
    }

    @Override
    public long getPreExecutionTime() {
        return this.mPreExecutionTime;
    }

    @Override
    public long getEndTime() {
        return this.mEndTime;
    }

    @Override
    public long getTimeout() {
        return this.mTimeout;
    }

    @Override
    public QueryInfo.Status getStatus() {
        return this.mStatus;
    }

    @Override
    public ProcessInfo.Status getProcessStatus() {
        if (this.mStatus == null) {
            return null;
        }
        return this.mStatus.toProcessStatus();
    }

    @Override
    public String getQueryType() {
        return this.mQueryType;
    }

    @Override
    public Optional<String> getRenderedPlan() {
        return Optional.empty();
    }

    @Override
    public Optional<Progress> progress() {
        return Optional.empty();
    }

    @Override
    public Map<QueryMetadataKey, String> getMetadata() {
        return this.mMetadata != null ? this.mMetadata : Collections.emptyMap();
    }
}

