/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog;

public class CommitResult {
    public static final CommitResult EMPTY = new CommitResult(0L, 0L);
    private final long mAdded;
    private final long mRemoved;

    public CommitResult(long theAdded, long theRemoved) {
        this.mAdded = theAdded;
        this.mRemoved = theRemoved;
    }

    public static CommitResult merge(CommitResult theFirst, CommitResult theSecond) {
        return new CommitResult(theFirst.getAdded() + theSecond.getAdded(), theFirst.getRemoved() + theSecond.getRemoved());
    }

    public long getAdded() {
        return this.mAdded;
    }

    public long getRemoved() {
        return this.mRemoved;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CommitResult) {
            CommitResult that = (CommitResult)obj;
            return this.mAdded == that.mAdded && this.mRemoved == that.mRemoved;
        }
        return false;
    }

    public int hashCode() {
        int aResult = (int)(this.mAdded ^ this.mAdded >>> 32);
        aResult = 31 * aResult + (int)(this.mRemoved ^ this.mRemoved >>> 32);
        return aResult;
    }

    public String toString() {
        Object aResult = "";
        if (this.mAdded > 0L) {
            aResult = (String)aResult + this.format(this.mAdded) + "added";
            if (this.mRemoved > 0L) {
                aResult = (String)aResult + ", ";
            }
        }
        if (this.mRemoved > 0L) {
            aResult = (String)aResult + this.format(this.mRemoved) + "removed";
        }
        return !((String)aResult).isEmpty() ? aResult : this.format(0L) + "updated";
    }

    private String format(long theValue) {
        return String.format("%,d triple%s ", theValue, theValue == 1L ? "" : "s");
    }
}

