/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.mvcc.impl.oracle;

import com.complexible.mvcc.api.IsolationLevel;
import com.complexible.mvcc.api.Txn;

public class TxnImpl
implements Txn {
    private final long beginTimestamp;
    private final long commitTimestamp;
    private final IsolationLevel mIsolationLevel;
    private final Txn.State currentState;
    private volatile boolean isWritable;

    public TxnImpl(long theBeginTimestamp, long theCommitTimestamp, IsolationLevel theIsolationLevel, Txn.State theCurrentState, boolean theIsWritable) {
        this.beginTimestamp = theBeginTimestamp;
        this.commitTimestamp = theCommitTimestamp;
        this.mIsolationLevel = theIsolationLevel;
        this.currentState = theCurrentState;
        this.isWritable = theIsWritable;
    }

    public TxnImpl(long theBeginTimestamp, long commitTimestamp, Txn.State theCurrentState, boolean theIsWritable) {
        this(theBeginTimestamp, commitTimestamp, IsolationLevel.SNAPSHOT_ISOLATION, theCurrentState, theIsWritable);
    }

    public TxnImpl(long theBeginTimestamp, IsolationLevel theIsolationLevel, Txn.State theCurrentState, boolean theIsWritable) {
        this(theBeginTimestamp, -1L, theIsolationLevel, theCurrentState, theIsWritable);
    }

    @Override
    public long beginTimestamp() {
        return this.beginTimestamp;
    }

    @Override
    public long commitTimestamp() {
        return this.commitTimestamp;
    }

    @Override
    public Txn.State currentState() {
        return this.currentState;
    }

    @Override
    public IsolationLevel isolationLevel() {
        return this.mIsolationLevel;
    }

    @Override
    public boolean canSee(Txn other) {
        if (this.equals(other)) {
            return true;
        }
        if (other.isRolledback()) {
            return false;
        }
        switch (this.mIsolationLevel) {
            case READ_UNCOMMITTED: {
                return true;
            }
            case READ_COMMITTED: {
                return other.isCommitted();
            }
        }
        return other.isCommitted() && other.commitTimestamp() <= this.beginTimestamp;
    }

    @Override
    public boolean conflicts(Txn other) {
        if (this.equals(other)) {
            return false;
        }
        if (other.isRolledback()) {
            return false;
        }
        if (other.isCommitted()) {
            return other.commitTimestamp() > this.beginTimestamp;
        }
        return true;
    }

    @Override
    public boolean isWritable() {
        return this.isWritable;
    }

    void upgradeToWritable() {
        this.isWritable = true;
    }

    public boolean equals(Object atheO) {
        if (this == atheO) {
            return true;
        }
        if (!(atheO instanceof Txn)) {
            return false;
        }
        Txn aaBaseTxn = (Txn)atheO;
        return this.beginTimestamp == aaBaseTxn.beginTimestamp();
    }

    public int hashCode() {
        return (int)(this.beginTimestamp ^ this.beginTimestamp >>> 32);
    }

    public String toString() {
        return (this.isWritable ? "WritableTxn[" : "ReadOnlyTxn[") + this.beginTimestamp + "," + this.commitTimestamp + "): " + String.valueOf((Object)this.mIsolationLevel);
    }
}

