/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.mvcc.impl.oracle;

import com.complexible.common.base.SystemUtil;
import com.complexible.mvcc.api.IsolationLevel;
import com.complexible.mvcc.api.MutableTransactionStore;
import com.complexible.mvcc.api.Txn;
import com.complexible.mvcc.api.oracle.TimestampGenerator;
import com.complexible.mvcc.api.oracle.TransactionOracle;
import com.complexible.mvcc.api.oracle.TransactionStateListener;
import com.complexible.mvcc.impl.oracle.TxnImpl;
import com.complexible.mvcc.impl.oracle.TxnStateListenerSet;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;

public class SimpleOracle
implements TransactionOracle {
    private final TimestampGenerator generator;
    private final MutableTransactionStore txnStore;
    private final TxnStateListenerSet asyncListenerSet;
    private final TxnStateListenerSet syncListenerSet;
    private final NavigableMap<Long, Txn> activeTxns = new ConcurrentSkipListMap<Long, Txn>();
    private final Map<Long, String> txnStacks = new ConcurrentSkipListMap<Long, String>();
    private static final boolean storeTxnTraces = SystemUtil.getPropertyAsBoolean((String)"stardog.resources.txntrace", (boolean)false);

    @Inject
    public SimpleOracle(TimestampGenerator theGenerator, MutableTransactionStore theTxnStore) {
        this(theGenerator, theTxnStore, true);
    }

    public SimpleOracle(TimestampGenerator theGenerator, MutableTransactionStore theTxnStore, boolean startThreads) {
        this.txnStore = theTxnStore;
        this.generator = theGenerator;
        this.asyncListenerSet = new TxnStateListenerSet(this, startThreads);
        this.syncListenerSet = startThreads ? new TxnStateListenerSet(this, false) : this.asyncListenerSet;
    }

    public void dispose() {
        this.asyncListenerSet.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Txn beginTransaction(boolean writable, IsolationLevel isolationLevel) throws IOException {
        TxnImpl t;
        long nextTs;
        SimpleOracle simpleOracle = this;
        synchronized (simpleOracle) {
            nextTs = this.generator.nextTimestamp();
            this.txnStore.recordNewTxn(nextTs, writable);
            t = new TxnImpl(nextTs, isolationLevel, Txn.State.ACTIVE, writable);
            this.activeTxns.put(nextTs, t);
        }
        if (storeTxnTraces) {
            this.txnStacks.put(nextTs, SimpleOracle.trace());
        }
        return t;
    }

    @Override
    public Txn upgradeToWritable(Txn theTxn) {
        assert (theTxn.currentState() == Txn.State.ACTIVE) : "Programmer error: cannot upgrade a committed transaction!";
        try {
            this.txnStore.recordNewTxn(theTxn.beginTimestamp(), true);
        }
        catch (IOException theE) {
            throw new RuntimeException(theE);
        }
        Txn oldTxn = (Txn)this.activeTxns.get(theTxn.beginTimestamp());
        ((TxnImpl)oldTxn).upgradeToWritable();
        this.asyncListenerSet.onUpgrade(theTxn.beginTimestamp());
        this.syncListenerSet.onUpgrade(theTxn.beginTimestamp());
        return oldTxn;
    }

    @Override
    public long commit(Txn theTxn) throws IOException {
        long commitTs = -1L;
        if (theTxn.isWritable()) {
            commitTs = this.generator.nextTimestamp();
        }
        long aCommitTs = commitTs;
        this.txnStore.commit(theTxn, aCommitTs);
        this.activeTxns.remove(theTxn.beginTimestamp());
        if (storeTxnTraces) {
            this.txnStacks.remove(theTxn.beginTimestamp());
        }
        this.asyncListenerSet.onCommit(theTxn.beginTimestamp());
        this.syncListenerSet.onCommit(theTxn.beginTimestamp());
        return commitTs;
    }

    @Override
    public void rollback(Txn theTxn) throws IOException {
        Preconditions.checkNotNull((Object)theTxn);
        this.txnStore.rollback(theTxn);
        this.activeTxns.remove(theTxn.beginTimestamp());
        if (storeTxnTraces) {
            this.txnStacks.remove(theTxn.beginTimestamp());
        }
        this.asyncListenerSet.onAbort(theTxn.beginTimestamp());
        this.syncListenerSet.onAbort(theTxn.beginTimestamp());
    }

    @Override
    public long minimumActiveTransaction() {
        Map.Entry<Long, Txn> aLongTxnEntry = this.activeTxns.firstEntry();
        if (aLongTxnEntry != null) {
            return aLongTxnEntry.getValue().beginTimestamp();
        }
        return MIN_TXN.beginTimestamp();
    }

    @Override
    public boolean isActive(Txn theTxn) {
        assert (theTxn != null) : "Cannot check activity for null transactions!";
        return this.activeTxns.containsKey(theTxn.beginTimestamp());
    }

    @Override
    public Txn getTransaction(long txnId) throws IOException {
        Txn txn = (Txn)this.activeTxns.get(txnId);
        if (txn != null) {
            return txn;
        }
        return this.txnStore.getTransaction(txnId);
    }

    @Override
    public Optional<Txn> getIfPresent(long txnId) throws IOException {
        Txn txn = (Txn)this.activeTxns.get(txnId);
        if (txn == null) {
            return this.txnStore.getIfPresent(txnId);
        }
        return Optional.of(txn);
    }

    @Override
    public void registerStateListener(TransactionStateListener stateListener, boolean sync) throws IOException {
        if (stateListener == null) {
            return;
        }
        Txn latestTxnInfo = stateListener.getAssociatedTransaction();
        if (latestTxnInfo.isActive() && !this.activeTxns.containsKey(latestTxnInfo.beginTimestamp())) {
            latestTxnInfo = !latestTxnInfo.isWritable() ? new TxnImpl(latestTxnInfo.beginTimestamp(), latestTxnInfo.beginTimestamp() + 1L, latestTxnInfo.isolationLevel(), Txn.State.COMMITTED, true) : this.getTransaction(latestTxnInfo.beginTimestamp());
        }
        if (!latestTxnInfo.isActive()) {
            if (latestTxnInfo.isCommitted()) {
                stateListener.onCommit();
            } else if (latestTxnInfo.isRolledback()) {
                stateListener.onRollback();
            }
        } else if (!sync) {
            this.asyncListenerSet.attachListener(stateListener);
        } else {
            this.syncListenerSet.attachListener(stateListener);
        }
    }

    @Override
    public void unregisterStateListener(TransactionStateListener listener) {
        this.asyncListenerSet.detachListener(listener);
        this.syncListenerSet.detachListener(listener);
    }

    @Override
    public Collection<Txn> getActiveTxn() {
        return this.activeTxns.values();
    }

    static String trace() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
    }

    @Override
    public String showActive() {
        return this.txnStacks.entrySet().stream().map(e -> "ts " + String.valueOf(e.getKey()) + ":\n" + (String)e.getValue()).collect(Collectors.joining("\n\n"));
    }
}

