/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.mvcc.impl.oracle;

import com.complexible.mvcc.api.oracle.TimestampGenerator;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public abstract class BlockTimestampGenerator
implements TimestampGenerator {
    private final long blockSize;
    private final AtomicLong tsGen;
    private final AtomicLong lastBlockElement;

    public BlockTimestampGenerator(long theBlockSize, long theInitialValue) {
        this.blockSize = theBlockSize;
        this.tsGen = new AtomicLong(theInitialValue);
        this.lastBlockElement = new AtomicLong(0L);
    }

    @Override
    public long nextTimestamp() throws IOException {
        long blockStart;
        long n;
        while ((n = this.tsGen.getAndIncrement()) - (blockStart = this.lastBlockElement.get()) >= this.blockSize) {
            this.allocateNewBlock(blockStart);
        }
        return n;
    }

    @Override
    public long lastGeneratedTimestamp() {
        return Math.max(this.tsGen.get() - 1L, 0L);
    }

    @Override
    public synchronized void updateGeneratedTimestamp(long ts) throws IOException {
        long n = this.tsGen.get();
        if (ts > this.tsGen.get()) {
            long div = (ts + this.blockSize - 1L) / this.blockSize;
            long newTs = this.blockSize * div;
            assert (newTs > this.tsGen.get());
            this.allocateBlock(newTs, this.blockSize);
            this.initialize(newTs);
        }
    }

    protected abstract void allocateBlock(long var1, long var3) throws IOException;

    protected void initialize(long initialBlockStart) throws IOException {
        this.lastBlockElement.set(initialBlockStart);
        this.tsGen.set(initialBlockStart);
    }

    private synchronized void allocateNewBlock(long expectedBlockStart) throws IOException {
        long blockStart = this.lastBlockElement.get();
        if (blockStart != expectedBlockStart) {
            return;
        }
        this.allocateBlock(blockStart + this.blockSize, this.blockSize);
        this.lastBlockElement.set(blockStart + this.blockSize);
    }
}

