/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.nquads;

import com.stardog.stark.Values;
import com.stardog.stark.io.IOParserContext;
import com.stardog.stark.io.InvalidRDF;
import com.stardog.stark.io.ParserOptions;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.ntriples.NTParser;
import com.stardog.stark.io.ntriples.NTriplesUtil;
import java.io.IOException;
import javax.annotation.Nonnull;

public final class NQuadsParser
extends NTParser {
    @Nonnull
    public RDFFormat format() {
        return RDFFormats.NQUADS;
    }

    public void parse(@Nonnull IOParserContext theContext) throws IOException {
        theContext.start();
        int c = theContext.readCodePoint();
        c = this.skipWhitespace(theContext, c);
        while (c != -1) {
            c = c == 35 ? this.skipLine(c, theContext) : (c == 13 || c == 10 ? this.skipLine(c, theContext) : this.parseQuad(theContext, c));
            c = this.skipWhitespace(theContext, c);
        }
        theContext.end();
    }

    private int parseQuad(@Nonnull IOParserContext theContext, int theChar) throws IOException {
        int c = theChar;
        boolean ignoredAnError = false;
        try {
            c = this.parseSubject(theContext, c);
            c = this.skipWhitespace(theContext, c);
            c = this.parsePredicate(theContext, c);
            c = this.skipWhitespace(theContext, c);
            c = this.parseObject(theContext, c);
            c = this.skipWhitespace(theContext, c);
            if (c != 46) {
                c = this.parseContext(theContext, c);
                c = this.skipWhitespace(theContext, c);
            }
            if (c == -1) {
                throw theContext.error("Unexpected end of file");
            }
            if (c != 46) {
                throw theContext.error("Expected '.', found: " + new String(Character.toChars(c)));
            }
            c = this.assertLineTerminates(theContext);
        }
        catch (InvalidRDF e) {
            if (!theContext.is(ParserOptions.FAIL_ON_INVALID_LINES)) {
                ignoredAnError = true;
            }
            throw e;
        }
        c = this.skipLine(c, theContext);
        if (!ignoredAnError) {
            theContext.reportStatement();
        }
        theContext.resetStatement();
        return c;
    }

    protected int parseContext(@Nonnull IOParserContext theContext, int theChar) throws IOException {
        StringBuilder sb = new StringBuilder(100);
        if (theChar == 60) {
            theChar = this.parseUriRef(theContext, theChar, sb);
            try {
                theContext.mContext = Values.iri((String)NTriplesUtil.unescapeString((String)sb.toString()));
            }
            catch (IllegalArgumentException theE) {
                throw theContext.error(theE.getMessage());
            }
        } else if (theChar == 95) {
            theChar = this.parseNodeID(theContext, theChar, sb);
            theContext.mContext = theContext.createBNode(sb.toString());
        } else {
            if (theChar == -1) {
                throw theContext.error("Unexpected end of file");
            }
            throw theContext.error("Expected '<' or '_', found: " + new String(Character.toChars(theChar)));
        }
        return theChar;
    }
}

