/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.util;

import com.complexible.memory.file.FileReader;
import com.complexible.memory.file.FileWriter;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.util.Utilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;

public final class SpillingUtil {
    public static void openDiskReader(FileReader<FileInputStream> theDefaultFileReader, MemoryBlockChain theDataMemoryBlockChain) {
        if (theDataMemoryBlockChain.getSpilledFile() != null) {
            try {
                theDefaultFileReader.setInput(theDataMemoryBlockChain.getSpilledFile());
            }
            catch (FileNotFoundException theE) {
                throw Utilities.rethrow(theE);
            }
        }
    }

    public static void openDiskWriter(File baseDir, FileWriter<FileOutputStream> theDefaultFileWriter, MemoryBlockChain theDataMemoryBlockChain) {
        File aSpillingFile = SpillingUtil.ensureFile(baseDir, theDataMemoryBlockChain.getSpilledFile());
        try {
            theDefaultFileWriter.setOutput(new FileOutputStream(aSpillingFile, true));
        }
        catch (FileNotFoundException theE) {
            throw Utilities.rethrow(theE);
        }
        theDataMemoryBlockChain.setSpilledFile(aSpillingFile);
    }

    public static File ensureFile(File theBaseDir, File theSpilledFile) {
        try {
            if (theSpilledFile == null) {
                return File.createTempFile("tmp", "spilling_" + Thread.currentThread().getId(), theBaseDir);
            }
            return theSpilledFile;
        }
        catch (IOException e) {
            throw Utilities.rethrow(e);
        }
    }

    public static File openDiskWriter(FileWriter<FileOutputStream> theDefaultFileWriter, File theBaseDir) {
        File aFile = SpillingUtil.ensureFile(theBaseDir);
        try {
            theDefaultFileWriter.setOutput(new FileOutputStream(aFile));
        }
        catch (FileNotFoundException theE) {
            throw Utilities.rethrow(theE);
        }
        return aFile;
    }

    public static File ensureFile(File theBaseDir) {
        return SpillingUtil.ensureFile(theBaseDir, null);
    }

    public static void deleteFile(File theFile) {
        if (theFile != null) {
            try {
                Files.deleteIfExists(theFile.toPath());
            }
            catch (IOException theE) {
                throw Utilities.rethrow(theE);
            }
        }
    }

    public static OperationTracker resolveTracker(OperationTracker theTracker) {
        return theTracker == null ? OperationTracker.DEFAULT : theTracker;
    }
}

