/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.util;

import com.complexible.memory.structure.impl.tape.OutOfMemoryException;
import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MMBits {
    private static final Logger LOGGER = LoggerFactory.getLogger(MMBits.class);
    private static final boolean DEBUG = System.getProperty("stardog.resources.track", "false").equalsIgnoreCase("true");
    public static final Deque<Exception> ALLOCATIONS = DEBUG ? new ArrayDeque() : null;
    private static final IBits BITS = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7) ? new BitsJDK7OrLater() : new IBits(){

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public void reserveMemory(long theSize, long theCapacity) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void unreserveMemory(long theSize, long theCapacity) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int pageSize() {
            throw new UnsupportedOperationException();
        }
    };

    public static void reserveMemory(long theSize) {
        if (BITS.isAvailable()) {
            try {
                BITS.reserveMemory(theSize, theSize);
                if (DEBUG) {
                    Exception stackTrace = new Exception("reserve " + theSize);
                    LOGGER.info("reserve", (Throwable)stackTrace);
                    ALLOCATIONS.push(stackTrace);
                }
            }
            catch (OutOfMemoryException t) {
                if (DEBUG) {
                    LOGGER.warn("Possible memory leak", (Throwable)t);
                    for (Exception e : ALLOCATIONS) {
                        LOGGER.warn("not released", (Throwable)e);
                    }
                }
                throw t;
            }
        }
    }

    public static void releaseMemory(long theSize) {
        if (BITS.isAvailable()) {
            if (DEBUG) {
                LOGGER.info("release", (Throwable)new Exception("release " + theSize));
                ALLOCATIONS.pop();
            }
            BITS.unreserveMemory(theSize, theSize);
        }
    }

    public static boolean isAvailable() {
        return BITS.isAvailable();
    }

    private static interface IBits {
        public boolean isAvailable();

        public void reserveMemory(long var1, long var3);

        public void unreserveMemory(long var1, long var3);

        public int pageSize();
    }

    private static class BitsJDK7OrLater
    implements IBits {
        private static final boolean initialized;
        private static Class<?> BITS;
        private static Method RESERVE_MEMORY;
        private static Method UNRESERVE_MEMORY;
        private static Method PAGE_SIZE;
        private int mPageSize = -1;

        private BitsJDK7OrLater() {
        }

        @Override
        public int pageSize() {
            Preconditions.checkState((boolean)initialized);
            if (this.mPageSize == -1) {
                try {
                    this.mPageSize = ((Number)PAGE_SIZE.invoke(BITS, new Object[0])).intValue();
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new AssertionError();
                }
            }
            return this.mPageSize;
        }

        @Override
        public void reserveMemory(long theSize, long theCapacity) {
            Preconditions.checkState((boolean)initialized);
            try {
                this.reserveOrUnreserve(RESERVE_MEMORY, theSize, theCapacity);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof OutOfMemoryError) {
                    throw new OutOfMemoryException(String.format("Unable to reserve %,d bytes, direct memory exhausted", theSize));
                }
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void unreserveMemory(long theSize, long theCapacity) {
            Preconditions.checkState((boolean)initialized);
            try {
                this.reserveOrUnreserve(UNRESERVE_MEMORY, theSize, theCapacity);
            }
            catch (InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
        }

        private void reserveOrUnreserve(Method theMethod, long theSize, long theCapacity) throws InvocationTargetException {
            try {
                long aChunkSizeLimit = 0x40000000L;
                while (theCapacity > 0L) {
                    long aChunk = Math.min(theCapacity, 0x40000000L);
                    if (theCapacity == aChunk) {
                        theMethod.invoke(null, theSize, (int)theCapacity);
                    } else {
                        theMethod.invoke(null, aChunk, (int)aChunk);
                    }
                    theCapacity -= aChunk;
                    theSize -= aChunk;
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public boolean isAvailable() {
            return initialized;
        }

        static {
            boolean aInitialized = false;
            try {
                BITS = Class.forName("java.nio.Bits", true, ClassLoader.getSystemClassLoader());
                RESERVE_MEMORY = BITS.getDeclaredMethod("reserveMemory", Long.TYPE, Long.TYPE);
                RESERVE_MEMORY.setAccessible(true);
                UNRESERVE_MEMORY = BITS.getDeclaredMethod("unreserveMemory", Long.TYPE, Long.TYPE);
                UNRESERVE_MEMORY.setAccessible(true);
                PAGE_SIZE = BITS.getDeclaredMethod("pageSize", new Class[0]);
                PAGE_SIZE.setAccessible(true);
                aInitialized = true;
            }
            catch (Exception e) {
                LOGGER.warn("java.nio.Bits was not found; direct memory usage might exceed MaxDirectMemoryLimit setting.", (Throwable)e);
            }
            initialized = aInitialized;
        }
    }
}

