/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.sort.sorters.quick;

import com.complexible.memory.structure.sort.LongComparator;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.sorters.quick.BasePower2SlotSorter;

public abstract class LongOptimizedBaseSorter<S>
extends BasePower2SlotSorter<S> {
    int mPivotBlockIndex;
    int mPivotBlockOffset;
    long mPivotLongValue;
    private final int mLongValueOffset;
    protected final LongComparator mComparator;

    LongOptimizedBaseSorter(int theSlotSize, int theSlotSizeBitPosition, int theLongValueOffset, SortOrder theSortOrder, LongComparator theLongComparator) {
        super(theSlotSize, theSlotSizeBitPosition, theSortOrder);
        this.mLongValueOffset = theLongValueOffset;
        this.mComparator = theLongComparator;
    }

    @Override
    protected void readCurrent(long theIndex) {
        long aAddress = this.addressOfIndex(theIndex);
        this.mPivotBlockIndex = this.blockIndexAtAddress(aAddress);
        this.mPivotBlockOffset = this.blockOffsetAtAddress(aAddress);
        this.mPivotLongValue = this.mSourceAccessor.readLong(aAddress + (long)this.mLongValueOffset);
    }

    @Override
    protected int compare(long theIndex) {
        return this.mComparator.compare(this.longValue(theIndex), this.mPivotLongValue);
    }

    protected long longValue(long theIndex) {
        long aAddress = this.addressOfIndex(theIndex);
        return this.mSourceAccessor.readLong(aAddress + (long)this.mLongValueOffset);
    }

    int blockOffsetAtAddress(long theAddress) {
        return this.mSourceAccessor.readInt(theAddress + 4L);
    }

    int blockIndexAtAddress(long theAddress) {
        return this.mSourceAccessor.readInt(theAddress);
    }
}

