/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.sort.sorters.quick;

import com.complexible.common.base.Disposables;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Comparator;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.impl.hashtable.input.DefaultHashTableTapeElementInputFactory;
import com.complexible.memory.structure.input.HashTableTapeElementInputFactory;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.sorters.quick.BasePower2SlotSorter;
import com.complexible.memory.structure.sort.sorters.quick.accessor.MemoryBlockAccessor;
import com.complexible.memory.structure.sort.sorters.quick.accessor.SourceAccessor;
import com.google.common.base.Preconditions;
import java.util.function.Supplier;

public final class HashTableSorter
extends BasePower2SlotSorter<MemoryBlock> {
    private int mPivotHashCode;
    private final Comparator mComparator;
    private int mPivotPartitionHashCode;
    private long mPivotSegmentAddress;
    private final MemoryContext mMemoryContext;
    private final MemoryBlockChain mSingleBlockChain;
    private final HashTableTapeElementInputFactory mTapeElementInputFactory;
    private final Supplier<MemoryBlockChain> mMemoryBlockChainObjectSupplier;
    private final HashTableTapeElementInputFactory mPivotTapeElementInputFactory;

    public HashTableSorter(boolean theUniquesMode, Supplier<MemoryBlockChain> theMemoryBlockChainObjectSupplier, Comparator theComparator, MemoryContext theMemoryContext, MemoryBlockChainFactory theMemoryBlockChainFactory) {
        super(16, 4, SortOrder.ASC);
        Preconditions.checkNotNull((Object)theComparator);
        this.mTapeElementInputFactory = new DefaultHashTableTapeElementInputFactory(theMemoryContext);
        this.mPivotTapeElementInputFactory = new DefaultHashTableTapeElementInputFactory(theMemoryContext);
        this.initFactories(theUniquesMode);
        this.mComparator = theComparator;
        this.mMemoryContext = theMemoryContext;
        this.mMemoryBlockChainObjectSupplier = theMemoryBlockChainObjectSupplier;
        this.mSingleBlockChain = theMemoryBlockChainFactory.createMemoryBlockChain();
    }

    @Override
    public void gotoSource(MemoryBlock theMemorySource, OperationTracker theOperationTracker) {
        super.gotoSource(theMemorySource, theOperationTracker);
        if (this.mSingleBlockChain.size() == 0) {
            this.mSingleBlockChain.add(theMemorySource);
        } else {
            this.mSingleBlockChain.setMemoryBlock(0, theMemorySource);
        }
    }

    @Override
    protected int compare(long theIndex) {
        long aAddress = this.addressOfIndex(theIndex);
        long aSegmentAddress = this.readSegmentAddress(aAddress);
        int aHashCode = this.readHashCode(aAddress);
        int aPartitionHashCode = this.readPartitionHashCode(aAddress);
        return this.compare(aPartitionHashCode, aSegmentAddress, aHashCode, this.mPivotPartitionHashCode, this.mPivotSegmentAddress, this.mPivotHashCode);
    }

    @Override
    protected SourceAccessor<MemoryBlock> createAccessor() {
        return new MemoryBlockAccessor(this.slotSize());
    }

    @Override
    protected void readCurrent(long theIndex) {
        long aAddress = this.addressOfIndex(theIndex);
        this.mPivotSegmentAddress = this.readSegmentAddress(aAddress);
        this.mPivotHashCode = this.readHashCode(aAddress);
        this.mPivotPartitionHashCode = this.readPartitionHashCode(aAddress);
    }

    @Override
    public final void dispose() {
        Disposables.markReleased((Object)this);
        this.mTapeElementInputFactory.dispose();
        this.mPivotTapeElementInputFactory.dispose();
    }

    private long readSegmentAddress(long theAddress) {
        return this.mSourceAccessor.readLong(theAddress);
    }

    private int readHashCode(long theAddress) {
        return this.mSourceAccessor.readInt(theAddress + 8L);
    }

    private int readPartitionHashCode(long theAddress) {
        return this.mSourceAccessor.readInt(theAddress + 12L);
    }

    private void initFactories(boolean theUniquesMode) {
        this.mTapeElementInputFactory.setElementHeader(true);
        this.mPivotTapeElementInputFactory.setElementHeader(true);
        this.mTapeElementInputFactory.setUniquenessMode(theUniquesMode);
        this.mPivotTapeElementInputFactory.setUniquenessMode(theUniquesMode);
    }

    private int compareElements(long theLeftSegmentAddress, long theRightSegmentAddress) {
        Object aLeftTapeElementInput = this.mTapeElementInputFactory.createMemoryInput(this.mMemoryContext, this.mMemoryBlockChainObjectSupplier.get(), theLeftSegmentAddress);
        Object aRightTapeElementInput = this.mTapeElementInputFactory.createMemoryInput(this.mMemoryContext, this.mMemoryBlockChainObjectSupplier.get(), theRightSegmentAddress);
        return this.mComparator.compare((TapeElementInput)aLeftTapeElementInput, (TapeElementInput)aRightTapeElementInput);
    }

    private int compare(int theLeftPartitionHashCode, long theLeftSegmentAddress, int theLeftHashCode, int theRightPartitionHashCode, long theRightSegmentAddress, int theRightHashCode) {
        int aCmpResult = Integer.compare(theLeftPartitionHashCode, theRightPartitionHashCode);
        if (aCmpResult != 0) {
            return aCmpResult;
        }
        if (theLeftSegmentAddress == theRightSegmentAddress) {
            return 0;
        }
        aCmpResult = Integer.compare(theLeftHashCode, theRightHashCode);
        if (aCmpResult != 0) {
            return aCmpResult;
        }
        return this.compareElements(theLeftSegmentAddress, theRightSegmentAddress);
    }
}

