/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.sort.sorters.quick;

import com.complexible.common.base.AutoCloser;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.DataAreaAccessor;
import com.complexible.memory.structure.impl.tape.MemoryBlocksDataArea;
import com.complexible.memory.structure.impl.tape.OutOfMemoryException;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.sorters.quick.SlotBaseQuickSorter;
import com.complexible.memory.util.Utilities;

abstract class BaseTimSorter<S>
extends SlotBaseQuickSorter<S> {
    private static final boolean USE_QUICK_SORT = true;
    private static final long MIN_MERGE = 32L;
    private static final long MIN_GALLOP = 7L;
    private static final int INITIAL_TMP_STORAGE_LENGTH = 256;
    private int mStackSize;
    private long mMinGallop;
    protected final MemoryBlocksDataArea mTmp;
    protected final DataAreaAccessor mBlockDataArea;
    private final MemoryBlocksDataArea mStack;
    protected final MemoryContext mMemoryContext;

    protected BaseTimSorter(int theSlotSize, MemoryContext theMemoryContext, MemoryBlockChainFactory theMemoryBlockChainFactory, SortOrder theSortOrder) {
        super(theSlotSize, theSortOrder);
        this.mMemoryContext = theMemoryContext;
        this.mTmp = new MemoryBlocksDataArea(theMemoryBlockChainFactory);
        this.mStack = new MemoryBlocksDataArea(theMemoryBlockChainFactory);
        this.mBlockDataArea = new MemoryBlocksDataArea(theMemoryBlockChainFactory);
    }

    @Override
    protected void sort0(long lo, long hi) {
        this.quickSort(lo, hi);
    }

    private void quickSort(long lo, long hi) {
        super.sort0(lo, hi - 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timSort(long lo, long hi) {
        try {
            try {
                this.init(hi - lo);
                this.timSort0(lo, hi);
            }
            finally {
                this.onSortingDone();
            }
        }
        catch (OutOfMemoryException theE) {
            super.sort0(lo, hi - 1L);
        }
    }

    private void init(long len) {
        this.mStackSize = 0;
        this.mMinGallop = 7L;
        this.mTmp.createArea();
        this.mStack.createArea();
        int stackLen = len < 120L ? 5 : (len < 1542L ? 10 : (len < 119151L ? 24 : 49));
        this.ensureStack(stackLen);
        long aTlen = len < 512L ? len >>> 1 : 256L;
        this.ensureTmp(aTlen);
    }

    private void onSortingDone() {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
        autoCloseableArray[0] = this.mTmp::dispose;
        autoCloseableArray[1] = this.mStack::dispose;
        AutoCloser.close((AutoCloseable[])autoCloseableArray);
    }

    private void timSort0(long lo, long hi) {
        long aRunLen;
        long aRemaining = hi - lo;
        if (aRemaining < 2L) {
            return;
        }
        if (aRemaining < 32L) {
            long aInitRunLen = this.countRunAndMakeAscending(lo, hi);
            this.binarySort(lo, hi, lo + aInitRunLen);
            return;
        }
        long aMinRun = this.minRunLength(aRemaining);
        do {
            if ((aRunLen = this.countRunAndMakeAscending(lo, hi)) < aMinRun) {
                long aForce = aRemaining <= aMinRun ? aRemaining : aMinRun;
                this.binarySort(lo, lo + aForce, lo + aRunLen);
                aRunLen = aForce;
            }
            this.pushRun(lo, aRunLen);
            this.mergeCollapse();
            lo += aRunLen;
        } while ((aRemaining -= aRunLen) != 0L);
        assert (lo == hi);
        this.mergeForceCollapse();
        assert (this.mStackSize == 1);
    }

    private void binarySort(long lo, long hi, long theStart) {
        if (theStart == lo) {
            ++theStart;
        }
        while (theStart < hi) {
            this.readCurrent(theStart);
            long aLeft = lo;
            long right = theStart;
            while (aLeft < right) {
                long aMid = aLeft + right >>> 1;
                if (this.processDirection(this.compare(aMid)) >= 0) {
                    right = aMid;
                    continue;
                }
                aLeft = aMid + 1L;
            }
            long aNumber = theStart - aLeft;
            if (aNumber == 2L) {
                this.set(aLeft + 1L, aLeft + 2L);
                this.set(aLeft, aLeft + 1L);
            } else if (aNumber == 1L) {
                this.set(aLeft, aLeft + 1L);
            } else {
                this.copy(aLeft, aLeft + 1L, aNumber);
            }
            this.setCurrent(aLeft);
            ++theStart;
        }
    }

    private long getStackSize() {
        long aTotalSize = Utilities.multiplyLongPowerOfTwoAsLong((long)this.mStack.get().size(), this.mMemoryContext.getBlockSizeBitPosition());
        return Utilities.divideLongPowerOfTwoAsLong(aTotalSize, 4);
    }

    protected void ensureStack(long theSize) {
        while (this.getStackSize() < theSize) {
            if (this.mStack.get().obtainNext()) continue;
            throw new OutOfMemoryException("out of memory");
        }
    }

    private void ensureTmp(long theSize) {
        while (this.getTmpSize() < theSize) {
            if (this.mTmp.get().obtainNext()) continue;
            throw new OutOfMemoryException("out of memory");
        }
    }

    private long countRunAndMakeAscending(long lo, long hi) {
        long aRunHi = lo + 1L;
        if (aRunHi == hi) {
            return 1L;
        }
        if (this.compare(aRunHi++, lo) < 0) {
            while (aRunHi < hi && this.compare(aRunHi, aRunHi - 1L) < 0) {
                ++aRunHi;
            }
            this.reverseRange(lo, aRunHi);
        } else {
            while (aRunHi < hi && this.compare(aRunHi, aRunHi - 1L) >= 0) {
                ++aRunHi;
            }
        }
        return aRunHi - lo;
    }

    private void reverseRange(long lo, long hi) {
        --hi;
        while (lo < hi) {
            this.swap(lo++, hi--);
        }
    }

    private long minRunLength(long theNumber) {
        assert (theNumber >= 0L);
        long aR = 0L;
        while (theNumber >= 32L) {
            aR |= theNumber & 1L;
            theNumber >>= 1;
        }
        return theNumber + aR;
    }

    private void pushRun(long theRunBase, long theRunLen) {
        long aBaseAddress = this.getStackAddress(this.mStackSize);
        this.mStack.writeLong(aBaseAddress, theRunBase);
        this.mStack.writeLong(aBaseAddress + 8L, theRunLen);
        ++this.mStackSize;
    }

    private long getStackAddress(long theIndex) {
        return Utilities.multiplyLongPowerOfTwoAsLong(theIndex, 4);
    }

    private void mergeCollapse() {
        while (this.mStackSize > 1) {
            int aNumber = this.mStackSize - 2;
            if (aNumber > 0 && this.getRunLen(aNumber - 1) <= this.getRunLen(aNumber) + this.getRunLen(aNumber + 1)) {
                if (this.getRunLen(aNumber - 1) < this.getRunLen(aNumber + 1)) {
                    --aNumber;
                }
                this.mergeAt(aNumber);
                continue;
            }
            if (this.getRunLen(aNumber) > this.getRunLen(aNumber + 1)) break;
            this.mergeAt(aNumber);
        }
    }

    private long getRunBase(long theIndex) {
        return this.mStack.readLong(this.getStackAddress(theIndex));
    }

    private long getRunLen(long theIndex) {
        return this.mStack.readLong(this.getStackAddress(theIndex) + 8L);
    }

    private void setRunLen(long theIndex, long theValue) {
        this.mStack.writeLong(this.getStackAddress(theIndex) + 8L, theValue);
    }

    private void copyRunBase(long theSrcIndex, long theDstIndex) {
        this.mStack.writeLong(this.getStackAddress(theDstIndex), this.mStack.readLong(this.getStackAddress(theSrcIndex)));
    }

    private void copyRunLen(long theSrcIndex, long theDstIndex) {
        this.mStack.writeLong(this.getStackAddress(theDstIndex) + 8L, this.mStack.readLong(this.getStackAddress(theSrcIndex) + 8L));
    }

    private void mergeForceCollapse() {
        while (this.mStackSize > 1) {
            int aNumber = this.mStackSize - 2;
            if (aNumber > 0 && this.getRunLen(aNumber - 1) < this.getRunLen(aNumber + 1)) {
                --aNumber;
            }
            this.mergeAt(aNumber);
        }
    }

    private void mergeAt(long theIndex) {
        long aBase1 = this.getRunBase(theIndex);
        long aLen1 = this.getRunLen(theIndex);
        long aBase2 = this.getRunBase(theIndex + 1L);
        long aLen2 = this.getRunLen(theIndex + 1L);
        this.setRunLen(theIndex, aLen1 + aLen2);
        if (theIndex == (long)(this.mStackSize - 3)) {
            this.copyRunBase(theIndex + 2L, theIndex + 1L);
            this.copyRunLen(theIndex + 2L, theIndex + 1L);
        }
        --this.mStackSize;
        long aK = this.gallopRight(aBase2, aBase1, aLen1, 0L, false, false);
        aBase1 += aK;
        if ((aLen1 -= aK) == 0L) {
            return;
        }
        if ((aLen2 = this.gallopLeft(aBase1 + aLen1 - 1L, aBase2, aLen2, aLen2 - 1L, false, false)) == 0L) {
            return;
        }
        if (aLen1 <= aLen2) {
            this.mergeLo(aBase1, aLen1, aBase2, aLen2);
        } else {
            this.mergeHi(aBase1, aLen1, aBase2, aLen2);
        }
    }

    private long gallopLeft(long theKeyIndex, long theBase, long theLen, long theHint, boolean theIsKeyTmp, boolean theIsTmp) {
        long aLastOfs = 0L;
        long aOfs = 1L;
        if (this.compare(theKeyIndex, theBase + theHint, theIsKeyTmp, theIsTmp) > 0) {
            maxOfs = theLen - theHint;
            while (aOfs < maxOfs && this.compare(theKeyIndex, theBase + theHint + aOfs, theIsKeyTmp, theIsTmp) > 0) {
                aLastOfs = aOfs;
                if ((aOfs = (aOfs << 1) + 1L) > 0L) continue;
                aOfs = maxOfs;
            }
            if (aOfs > maxOfs) {
                aOfs = maxOfs;
            }
            aLastOfs += theHint;
            aOfs += theHint;
        } else {
            maxOfs = theHint + 1L;
            while (aOfs < maxOfs && this.compare(theKeyIndex, theBase + theHint - aOfs, theIsKeyTmp, theIsTmp) <= 0) {
                aLastOfs = aOfs;
                if ((aOfs = (aOfs << 1) + 1L) > 0L) continue;
                aOfs = maxOfs;
            }
            if (aOfs > maxOfs) {
                aOfs = maxOfs;
            }
            long tmp = aLastOfs;
            aLastOfs = theHint - aOfs;
            aOfs = theHint - tmp;
        }
        ++aLastOfs;
        while (aLastOfs < aOfs) {
            long aM = aLastOfs + (aOfs - aLastOfs >>> 1);
            if (this.compare(theKeyIndex, theBase + aM, theIsKeyTmp, theIsTmp) > 0) {
                aLastOfs = aM + 1L;
                continue;
            }
            aOfs = aM;
        }
        return aOfs;
    }

    private long gallopRight(long theKeyIndex, long theBase, long theLen, long theHint, boolean theIsKeyTmp, boolean theIsTmp) {
        long aOfs = 1L;
        long aLastOfs = 0L;
        if (this.compare(theKeyIndex, theBase + theHint, theIsKeyTmp, theIsTmp) < 0) {
            aMaxOfs = theHint + 1L;
            while (aOfs < aMaxOfs && this.compare(theKeyIndex, theBase + theHint - aOfs, theIsKeyTmp, theIsTmp) < 0) {
                aLastOfs = aOfs;
                if ((aOfs = (aOfs << 1) + 1L) > 0L) continue;
                aOfs = aMaxOfs;
            }
            if (aOfs > aMaxOfs) {
                aOfs = aMaxOfs;
            }
            long tmp = aLastOfs;
            aLastOfs = theHint - aOfs;
            aOfs = theHint - tmp;
        } else {
            aMaxOfs = theLen - theHint;
            while (aOfs < aMaxOfs && this.compare(theKeyIndex, theBase + theHint + aOfs, theIsKeyTmp, theIsTmp) >= 0) {
                aLastOfs = aOfs;
                if ((aOfs = (aOfs << 1) + 1L) > 0L) continue;
                aOfs = aMaxOfs;
            }
            if (aOfs > aMaxOfs) {
                aOfs = aMaxOfs;
            }
            aLastOfs += theHint;
            aOfs += theHint;
        }
        ++aLastOfs;
        while (aLastOfs < aOfs) {
            long aM = aLastOfs + (aOfs - aLastOfs >>> 1);
            if (this.compare(theKeyIndex, theBase + aM, theIsKeyTmp, theIsTmp) < 0) {
                aOfs = aM;
                continue;
            }
            aLastOfs = aM + 1L;
        }
        return aOfs;
    }

    private void mergeLo(long theBase1, long theLen1, long theBase2, long theLen2) {
        this.ensureTmp(theLen1);
        long aCursor1 = 0L;
        long aCursor2 = theBase2;
        long aDest = theBase1;
        this.copyToTmp(theBase1, aCursor1, theLen1);
        this.set(aCursor2++, aDest++);
        if (--theLen2 == 0L) {
            this.copyFromTmp(aCursor1, aDest, theLen1);
            return;
        }
        if (theLen1 == 1L) {
            this.copy(aCursor2, aDest, theLen2);
            this.setFromTmp(aCursor1, aDest + theLen2);
            return;
        }
        long aMinGallop = this.mMinGallop;
        block0: while (true) {
            long aCount1 = 0L;
            long aCount2 = 0L;
            do {
                if (this.compareTmpRight(aCursor2, aCursor1) < 0) {
                    this.set(aCursor2++, aDest++);
                    ++aCount2;
                    aCount1 = 0L;
                    if (--theLen2 != 0L) continue;
                    break block0;
                }
                this.setFromTmp(aCursor1++, aDest++);
                ++aCount1;
                aCount2 = 0L;
                if (--theLen1 == 1L) break block0;
            } while ((aCount1 | aCount2) < aMinGallop);
            do {
                if ((aCount1 = this.gallopRight(aCursor2, aCursor1, theLen1, 0L, false, true)) != 0L) {
                    this.copyFromTmp(aCursor1, aDest, aCount1);
                    aDest += aCount1;
                    aCursor1 += aCount1;
                    if ((theLen1 -= aCount1) <= 1L) break block0;
                }
                this.set(aCursor2++, aDest++);
                if (--theLen2 == 0L) break block0;
                aCount2 = this.gallopLeft(aCursor1, aCursor2, theLen2, 0L, true, false);
                if (aCount2 != 0L) {
                    this.copy(aCursor2, aDest, aCount2);
                    aDest += aCount2;
                    aCursor2 += aCount2;
                    if ((theLen2 -= aCount2) == 0L) break block0;
                }
                this.setFromTmp(aCursor1++, aDest++);
                if (--theLen1 == 1L) break block0;
                --aMinGallop;
            } while (aCount1 >= 7L | aCount2 >= 7L);
            if (aMinGallop < 0L) {
                aMinGallop = 0L;
            }
            aMinGallop += 2L;
        }
        long l = this.mMinGallop = aMinGallop < 1L ? 1L : aMinGallop;
        if (theLen1 == 1L) {
            this.copy(aCursor2, aDest, theLen2);
            this.setFromTmp(aCursor1, aDest + theLen2);
        } else {
            if (theLen1 == 0L) {
                throw new IllegalArgumentException("Comparison method violates its general contract!");
            }
            this.copyFromTmp(aCursor1, aDest, theLen1);
        }
    }

    private void mergeHi(long theBase1, long theLen1, long theBase2, long theLen2) {
        this.ensureTmp(theLen2);
        this.copyToTmp(theBase2, 0L, theLen2);
        long aCursor1 = theBase1 + theLen1 - 1L;
        long aCursor2 = theLen2 - 1L;
        long aDest = theBase2 + theLen2 - 1L;
        this.set(aCursor1--, aDest--);
        if (--theLen1 == 0L) {
            this.copyFromTmp(0L, aDest - (theLen2 - 1L), theLen2);
            return;
        }
        if (theLen2 == 1L) {
            this.copy((aCursor1 -= theLen1) + 1L, (aDest -= theLen1) + 1L, theLen1);
            this.setFromTmp(aCursor2, aDest);
            return;
        }
        long aMinGallop = this.mMinGallop;
        block0: while (true) {
            long aCount1 = 0L;
            long aCount2 = 0L;
            do {
                if (this.compareTmpLeft(aCursor2, aCursor1) < 0) {
                    this.set(aCursor1--, aDest--);
                    ++aCount1;
                    aCount2 = 0L;
                    if (--theLen1 != 0L) continue;
                    break block0;
                }
                this.setFromTmp(aCursor2--, aDest--);
                ++aCount2;
                aCount1 = 0L;
                if (--theLen2 == 1L) break block0;
            } while ((aCount1 | aCount2) < aMinGallop);
            do {
                if ((aCount1 = theLen1 - this.gallopRight(aCursor2, theBase1, theLen1, theLen1 - 1L, true, false)) != 0L) {
                    this.copy((aCursor1 -= aCount1) + 1L, (aDest -= aCount1) + 1L, aCount1);
                    if ((theLen1 -= aCount1) == 0L) break block0;
                }
                this.setFromTmp(aCursor2--, aDest--);
                if (--theLen2 == 1L) break block0;
                aCount2 = theLen2 - this.gallopLeft(aCursor1, 0L, theLen2, theLen2 - 1L, false, true);
                if (aCount2 != 0L) {
                    this.copyFromTmp((aCursor2 -= aCount2) + 1L, (aDest -= aCount2) + 1L, aCount2);
                    if ((theLen2 -= aCount2) <= 1L) break block0;
                }
                this.set(aCursor1--, aDest--);
                if (--theLen1 == 0L) break block0;
                --aMinGallop;
            } while (aCount1 >= 7L | aCount2 >= 7L);
            if (aMinGallop < 0L) {
                aMinGallop = 0L;
            }
            aMinGallop += 2L;
        }
        long l = this.mMinGallop = aMinGallop < 1L ? 1L : aMinGallop;
        if (theLen2 == 1L) {
            assert (theLen1 > 0L);
            this.copy((aCursor1 -= theLen1) + 1L, (aDest -= theLen1) + 1L, theLen1);
            this.setFromTmp(aCursor2, aDest);
        } else {
            if (theLen2 == 0L) {
                throw new IllegalArgumentException("Comparison method violates its general contract!");
            }
            this.copyFromTmp(0L, aDest - (theLen2 - 1L), theLen2);
        }
    }

    protected void set(long theSrcIndex, long theDstIndex) {
        this.mBlockDataArea.copyMemory(this.addressOfIndex(theSrcIndex), this.addressOfIndex(theDstIndex), this.mSlotSize, this.mBlockDataArea);
    }

    protected void setFromTmp(long theSrcIndex, long theDstIndex) {
        this.mBlockDataArea.copyMemory(this.addressOfIndex(theSrcIndex), this.addressOfIndex(theDstIndex), this.mSlotSize, this.mTmp);
    }

    protected long readLong(long theIndex, boolean theTmp) {
        if (theTmp) {
            return this.mTmp.readLong(this.addressOfIndex(theIndex));
        }
        return this.mBlockDataArea.readLong(this.addressOfIndex(theIndex));
    }

    protected void copy(long theSrcIndex, long theDstIndex, long theCount) {
        if (theCount > 0L) {
            this.mBlockDataArea.copyMemory(this.addressOfIndex(theSrcIndex), this.addressOfIndex(theDstIndex), this.addressOfIndex(theCount), this.mBlockDataArea);
        }
    }

    protected void copyToTmp(long theSrcIndex, long theDstIndex, long theLength) {
        if (theLength > 0L) {
            this.mTmp.copyMemory(this.addressOfIndex(theSrcIndex), this.addressOfIndex(theDstIndex), this.addressOfIndex(theLength), this.mBlockDataArea);
        }
    }

    protected void copyFromTmp(long theSrcIndex, long theDstIndex, long theLength) {
        if (theLength > 0L) {
            this.mBlockDataArea.copyMemory(this.addressOfIndex(theSrcIndex), this.addressOfIndex(theDstIndex), this.addressOfIndex(theLength), this.mTmp);
        }
    }

    private int compareTmpRight(long theIndex, long theTmpIndex) {
        return this.compare(theIndex, theTmpIndex, false, true);
    }

    private int compareTmpLeft(long theTmpIndex, long theIndex) {
        return this.compare(theTmpIndex, theIndex, true, false);
    }

    protected int compare(long theLeftIndex, long theRightIndex) {
        return this.compare(theLeftIndex, theRightIndex, false, false);
    }

    private int compare(long theLeftIndex, long theRightIndex, boolean isLeftTmp, boolean isRightTmp) {
        return this.processDirection(this.compare0(theLeftIndex, theRightIndex, isLeftTmp, isRightTmp));
    }

    protected abstract long getTmpSize();

    protected abstract int compare0(long var1, long var3, boolean var5, boolean var6);

    protected abstract void setCurrent(long var1);
}

