/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.sort.sorters.quick;

import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Comparator;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.TapeElementInputFactory;
import com.complexible.memory.structure.input.impl.DefaultTapeElementInputFactory;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.sorters.quick.BasePower2SlotSorter;
import java.util.function.Supplier;

abstract class BaseConventionalSorter<S>
extends BasePower2SlotSorter<S> {
    private int mPivotBlockIndex;
    private int mPivotBlockOffset;
    private final Comparator mDefaultComparator;
    protected final TapeElementInputFactory mLeftTapeElementInputFactory;
    private final TapeElementInputFactory mRightTapeElementInputFactory;
    protected final Supplier<MemoryBlockChain> mDataMemoryBlockChainSupplier;

    public BaseConventionalSorter(MemoryContext theMemoryContext, Supplier<MemoryBlockChain> theDataMemoryBlockChainSupplier, MemoryBlockChainFactory theMemoryBlockChainFactory, SortOrder theSortOrder, Comparator theComparator) {
        super(8, 3, theSortOrder);
        this.mDataMemoryBlockChainSupplier = theDataMemoryBlockChainSupplier;
        this.mLeftTapeElementInputFactory = new DefaultTapeElementInputFactory(theMemoryContext, theMemoryBlockChainFactory);
        this.mRightTapeElementInputFactory = new DefaultTapeElementInputFactory(theMemoryContext, theMemoryBlockChainFactory);
        this.mDefaultComparator = theComparator;
    }

    @Override
    protected void readCurrent(long theIndex) {
        long aAddress = this.addressOfIndex(theIndex);
        this.mPivotBlockIndex = this.blockIndexAtAddress(aAddress);
        this.mPivotBlockOffset = this.blockOffsetAtAddress(aAddress);
    }

    @Override
    public void gotoSource(S theMemorySource, OperationTracker theOperationTracker) {
        super.gotoSource(theMemorySource, theOperationTracker);
        this.mLeftTapeElementInputFactory.reset();
        this.mRightTapeElementInputFactory.reset();
    }

    @Override
    protected int compare(long theIndex) {
        MemoryBlockChain aMemoryBlockChain = this.mDataMemoryBlockChainSupplier.get();
        long aAddress = this.addressOfIndex(theIndex);
        int aBlockIndex = this.blockIndexAtAddress(aAddress);
        int aBlockOffset = this.blockOffsetAtAddress(aAddress);
        Object aLeftTapeElementInput = this.mLeftTapeElementInputFactory.createMemoryInput(aMemoryBlockChain, aBlockOffset, aBlockIndex);
        Object aRightTapeElementInput = this.mRightTapeElementInputFactory.createMemoryInput(aMemoryBlockChain, this.mPivotBlockOffset, this.mPivotBlockIndex);
        return this.mDefaultComparator.compare((TapeElementInput)aLeftTapeElementInput, (TapeElementInput)aRightTapeElementInput);
    }

    @Override
    public final void dispose() {
        super.dispose();
        this.mLeftTapeElementInputFactory.dispose();
        this.mRightTapeElementInputFactory.dispose();
    }

    protected int blockOffsetAtAddress(long theAddress) {
        return this.mSourceAccessor.readInt(theAddress + 4L);
    }

    protected int blockIndexAtAddress(long theAddress) {
        return this.mSourceAccessor.readInt(theAddress);
    }
}

