/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.sort.sorters.heap;

import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Comparator;
import com.complexible.memory.structure.impl.aggregator.collector.AggregatorOutputCollector;
import com.complexible.memory.structure.impl.hashtable.input.DefaultHashTableTapeElementInputFactory;
import com.complexible.memory.structure.impl.hashtable.iterator.sort.ConventionalHashTableMultiInputIterator;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.input.HashTableTapeElementInputFactory;
import com.complexible.memory.structure.sort.sorters.heap.BaseHashTableHeapSorter;
import com.complexible.memory.structure.sort.sorters.heap.BaseHeapSorter;
import com.google.common.base.Preconditions;

public final class HashTableHeapSorter
extends BaseHashTableHeapSorter<ConventionalHashTableMultiInputIterator, AggregatorOutputCollector> {
    private final Comparator mComparator;
    private final HashTableTapeElementInputFactory mLeftTapeElementInputFactory;
    private final HashTableTapeElementInputFactory mRightTapeElementInputFactory;

    public HashTableHeapSorter(MemoryContext theMemoryContext, Comparator theComparator, boolean theUniquesMode) {
        super(theMemoryContext, theUniquesMode);
        Preconditions.checkNotNull((Object)theComparator, (Object)"comparator cannot be null");
        this.mComparator = theComparator;
        this.mLeftTapeElementInputFactory = new DefaultHashTableTapeElementInputFactory(theMemoryContext);
        this.mRightTapeElementInputFactory = new DefaultHashTableTapeElementInputFactory(theMemoryContext);
        this.mLeftTapeElementInputFactory.setUniquenessMode(theUniquesMode);
        this.mRightTapeElementInputFactory.setUniquenessMode(theUniquesMode);
        this.mLeftTapeElementInputFactory.setElementHeader(true);
        this.mRightTapeElementInputFactory.setElementHeader(true);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mLeftTapeElementInputFactory.dispose();
        this.mRightTapeElementInputFactory.dispose();
    }

    @Override
    public void resetTo(ConventionalHashTableMultiInputIterator theInput, AggregatorOutputCollector theOutputCollector) {
        super.resetTo(theInput, theOutputCollector);
        this.mLeftTapeElementInputFactory.reset();
        this.mRightTapeElementInputFactory.reset();
    }

    @Override
    protected int compare0(int theLeftInputId, int theRightInputId) {
        Object aLeftTapeElementInput = ((ConventionalHashTableMultiInputIterator)this.mInput).createInput(theLeftInputId, this.mLeftTapeElementInputFactory);
        Object aRightTapeElementInput = ((ConventionalHashTableMultiInputIterator)this.mInput).createInput(theRightInputId, this.mRightTapeElementInputFactory);
        int aLeftHashCode = aLeftTapeElementInput.readInt(8L);
        int aLeftPartitionHashCode = aLeftTapeElementInput.readInt();
        int aRightHashCode = aRightTapeElementInput.readInt(8L);
        int aRightPartitionHashCode = aRightTapeElementInput.readInt();
        int aCmpResult = Integer.compare(aLeftPartitionHashCode, aRightPartitionHashCode);
        if (aCmpResult != 0) {
            return aCmpResult;
        }
        aCmpResult = Integer.compare(aLeftHashCode, aRightHashCode);
        if (aCmpResult != 0) {
            return aCmpResult;
        }
        return this.compareElements(theLeftInputId, theRightInputId);
    }

    @Override
    protected BaseHeapSorter.IndexDirection getIndexDirection(int theNextInputId, int theHeapInputId) {
        int aResult = this.compare(theNextInputId, theHeapInputId);
        if (aResult != 0) {
            return this.handleDirection(aResult);
        }
        BaseHeapSorter.IndexDirection aIndexDirection = this.handleDirection(Long.compare(theNextInputId, theHeapInputId));
        if (aIndexDirection == BaseHeapSorter.IndexDirection.LEFT) {
            this.mSegmentMarkers[theNextInputId] = true;
        } else {
            this.mSegmentMarkers[theHeapInputId] = true;
        }
        return aIndexDirection;
    }

    @Override
    protected void emitInput(int theInputId) {
        ((AggregatorOutputCollector)this.mOutput).collect(((ConventionalHashTableMultiInputIterator)this.mInput).getDataInput(theInputId));
        while (((ConventionalHashTableMultiInputIterator)this.mInput).hasNextDataInput()) {
            ((AggregatorOutputCollector)this.mOutput).collect(((ConventionalHashTableMultiInputIterator)this.mInput).getNextDataInput());
        }
    }

    @Override
    protected void emitSegment(int theInputId, long theRecordsCount) {
        Object aHeaderInput = ((ConventionalHashTableMultiInputIterator)this.mInput).getInput(theInputId);
        int aHashCode = aHeaderInput.readInt(8L);
        int aPartitionHashCode = aHeaderInput.readInt();
        ((AggregatorOutputCollector)this.mOutput).collectSegment(aHashCode, aPartitionHashCode, theRecordsCount);
    }

    @Override
    protected long getInputRecordsCount(int theInputId) {
        if (theInputId == 0) {
            return ((HashTableTapeElementInput)((ConventionalHashTableMultiInputIterator)this.mInput).getInput(theInputId)).readLong(16L);
        }
        return ((ConventionalHashTableMultiInputIterator)this.mInput).getDataInput(theInputId).getSegmentElementsCount();
    }

    private int compareElements(int theLeftInputId, int theRightInputId) {
        HashTableTapeElementInput aLeftTapeElementInput = ((ConventionalHashTableMultiInputIterator)this.mInput).getDataInput(theLeftInputId);
        HashTableTapeElementInput aRightTapeElementInput = ((ConventionalHashTableMultiInputIterator)this.mInput).getDataInput(theRightInputId);
        return this.mComparator.compare(aLeftTapeElementInput, aRightTapeElementInput);
    }
}

