/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.sort.sorters.heap;

import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Comparator;
import com.complexible.memory.structure.ConventionalOutputCollector;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.TapeElementInputFactory;
import com.complexible.memory.structure.input.impl.DefaultTapeElementInputFactory;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.iterator.GenericMultiInputIterator;
import com.complexible.memory.structure.sort.sorters.heap.BaseHeapSorter;

public final class DefaultHeapSorter
extends BaseHeapSorter<GenericMultiInputIterator, ConventionalOutputCollector<TapeElementInput>> {
    private final Comparator mComparator;
    private final TapeElementInputFactory<TapeElementInput> mLeftTapeElementInputFactory;
    private final TapeElementInputFactory<TapeElementInput> mRightTapeElementInputFactory;

    public DefaultHeapSorter(MemoryContext theMemoryContext, MemoryBlockChainFactory theMemoryBlockChainFactory, SortOrder theSortOrder, Comparator theComparator) {
        super(theSortOrder);
        this.mComparator = theComparator;
        this.mLeftTapeElementInputFactory = new DefaultTapeElementInputFactory(theMemoryContext, theMemoryBlockChainFactory);
        this.mRightTapeElementInputFactory = new DefaultTapeElementInputFactory(theMemoryContext, theMemoryBlockChainFactory);
    }

    @Override
    protected int compare0(int theLeftInputId, int theRightInputId) {
        Object aLeftTapeElementInput = ((GenericMultiInputIterator)this.mInput).createInput(theLeftInputId, this.mLeftTapeElementInputFactory);
        Object aRightTapeElementInput = ((GenericMultiInputIterator)this.mInput).createInput(theRightInputId, this.mRightTapeElementInputFactory);
        return this.mComparator.compare((TapeElementInput)aLeftTapeElementInput, (TapeElementInput)aRightTapeElementInput);
    }

    @Override
    public void resetTo(GenericMultiInputIterator theInput, ConventionalOutputCollector<TapeElementInput> theOutputCollector) {
        super.resetTo(theInput, theOutputCollector);
        this.mLeftTapeElementInputFactory.reset();
        this.mRightTapeElementInputFactory.reset();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mLeftTapeElementInputFactory.dispose();
        this.mRightTapeElementInputFactory.dispose();
    }

    @Override
    protected boolean emitElement(int theInputId) {
        ((ConventionalOutputCollector)this.mOutput).collect(((GenericMultiInputIterator)this.mInput).getInput(theInputId));
        return true;
    }
}

