/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.sort.sorters.heap;

import com.complexible.memory.structure.OutputCollector;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.iterator.MultiInputIterator;
import com.complexible.memory.structure.sort.sorters.Sorter;
import java.util.Arrays;

public abstract class BaseHeapSorter<I extends MultiInputIterator, O extends OutputCollector>
implements Sorter<I, O> {
    protected static final int HEAD_INDEX_IDX = 0;
    protected static final int DUMMY_SOURCE_INPUT_INDEX = -1;
    protected O mOutput;
    protected I mInput;
    protected final SortOrder mDirection;
    protected int mChunkSize;
    protected int mInputsCount;
    protected int mLeftUsed;
    protected int mLeftActual;
    protected int mRightActual;
    protected int[] mSortedHeap;
    protected boolean[] mInputsDone;
    protected int mActualInputsCount;

    protected BaseHeapSorter(SortOrder theDirection) {
        this.mDirection = theDirection;
    }

    @Override
    public boolean assemble() {
        int aWrittenRecordCount = 0;
        while (aWrittenRecordCount < this.mChunkSize) {
            if (this.refreshHeap()) {
                return true;
            }
            if (!this.write()) continue;
            ++aWrittenRecordCount;
        }
        return false;
    }

    @Override
    public void setChunkSize(int theChunkSize) {
        this.mChunkSize = theChunkSize;
    }

    @Override
    public void resetTo(I theInput, O theOutputCollector) {
        theInput.reset();
        this.mInput = theInput;
        this.mOutput = theOutputCollector;
        this.initSortedHeap(theInput);
        this.mActualInputsCount = this.mInputsCount = theInput.availableInputsCount();
        this.mLeftActual = this.mInputsCount;
        this.mLeftUsed = 0;
        this.mRightActual = -1;
    }

    public void dispose() {
        if (this.mInput != null) {
            this.mInput.dispose();
        }
        this.mOutput = null;
        this.mInput = null;
    }

    protected abstract boolean emitElement(int var1);

    protected void initSortedHeap(I theInput) {
        this.mSortedHeap = this.reuseIfPossible(this.mSortedHeap, theInput.availableInputsCount());
        this.mInputsDone = this.reuseIfPossible(this.mInputsDone, theInput.availableInputsCount());
        Arrays.fill(this.mInputsDone, false);
        Arrays.fill(this.mSortedHeap, -1);
    }

    private boolean write() {
        int aIndex;
        int aInputId;
        if ((aInputId = this.mSortedHeap[aIndex = this.mLeftActual++]) == -1 || this.mInputsDone[aInputId]) {
            ++this.mLeftActual;
            return false;
        }
        while (!this.emitElement(aInputId)) {
            aInputId = this.mSortedHeap[this.mLeftActual];
            ++this.mLeftActual;
        }
        return true;
    }

    private boolean initHeap() {
        boolean aDone = true;
        Arrays.fill(this.mSortedHeap, -1);
        this.mLeftActual = this.mInputsCount;
        this.mLeftUsed = 0;
        this.mRightActual = -1;
        for (int aInputId = 0; aInputId < this.mInputsCount; ++aInputId) {
            int aIndex;
            if (this.mInputsDone[aInputId] || (aIndex = this.processInput(aInputId)) == -1) continue;
            aDone = false;
            this.refreshActual(aIndex);
        }
        return aDone;
    }

    private boolean refreshHeap() {
        if (this.mLeftActual >= this.mInputsCount) {
            return this.initHeap();
        }
        int idx = this.mLeftUsed;
        int baseLeftActual = this.mLeftActual;
        while (idx < this.mLeftActual) {
            if (this.mSortedHeap[idx] != -1) {
                this.processInput(this.mSortedHeap[idx]);
                if (baseLeftActual == this.mLeftActual) {
                    ++idx;
                }
                this.unsetIndex(idx - 1);
                this.mLeftUsed = idx;
                baseLeftActual = this.mLeftActual;
                continue;
            }
            ++idx;
        }
        return this.mActualInputsCount == 0;
    }

    private void unsetIndex(int theIdx) {
        if (theIdx >= 0 && theIdx < this.mInputsCount) {
            this.mSortedHeap[theIdx] = -1;
        }
    }

    private int processInput(int theInputId) {
        if (this.mInputsDone[theInputId]) {
            return -1;
        }
        if (this.mInput.next(theInputId)) {
            int aIndex = this.lookupIndexInHeap(theInputId);
            this.refreshActual(aIndex);
            this.mSortedHeap[aIndex] = theInputId;
            return aIndex;
        }
        this.mInputsDone[theInputId] = true;
        --this.mActualInputsCount;
        return -1;
    }

    private void refreshActual(int theIndex) {
        this.mLeftActual = Math.min(this.mLeftActual, theIndex);
        this.mRightActual = Math.max(this.mRightActual, theIndex);
    }

    private int lookupIndexInHeap(int theInputId) {
        if (this.mLeftActual == this.mInputsCount) {
            return 0;
        }
        if (this.mActualInputsCount == 1) {
            return this.mLeftUsed;
        }
        int aLeftBoundary = this.mLeftActual;
        int aRightBoundary = this.mRightActual;
        int aHeapIndexId = this.middle(aLeftBoundary, aRightBoundary);
        while (true) {
            if (this.mSortedHeap[aHeapIndexId] == -1) {
                if (aHeapIndexId == 0) {
                    return 0;
                }
                aRightBoundary = aHeapIndexId;
                aHeapIndexId = this.middle(aLeftBoundary, aRightBoundary);
                continue;
            }
            IndexDirection aDirection = this.getIndexDirection(theInputId, this.mSortedHeap[aHeapIndexId]);
            if (aDirection == IndexDirection.RIGHT) {
                if (aHeapIndexId == aRightBoundary) {
                    return this.handleBoundary(aRightBoundary, IndexDirection.RIGHT);
                }
                aLeftBoundary = aHeapIndexId + 1;
                aHeapIndexId = this.nextRightIndex(aRightBoundary, aHeapIndexId);
                continue;
            }
            if (aHeapIndexId == aLeftBoundary) {
                return this.handleBoundary(aLeftBoundary, aDirection);
            }
            aRightBoundary = aHeapIndexId - 1;
            aHeapIndexId = this.nextLeftIndex(aLeftBoundary, aHeapIndexId);
        }
    }

    private int handleBoundary(int theBoundary, IndexDirection theDirection) {
        if (theDirection == IndexDirection.LEFT) {
            int resultIndex = theBoundary - 1;
            if (resultIndex > 0 && this.mSortedHeap[resultIndex] == -1) {
                return resultIndex;
            }
        } else {
            int resultIndex = theBoundary + 1;
            if (resultIndex < this.mInputsCount && this.mSortedHeap[resultIndex] == -1) {
                return resultIndex;
            }
        }
        return this.shiftHeap(theBoundary, theDirection);
    }

    private int nextLeftIndex(int theLeftBoundary, int theHeapIndexId) {
        theHeapIndexId = theHeapIndexId - 1 != theLeftBoundary ? this.middle(theLeftBoundary, theHeapIndexId) : theLeftBoundary;
        return theHeapIndexId;
    }

    private int nextRightIndex(int theRightBoundary, int theHeapIndexId) {
        theHeapIndexId = theHeapIndexId + 1 != theRightBoundary ? this.middle(theRightBoundary, theHeapIndexId) : theRightBoundary;
        return theHeapIndexId;
    }

    protected final int compare(int theLeftInputId, int theRightInputId) {
        int aCmpResult = this.compare0(theLeftInputId, theRightInputId);
        return this.mDirection == SortOrder.ASC ? aCmpResult : -aCmpResult;
    }

    protected abstract int compare0(int var1, int var2);

    private int shiftHeap(int theIndex, IndexDirection theDirection) {
        if (this.mLeftActual > 0 && theIndex > 0) {
            return this.moveToLeft(theDirection == IndexDirection.LEFT ? theIndex - 1 : theIndex);
        }
        if (theIndex < this.mInputsCount - 1) {
            return this.moveToRight(theDirection == IndexDirection.LEFT ? theIndex : theIndex + 1);
        }
        throw new IllegalStateException("Fatal error inside heap sorter");
    }

    private int moveToLeft(int theIndex) {
        this.shiftToLeft(this.mSortedHeap, theIndex);
        --this.mLeftActual;
        return theIndex;
    }

    private int moveToRight(int theIndex) {
        this.shiftToRight(this.mSortedHeap, theIndex);
        ++this.mRightActual;
        return theIndex;
    }

    private void shiftToLeft(int[] theArray, int theIndex) {
        System.arraycopy(theArray, 1, theArray, 0, theIndex);
    }

    private void shiftToRight(int[] theArray, int theIndex) {
        System.arraycopy(theArray, theIndex, theArray, theIndex + 1, this.mInputsCount - theIndex - 1);
    }

    protected IndexDirection getIndexDirection(int theNextInputId, int theHeapInputId) {
        return this.handleDirection(this.compare(theNextInputId, theHeapInputId));
    }

    protected IndexDirection handleDirection(int theResult) {
        return theResult < 0 ? IndexDirection.LEFT : IndexDirection.RIGHT;
    }

    private int middle(int theIndex1, int theIndex2) {
        return (theIndex1 + theIndex2) / 2;
    }

    protected int[] reuseIfPossible(int[] theArray, int theCnt) {
        return theArray == null || theArray.length < theCnt ? new int[theCnt] : theArray;
    }

    protected boolean[] reuseIfPossible(boolean[] theArray, int theCnt) {
        return theArray == null || theArray.length < theCnt ? new boolean[theCnt] : theArray;
    }

    protected static enum IndexDirection {
        LEFT,
        RIGHT;

    }
}

