/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.sort.sorters.heap;

import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.OutputCollector;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.iterator.MultiInputIterator;
import com.complexible.memory.structure.sort.sorters.heap.BaseHeapSorter;
import java.util.Arrays;

abstract class BaseHashTableHeapSorter<I extends MultiInputIterator, O extends OutputCollector>
extends BaseHeapSorter<I, O> {
    protected int[] mSegmentStack;
    protected int mSegmentStackIndex;
    protected boolean[] mSegmentMarkers;
    protected final boolean mUniquesMode;
    protected final MemoryContext mMemoryContext;

    public BaseHashTableHeapSorter(MemoryContext theMemoryContext, boolean theUniquesMode) {
        super(SortOrder.ASC);
        this.mUniquesMode = theUniquesMode;
        this.mMemoryContext = theMemoryContext;
    }

    @Override
    protected boolean emitElement(int theInputId) {
        if (this.mSegmentMarkers[theInputId]) {
            this.mSegmentStack[this.mSegmentStackIndex] = theInputId;
            ++this.mSegmentStackIndex;
            this.mSegmentMarkers[theInputId] = false;
            return false;
        }
        if (this.mSegmentStackIndex > 0) {
            if (this.mUniquesMode) {
                this.emitSingle(theInputId, 1L);
                this.clearSegmentStack();
            } else {
                this.emitAll(theInputId);
            }
            return true;
        }
        this.emitSingle(theInputId, this.getInputRecordsCount(theInputId));
        return true;
    }

    @Override
    protected void initSortedHeap(I theInput) {
        super.initSortedHeap(theInput);
        this.mSegmentMarkers = this.reuseIfPossible(this.mSegmentMarkers, theInput.availableInputsCount());
        this.mSegmentStack = this.reuseIfPossible(this.mSegmentStack, theInput.availableInputsCount());
        Arrays.fill(this.mSegmentMarkers, false);
        this.clearSegmentStack();
    }

    protected void emitSingle(int theInputId, long theRecordsCount) {
        this.emitSegment(theInputId, theRecordsCount);
        this.emitInput(theInputId);
    }

    protected void emitAll(int theInputId) {
        this.emitSegment(this.mSegmentStack[0], this.calculateStackRecordsCount(theInputId));
        this.emitStack();
        this.emitInput(theInputId);
        this.clearSegmentStack();
    }

    protected void emitStack() {
        for (int i = 0; i < this.mSegmentStackIndex; ++i) {
            this.emitInput(this.mSegmentStack[i]);
        }
    }

    private long calculateStackRecordsCount(int theInputId) {
        long aRecordsCount = this.getInputRecordsCount(theInputId);
        for (int i = 0; i < this.mSegmentStackIndex; ++i) {
            aRecordsCount += this.getInputRecordsCount(this.mSegmentStack[i]);
        }
        return aRecordsCount;
    }

    private void clearSegmentStack() {
        Arrays.fill(this.mSegmentStack, -1);
        this.mSegmentStackIndex = 0;
    }

    @Override
    protected abstract int compare0(int var1, int var2);

    protected abstract long getInputRecordsCount(int var1);

    protected void emitSegment(int theInputId, long theRecordsCount) {
    }

    protected void emitInput(int theInputId) {
    }
}

